/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import org.mule.runtime.core.api.util.StringUtils;

public class SocketRequester {
    private final String host;
    private final int port;
    private boolean initialized = false;
    private Socket socket = null;
    private BufferedReader bufferedReader = null;
    private PrintWriter printWriter = null;

    public SocketRequester(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void initialize() throws IOException {
        if (!this.initialized) {
            this.socket = new Socket(this.host, this.port);
            this.printWriter = new PrintWriter(this.socket.getOutputStream());
            this.bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.initialized = true;
        }
    }

    public void doRequest(String requestText) throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("Socket Requester has not been initialized");
        }
        this.printWriter.println(requestText);
        this.printWriter.println("Host: " + this.host);
        this.printWriter.println("");
        this.printWriter.flush();
    }

    public String getResponse() throws IOException {
        String outputString;
        if (!this.initialized) {
            throw new IllegalStateException("Socket Requester has not been initialized");
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (!StringUtils.isEmpty((String)(outputString = this.bufferedReader.readLine()))) {
            stringBuilder.append(outputString).append(System.lineSeparator());
        }
        while (!StringUtils.isEmpty((String)(outputString = this.bufferedReader.readLine()))) {
            stringBuilder.append(outputString).append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    public void finalize() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.printWriter != null) {
            this.printWriter.close();
        }
        if (this.bufferedReader != null) {
            this.bufferedReader.close();
        }
    }

    public void finalizeGracefully() {
        try {
            this.finalize();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

