/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.providers.grizzly.GrizzlyResponseBodyPart;
import com.ning.http.client.providers.grizzly.PauseHandler;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.impl.service.client.NonBlockingStreamWriter;
import org.mule.service.http.impl.service.client.async.ResponseBodyDeferringAsyncHandler;
import org.mule.service.http.impl.util.TimedPipedInputStream;
import org.mule.service.http.impl.util.TimedPipedOutputStream;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.slf4j.MDC;

@Feature(value="HTTP Service")
@Story(value="Streaming")
public class ResponseBodyDeferringAsyncHandlerTestCase
extends AbstractMuleTestCase {
    private static final int PROBE_TIMEOUT = 5000;
    private static final int POLL_DELAY = 300;
    private static final int BUFFER_SIZE = 1024;
    private final PauseHandler pauseHandler = (PauseHandler)Mockito.mock(PauseHandler.class);
    private final ExecutorService testExecutor = Executors.newSingleThreadExecutor();
    private final PollingProber prober = new PollingProber(5000L, 300L);
    private final ExecutorService workersExecutor = Executors.newFixedThreadPool(5);
    private final NonBlockingStreamWriter nonBlockingStreamWriter = new NonBlockingStreamWriter(100, true);
    private static final String READ_TIMEOUT_PROPERTY_NAME = "mule.http.responseStreaming.pipeReadTimeoutMillis";

    @Before
    public void setup() {
        System.setProperty(READ_TIMEOUT_PROPERTY_NAME, "100");
        ResponseBodyDeferringAsyncHandler.refreshSystemProperties();
    }

    @After
    public void tearDown() {
        System.clearProperty(READ_TIMEOUT_PROPERTY_NAME);
        ResponseBodyDeferringAsyncHandler.refreshSystemProperties();
    }

    @Test
    public void doesNotStreamWhenPossible() throws Exception {
        CompletableFuture future = new CompletableFuture();
        Reference responseContent = new Reference();
        ResponseBodyDeferringAsyncHandler handler = new ResponseBodyDeferringAsyncHandler(future, 1024, this.workersExecutor, this.nonBlockingStreamWriter);
        handler.onStatusReceived((HttpResponseStatus)Mockito.mock(HttpResponseStatus.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        GrizzlyResponseBodyPart bodyPart = this.mockBodyPart(true, new byte[0]);
        future.whenComplete((response, exception) -> {
            InputStream cfr_ignored_0 = (InputStream)responseContent.set((Object)response.getEntity().getContent());
        });
        MatcherAssert.assertThat((Object)handler.onBodyPartReceived((HttpResponseBodyPart)bodyPart), (Matcher)Matchers.is((Object)AsyncHandler.STATE.CONTINUE));
        this.prober.check((Probe)new JUnitLambdaProbe(() -> {
            MatcherAssert.assertThat((Object)responseContent.get(), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimedPipedInputStream.class)));
            return true;
        }));
    }

    @Test
    public void streamsWhenRequired() throws Exception {
        CompletableFuture future = new CompletableFuture();
        Reference responseContent = new Reference();
        ResponseBodyDeferringAsyncHandler handler = new ResponseBodyDeferringAsyncHandler(future, 1024, this.workersExecutor, this.nonBlockingStreamWriter);
        handler.onStatusReceived((HttpResponseStatus)Mockito.mock(HttpResponseStatus.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        GrizzlyResponseBodyPart bodyPart = this.mockBodyPart(false, new byte[0]);
        future.whenComplete((response, exception) -> {
            InputStream cfr_ignored_0 = (InputStream)responseContent.set((Object)response.getEntity().getContent());
        });
        MatcherAssert.assertThat((Object)handler.onBodyPartReceived((HttpResponseBodyPart)bodyPart), (Matcher)Matchers.is((Object)AsyncHandler.STATE.CONTINUE));
        this.prober.check((Probe)new JUnitLambdaProbe(() -> {
            MatcherAssert.assertThat((Object)responseContent.get(), (Matcher)Matchers.instanceOf(TimedPipedInputStream.class));
            return true;
        }));
    }

    @Test
    @Issue(value="MULE-19208")
    public void handlerAbortsResponseWhenAnErrorOccurred() throws Exception {
        CompletableFuture future = new CompletableFuture();
        ResponseBodyDeferringAsyncHandler handler = new ResponseBodyDeferringAsyncHandler(future, 1024, this.workersExecutor, this.nonBlockingStreamWriter);
        GrizzlyResponseBodyPart bodyPart = this.mockBodyPart(false, new byte[0]);
        handler.onStatusReceived((HttpResponseStatus)Mockito.mock(HttpResponseStatus.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        handler.onThrowable((Throwable)new TimeoutException("Timeout exceeded"));
        AsyncHandler.STATE state = handler.onBodyPartReceived((HttpResponseBodyPart)bodyPart);
        MatcherAssert.assertThat((Object)state, (Matcher)Matchers.is((Object)AsyncHandler.STATE.ABORT));
        this.prober.check((Probe)new JUnitLambdaProbe(future::isCompletedExceptionally));
    }

    @Test
    @Issue(value="MULE-19208")
    public void handlerDoesNotTryToWriteAPartIfAnErrorOccurred() throws Exception {
        CompletableFuture future = new CompletableFuture();
        ResponseBodyDeferringAsyncHandler handler = new ResponseBodyDeferringAsyncHandler(future, 1024, this.workersExecutor, this.nonBlockingStreamWriter);
        GrizzlyResponseBodyPart bodyPart = this.mockBodyPart(false, new byte[0]);
        handler.onStatusReceived((HttpResponseStatus)Mockito.mock(HttpResponseStatus.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        handler.onThrowable((Throwable)new TimeoutException("Timeout exceeded"));
        handler.onBodyPartReceived((HttpResponseBodyPart)bodyPart);
        ((GrizzlyResponseBodyPart)Mockito.verify((Object)bodyPart, (VerificationMode)Mockito.never())).writeTo((OutputStream)ArgumentMatchers.any(TimedPipedOutputStream.class));
    }

    @Test
    @Issue(value="MULE-19208")
    public void handlerClosesPipedStreamIfAnErrorOccurredBetweenTwoParts() throws Exception {
        CompletableFuture future = new CompletableFuture();
        ResponseBodyDeferringAsyncHandler handler = new ResponseBodyDeferringAsyncHandler(future, 1024, this.workersExecutor, this.nonBlockingStreamWriter);
        GrizzlyResponseBodyPart bodyPartBeforeError = this.mockBodyPart(false, new byte[0]);
        GrizzlyResponseBodyPart bodyPartAfterError = this.mockBodyPart(false, new byte[0]);
        handler.onStatusReceived((HttpResponseStatus)Mockito.mock(HttpResponseStatus.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        MatcherAssert.assertThat((Object)handler.onBodyPartReceived((HttpResponseBodyPart)bodyPartBeforeError), (Matcher)Matchers.is((Object)AsyncHandler.STATE.CONTINUE));
        handler.onThrowable((Throwable)new TimeoutException("Timeout exceeded"));
        MatcherAssert.assertThat((Object)handler.onBodyPartReceived((HttpResponseBodyPart)bodyPartAfterError), (Matcher)Matchers.is((Object)AsyncHandler.STATE.ABORT));
        this.prober.check((Probe)new JUnitLambdaProbe(() -> {
            byte[] result = new byte[16];
            return ((HttpResponse)future.get()).getEntity().getContent().read(result) == -1;
        }));
    }

    @Test
    @Issue(value="MULE-19208")
    public void handlerDoesNotTryToWriteAPartIfAnErrorOccurredBetweenTwoParts() throws Exception {
        CompletableFuture future = new CompletableFuture();
        ResponseBodyDeferringAsyncHandler handler = new ResponseBodyDeferringAsyncHandler(future, 1024, this.workersExecutor, this.nonBlockingStreamWriter);
        GrizzlyResponseBodyPart bodyPartBeforeError = this.mockBodyPart(false, new byte[0]);
        GrizzlyResponseBodyPart bodyPartAfterError = this.mockBodyPart(false, new byte[0]);
        handler.onStatusReceived((HttpResponseStatus)Mockito.mock(HttpResponseStatus.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        MatcherAssert.assertThat((Object)handler.onBodyPartReceived((HttpResponseBodyPart)bodyPartBeforeError), (Matcher)Matchers.is((Object)AsyncHandler.STATE.CONTINUE));
        handler.onThrowable((Throwable)new TimeoutException("Timeout exceeded"));
        MatcherAssert.assertThat((Object)handler.onBodyPartReceived((HttpResponseBodyPart)bodyPartAfterError), (Matcher)Matchers.is((Object)AsyncHandler.STATE.ABORT));
        ((GrizzlyResponseBodyPart)Mockito.verify((Object)bodyPartBeforeError, (VerificationMode)Mockito.times((int)1))).writeTo((OutputStream)ArgumentMatchers.any(TimedPipedOutputStream.class));
        ((GrizzlyResponseBodyPart)Mockito.verify((Object)bodyPartAfterError, (VerificationMode)Mockito.never())).writeTo((OutputStream)ArgumentMatchers.any(TimedPipedOutputStream.class));
    }

    @Test
    @Issue(value="MULE-19208")
    public void readerDoesNotBlockWhenNobodyWroteInTheStreamYet() throws Exception {
        CompletableFuture future = new CompletableFuture();
        ResponseBodyDeferringAsyncHandler handler = new ResponseBodyDeferringAsyncHandler(future, 1024, this.workersExecutor, this.nonBlockingStreamWriter);
        GrizzlyResponseBodyPart bodyPart = (GrizzlyResponseBodyPart)Mockito.mock(GrizzlyResponseBodyPart.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)bodyPart.isLast()).thenReturn((Object)false);
        Mockito.when((Object)bodyPart.getBodyPartBytes()).thenReturn((Object)"payload".getBytes());
        Mockito.when((Object)bodyPart.getBodyByteBuffer()).thenReturn((Object)ByteBuffer.allocateDirect(0));
        handler.onStatusReceived((HttpResponseStatus)Mockito.mock(HttpResponseStatus.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        Latch writeLatch = new Latch();
        ((GrizzlyResponseBodyPart)Mockito.doAnswer(invocation -> {
            writeLatch.await();
            return invocation.callRealMethod();
        }).when((Object)bodyPart)).writeTo((OutputStream)ArgumentMatchers.any(TimedPipedOutputStream.class));
        this.testExecutor.submit(() -> {
            try {
                MatcherAssert.assertThat((Object)handler.onBodyPartReceived((HttpResponseBodyPart)bodyPart), (Matcher)Matchers.is((Object)AsyncHandler.STATE.CONTINUE));
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        });
        this.prober.check((Probe)new JUnitLambdaProbe(() -> {
            byte[] result = new byte[16];
            int bytesRead = ((HttpResponse)future.get()).getEntity().getContent().read(result);
            return bytesRead == 0;
        }));
        writeLatch.release();
        MatcherAssert.assertThat((Object)handler.onBodyPartReceived((HttpResponseBodyPart)bodyPart), (Matcher)Matchers.is((Object)AsyncHandler.STATE.CONTINUE));
        handler.onCompleted();
        this.prober.check((Probe)new JUnitLambdaProbe(() -> {
            byte[] result = new byte[16];
            return ((HttpResponse)future.get()).getEntity().getContent().read(result) == -1;
        }));
    }

    @Test
    public void abortsWhenPipeIsClosed() throws Exception {
        CompletableFuture future = new CompletableFuture();
        ResponseBodyDeferringAsyncHandler handler = new ResponseBodyDeferringAsyncHandler(future, 1024, this.workersExecutor, this.nonBlockingStreamWriter);
        handler.onStatusReceived((HttpResponseStatus)Mockito.mock(HttpResponseStatus.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        GrizzlyResponseBodyPart bodyPart = this.mockBodyPart(false, "You will call me Snowball because my fur is pretty and white.".getBytes());
        handler.onBodyPartReceived((HttpResponseBodyPart)bodyPart);
        handler.closeOut();
        MatcherAssert.assertThat((Object)handler.onBodyPartReceived((HttpResponseBodyPart)bodyPart), (Matcher)Matchers.is((Object)AsyncHandler.STATE.ABORT));
    }

    @Test
    public void doesNotThrowExceptionIfContentLengthIsGreaterThanMaxInteger() throws Exception {
        CompletableFuture future = new CompletableFuture();
        ResponseBodyDeferringAsyncHandler handler = new ResponseBodyDeferringAsyncHandler(future, -1, this.workersExecutor, this.nonBlockingStreamWriter);
        handler.onStatusReceived((HttpResponseStatus)Mockito.mock(HttpResponseStatus.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        FluentCaseInsensitiveStringsMap headersMap = (FluentCaseInsensitiveStringsMap)Mockito.mock(FluentCaseInsensitiveStringsMap.class);
        Mockito.when((Object)headersMap.getFirstValue("Content-Length")).thenReturn((Object)Long.toString(0xFFFFFFFEL));
        Mockito.when((Object)headersMap.getFirstValue("Transfer-Encoding")).thenReturn((Object)"");
        HttpResponseHeaders headers = (HttpResponseHeaders)Mockito.mock(HttpResponseHeaders.class);
        Mockito.when((Object)headers.getHeaders()).thenReturn((Object)headersMap);
        MatcherAssert.assertThat((Object)handler.onHeadersReceived(headers), (Matcher)Matchers.is((Object)AsyncHandler.STATE.CONTINUE));
    }

    @Test
    @Issue(value="W-16640190")
    public void readFromPipeInWhenCompleteDoesNotCauseADeadlock() throws Exception {
        CompletableFuture future = new CompletableFuture();
        Reference responseContent = new Reference();
        ResponseBodyDeferringAsyncHandler handler = new ResponseBodyDeferringAsyncHandler(future, 1024, this.workersExecutor, this.nonBlockingStreamWriter);
        handler.onStatusReceived((HttpResponseStatus)Mockito.mock(HttpResponseStatus.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        GrizzlyResponseBodyPart intermediatePart = this.mockBodyPart(false, "Hello ".getBytes());
        GrizzlyResponseBodyPart lastPart = this.mockBodyPart(true, "world".getBytes());
        future.whenComplete((response, exception) -> {
            String responseAsString = IOUtils.toString((InputStream)response.getEntity().getContent());
            responseContent.set((Object)responseAsString);
        });
        MatcherAssert.assertThat((Object)handler.onBodyPartReceived((HttpResponseBodyPart)intermediatePart), (Matcher)Matchers.is((Object)AsyncHandler.STATE.CONTINUE));
        MatcherAssert.assertThat((Object)handler.onBodyPartReceived((HttpResponseBodyPart)lastPart), (Matcher)Matchers.is((Object)AsyncHandler.STATE.CONTINUE));
        MatcherAssert.assertThat((Object)handler.onCompleted(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        this.prober.check((Probe)new JUnitLambdaProbe(() -> {
            MatcherAssert.assertThat((Object)responseContent.get(), (Matcher)Matchers.is((Object)"Hello world"));
            return true;
        }));
    }

    @Test
    @Issue(value="W-17048606")
    public void writePartBiggerThanBufferResultsInAsyncWrite() throws Exception {
        System.clearProperty(READ_TIMEOUT_PROPERTY_NAME);
        ResponseBodyDeferringAsyncHandler.refreshSystemProperties();
        int smallBufferSize = 5;
        CompletableFuture future = new CompletableFuture();
        ResponseBodyDeferringAsyncHandler handler = new ResponseBodyDeferringAsyncHandler(future, smallBufferSize, this.workersExecutor, this.nonBlockingStreamWriter);
        GrizzlyResponseBodyPart intermediatePart = this.mockBodyPart(false, "Hello ".getBytes());
        GrizzlyResponseBodyPart lastPart = this.mockBodyPart(true, "world!".getBytes());
        MatcherAssert.assertThat((Object)handler.onStatusReceived((HttpResponseStatus)Mockito.mock(HttpResponseStatus.class, (Answer)Mockito.RETURNS_DEEP_STUBS)), (Matcher)Matchers.is((Object)AsyncHandler.STATE.CONTINUE));
        MatcherAssert.assertThat((Object)handler.onBodyPartReceived((HttpResponseBodyPart)intermediatePart), (Matcher)Matchers.is((Object)AsyncHandler.STATE.CONTINUE));
        ((PauseHandler)Mockito.verify((Object)this.pauseHandler)).requestPause();
        HttpResponse response = (HttpResponse)future.get();
        InputStream pipe = response.getEntity().getContent();
        MatcherAssert.assertThat((Object)pipe, (Matcher)Matchers.instanceOf(TimedPipedInputStream.class));
        MatcherAssert.assertThat((Object)pipe.available(), (Matcher)Matchers.is((Object)smallBufferSize));
        ((PauseHandler)Mockito.verify((Object)this.pauseHandler, (VerificationMode)Mockito.never())).resume();
        StringBuilder responseAsString = new StringBuilder();
        this.testExecutor.submit(() -> ResponseBodyDeferringAsyncHandlerTestCase.consumePipe(pipe, responseAsString));
        this.workersExecutor.submit((Runnable)this.nonBlockingStreamWriter);
        this.prober.check((Probe)new JUnitLambdaProbe(() -> {
            ((PauseHandler)Mockito.verify((Object)this.pauseHandler, (VerificationMode)Mockito.atLeastOnce())).resume();
            return true;
        }));
        MatcherAssert.assertThat((Object)handler.onBodyPartReceived((HttpResponseBodyPart)lastPart), (Matcher)Matchers.is((Object)AsyncHandler.STATE.CONTINUE));
        this.prober.check((Probe)new JUnitLambdaProbe(() -> {
            StringBuilder stringBuilder = responseAsString;
            synchronized (stringBuilder) {
                MatcherAssert.assertThat((Object)responseAsString.toString(), (Matcher)Matchers.is((Object)"Hello world!"));
            }
            return true;
        }));
        MatcherAssert.assertThat((Object)handler.onCompleted(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        this.nonBlockingStreamWriter.stop();
    }

    @Test
    @Issue(value="W-17048606")
    public void asyncWriteHappensWithSameTCCL() throws Exception {
        System.clearProperty(READ_TIMEOUT_PROPERTY_NAME);
        ResponseBodyDeferringAsyncHandler.refreshSystemProperties();
        int smallBufferSize = 5;
        String randomKey = UUID.getUUID();
        MDC.put((String)randomKey, (String)"TestValue");
        final HashMap mdcSeenOnThrowable = new HashMap();
        CompletableFuture future = new CompletableFuture();
        ResponseBodyDeferringAsyncHandler handler = new ResponseBodyDeferringAsyncHandler(future, smallBufferSize, this.workersExecutor, this.nonBlockingStreamWriter){

            public void onThrowable(Throwable t) {
                mdcSeenOnThrowable.putAll(MDC.getCopyOfContextMap());
                super.onThrowable(t);
            }
        };
        GrizzlyResponseBodyPart nonLastPart = this.mockBodyPart(false, "Hello ".getBytes());
        MatcherAssert.assertThat((Object)handler.onStatusReceived((HttpResponseStatus)Mockito.mock(HttpResponseStatus.class, (Answer)Mockito.RETURNS_DEEP_STUBS)), (Matcher)Matchers.is((Object)AsyncHandler.STATE.CONTINUE));
        MatcherAssert.assertThat((Object)handler.onBodyPartReceived((HttpResponseBodyPart)nonLastPart), (Matcher)Matchers.is((Object)AsyncHandler.STATE.CONTINUE));
        HttpResponse response = (HttpResponse)future.get();
        response.getEntity().getContent().close();
        this.workersExecutor.submit((Runnable)this.nonBlockingStreamWriter);
        this.prober.check((Probe)new JUnitLambdaProbe(() -> {
            MatcherAssert.assertThat(mdcSeenOnThrowable.get(randomKey), (Matcher)Matchers.is((Object)"TestValue"));
            return true;
        }));
        MDC.remove((String)randomKey);
    }

    @Test
    @Issue(value="W-17617940")
    public void writeLastPartAsyncAfterOnComplete() throws Exception {
        System.clearProperty(READ_TIMEOUT_PROPERTY_NAME);
        ResponseBodyDeferringAsyncHandler.refreshSystemProperties();
        int smallBufferSize = 5;
        CompletableFuture future = new CompletableFuture();
        ResponseBodyDeferringAsyncHandler handler = new ResponseBodyDeferringAsyncHandler(future, smallBufferSize, this.workersExecutor, this.nonBlockingStreamWriter);
        GrizzlyResponseBodyPart intermediatePart = this.mockBodyPart(false, "Hel".getBytes());
        GrizzlyResponseBodyPart lastPart = this.mockBodyPart(true, "lo world!".getBytes());
        handler.onStatusReceived((HttpResponseStatus)Mockito.mock(HttpResponseStatus.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        handler.onBodyPartReceived((HttpResponseBodyPart)intermediatePart);
        handler.onBodyPartReceived((HttpResponseBodyPart)lastPart);
        handler.onCompleted();
        InputStream pipe = ((HttpResponse)future.get()).getEntity().getContent();
        MatcherAssert.assertThat((Object)pipe.available(), (Matcher)Matchers.is((Object)smallBufferSize));
        StringBuilder responseAsString = new StringBuilder();
        this.testExecutor.submit(() -> ResponseBodyDeferringAsyncHandlerTestCase.consumePipe(pipe, responseAsString));
        this.workersExecutor.submit((Runnable)this.nonBlockingStreamWriter);
        this.prober.check((Probe)new JUnitLambdaProbe(() -> {
            StringBuilder stringBuilder = responseAsString;
            synchronized (stringBuilder) {
                MatcherAssert.assertThat((Object)responseAsString.toString(), (Matcher)Matchers.is((Object)"Hello world!"));
            }
            return true;
        }));
        this.nonBlockingStreamWriter.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void consumePipe(InputStream pipe, StringBuilder responseStringBuilder) {
        boolean keepReading = true;
        while (keepReading) {
            try {
                int b = pipe.read();
                if (b == -1) {
                    keepReading = false;
                    continue;
                }
                StringBuilder stringBuilder = responseStringBuilder;
                synchronized (stringBuilder) {
                    responseStringBuilder.append((char)b);
                }
            }
            catch (IOException e) {
                Assert.fail((String)"Got exception reading from pipe");
            }
        }
    }

    private GrizzlyResponseBodyPart mockBodyPart(boolean isLast, byte[] content) throws IOException {
        GrizzlyResponseBodyPart bodyPart = (GrizzlyResponseBodyPart)Mockito.mock(GrizzlyResponseBodyPart.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)bodyPart.isLast()).thenReturn((Object)isLast);
        Mockito.when((Object)bodyPart.getBodyByteBuffer()).thenReturn((Object)ByteBuffer.wrap(content));
        Mockito.when((Object)bodyPart.getBodyPartBytes()).thenReturn((Object)content);
        Mockito.when((Object)bodyPart.length()).thenReturn((Object)content.length);
        Mockito.when((Object)bodyPart.getPauseHandler()).thenReturn((Object)this.pauseHandler);
        ((GrizzlyResponseBodyPart)Mockito.doAnswer(invocation -> {
            OutputStream outputStream = (OutputStream)invocation.getArgument(0);
            outputStream.write(content);
            return content.length;
        }).when((Object)bodyPart)).writeTo((OutputStream)ArgumentMatchers.any(OutputStream.class));
        return bodyPart;
    }
}

