/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import com.ning.http.client.AsyncHttpClientConfigDefaults;
import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.rules.BouncyCastleProviderCleaner;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;
import org.mule.tck.http.TestProxyServer;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public class GrizzlyHttpsClientProxyTestCase
extends AbstractHttpClientTestCase {
    private static final String PASS = "mulepassword";
    private static final String PROXY_AUTHORIZATION_HEADER = "Proxy-Authorization";
    @Rule
    public DynamicPort proxyPort = new DynamicPort("proxyPort");
    @Rule
    public SystemProperty useProxyProperties = new SystemProperty(AsyncHttpClientConfigDefaults.ASYNC_CLIENT + "useProxyProperties", "true");
    @Rule
    public SystemProperty proxyHostProperty = new SystemProperty("http.proxyHost", "localhost");
    @Rule
    public SystemProperty proxyPortProperty = new SystemProperty("http.proxyPort", this.proxyPort.getValue());
    private TestProxyServer proxyServer = new TestProxyServer(this.proxyPort.getNumber(), this.port.getNumber(), true);
    private HttpClient client;
    @Rule
    public BouncyCastleProviderCleaner bouncyCastleProviderCleaner = new BouncyCastleProviderCleaner();

    public GrizzlyHttpsClientProxyTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    private void ensureBouncyCastleProviders() {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
        Security.insertProviderAt((Provider)new BouncyCastleJsseProvider(), 2);
    }

    @Before
    public void createClient() throws Exception {
        this.ensureBouncyCastleProviders();
        this.proxyServer.start();
        this.client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setTlsContextFactory(TlsContextFactory.builder().trustStorePath("tls/trustStore").trustStorePassword(PASS).build()).setName("httpsProxyHeader-test").build());
        this.client.start();
    }

    @After
    public void stopClient() throws Exception {
        if (this.proxyServer != null) {
            this.proxyServer.stop();
        }
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        Assert.assertNull((Object)request.getHeaderValue(PROXY_AUTHORIZATION_HEADER));
        HttpResponseBuilder response = HttpResponse.builder();
        try {
            return response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode())).build();
        }
        catch (Exception e) {
            return response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode())).build();
        }
    }

    @Override
    protected HttpServerConfiguration.Builder getServerConfigurationBuilder() throws Exception {
        return super.getServerConfigurationBuilder().setTlsContextFactory(TlsContextFactory.builder().keyStorePath("tls/serverKeystore").keyStorePassword(PASS).keyPassword(PASS).build());
    }

    @Override
    protected String getUri() {
        return super.getUri().replace(HttpConstants.Protocol.HTTP.getScheme(), HttpConstants.Protocol.HTTPS.getScheme());
    }

    @Test
    @Issue(value="W-10863931")
    @Description(value="An HTTPS request with a basic proxy does not have to add an NTLM header.")
    public void basicHttpsRequestDoesNotSendNtlmProxyHeader() throws Exception {
        HttpResponse response = this.client.send(HttpRequest.builder().method(HttpConstants.Method.POST).uri(this.getUri()).build(), this.getDefaultOptions(10000));
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
    }
}

