/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.service.http.impl.service.server.grizzly.BlockingTransferInputStream;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class BlockingTransferInputStreamTestCase
extends AbstractMuleTestCase {
    final FilterChainContext fccMock = (FilterChainContext)Mockito.mock(FilterChainContext.class);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
    }

    @Test
    @Description(value="When there is a single chunk, reading returns the correct contents, including after the chunk is consumed.")
    public void basicRead() throws IOException {
        BlockingTransferInputStream inputStream = this.createStreamWithChunks("Some content");
        Assert.assertThat((Object)inputStream.read(), (Matcher)CoreMatchers.is((Object)83));
        byte[] data = new byte[3];
        Assert.assertThat((Object)inputStream.read(data), (Matcher)CoreMatchers.is((Object)data.length));
        Assert.assertThat((Object)new String(data), (Matcher)CoreMatchers.is((Object)"ome"));
        byte[] remainingData = new byte[100];
        Assert.assertThat((Object)inputStream.read(remainingData, 0, 100), (Matcher)CoreMatchers.is((Object)" content".length()));
        Assert.assertThat((Object)new String(remainingData, 0, " content".length()), (Matcher)CoreMatchers.is((Object)" content"));
        Assert.assertThat((Object)inputStream.read(data), (Matcher)CoreMatchers.is((Object)-1));
        Assert.assertThat((Object)inputStream.read(remainingData), (Matcher)CoreMatchers.is((Object)-1));
        Assert.assertThat((Object)inputStream.read(remainingData, 0, 100), (Matcher)CoreMatchers.is((Object)-1));
    }

    @Test
    @Description(value="When there are multiple chunks, reading returns the correct contents, including after the chunk is consumed.")
    public void basicReadMultipleChunks() throws IOException {
        BlockingTransferInputStream inputStream = this.createStreamWithChunks("Some content", ", ", "Other content");
        Assert.assertThat((Object)inputStream.read(), (Matcher)CoreMatchers.is((Object)83));
        byte[] data = new byte[3];
        Assert.assertThat((Object)inputStream.read(data), (Matcher)CoreMatchers.is((Object)data.length));
        Assert.assertThat((Object)new String(data), (Matcher)CoreMatchers.is((Object)"ome"));
        byte[] remainingData = new byte[100];
        Assert.assertThat((Object)inputStream.read(remainingData, 0, 100), (Matcher)CoreMatchers.is((Object)" content".length()));
        Assert.assertThat((Object)new String(remainingData, 0, " content".length()), (Matcher)CoreMatchers.is((Object)" content"));
        Assert.assertThat((Object)inputStream.read(remainingData, 0, 100), (Matcher)CoreMatchers.is((Object)", ".length()));
        Assert.assertThat((Object)new String(remainingData, 0, ", ".length()), (Matcher)CoreMatchers.is((Object)", "));
        Assert.assertThat((Object)inputStream.read(remainingData, 0, 100), (Matcher)CoreMatchers.is((Object)"Other content".length()));
        Assert.assertThat((Object)new String(remainingData, 0, "Other content".length()), (Matcher)CoreMatchers.is((Object)"Other content"));
        Assert.assertThat((Object)inputStream.read(data), (Matcher)CoreMatchers.is((Object)-1));
        Assert.assertThat((Object)inputStream.read(remainingData), (Matcher)CoreMatchers.is((Object)-1));
        Assert.assertThat((Object)inputStream.read(remainingData, 0, 100), (Matcher)CoreMatchers.is((Object)-1));
    }

    @Test
    @Issue(value="MULE-19951")
    @Description(value="When reading after blocking reads are not allowed, the proper exception is thrown if a read that requires blocking is performed.")
    public void whenReadAfterNotAllowedReturnsIllegalStateException() throws IOException {
        BlockingTransferInputStream inputStream = this.createStreamWithChunks("Some content", ", ", "More content");
        ((FilterChainContext)Mockito.verify((Object)this.fccMock, (VerificationMode)Mockito.times((int)0))).read();
        Assert.assertThat((Object)inputStream.read(), (Matcher)CoreMatchers.is((Object)83));
        inputStream.preventFurtherBlockingReading("for the sake of testing");
        byte[] data = new byte[10];
        Assert.assertThat((Object)inputStream.read(data), (Matcher)CoreMatchers.is((Object)data.length));
        Assert.assertThat((Object)new String(data), (Matcher)CoreMatchers.is((Object)"ome conten"));
        byte[] remainingData = new byte[100];
        Assert.assertThat((Object)inputStream.read(remainingData, 0, 100), (Matcher)CoreMatchers.is((Object)"t".length()));
        Assert.assertThat((Object)new String(remainingData, 0, "t".length()), (Matcher)CoreMatchers.is((Object)"t"));
        this.expectedException.expect(CoreMatchers.instanceOf(IllegalStateException.class));
        inputStream.read(remainingData, 0, 100);
        inputStream.read(remainingData);
        inputStream.read();
        ((FilterChainContext)Mockito.verify((Object)this.fccMock, (VerificationMode)Mockito.times((int)0))).read();
    }

    @Test
    @Issue(value="MULE-19951")
    @Description(value="When reading after blocking reads are not allowed, no exception is thrown if all contents are available.")
    public void whenContentIsBufferedAndReadAfterNotAllowedSucceeds() throws IOException {
        BlockingTransferInputStream inputStream = this.createStreamWithChunks("Some content");
        ((FilterChainContext)Mockito.verify((Object)this.fccMock, (VerificationMode)Mockito.times((int)0))).read();
        inputStream.preventFurtherBlockingReading("for the sake of testing");
        byte[] data = new byte[100];
        Assert.assertThat((Object)inputStream.read(data), (Matcher)CoreMatchers.is((Object)"Some content".length()));
        Assert.assertThat((Object)new String(data, 0, "Some content".length()), (Matcher)CoreMatchers.is((Object)"Some content"));
        Assert.assertThat((Object)inputStream.read(data, 0, 100), (Matcher)CoreMatchers.is((Object)-1));
        Assert.assertThat((Object)inputStream.read(data), (Matcher)CoreMatchers.is((Object)-1));
        Assert.assertThat((Object)inputStream.read(), (Matcher)CoreMatchers.is((Object)-1));
        ((FilterChainContext)Mockito.verify((Object)this.fccMock, (VerificationMode)Mockito.times((int)0))).read();
    }

    private BlockingTransferInputStream createStreamWithChunks(String ... chunks) throws IOException {
        Iterator chunksIterator = Arrays.stream(chunks).iterator();
        HttpContent httpContent = this.httpContentFromString((String)chunksIterator.next(), chunksIterator.hasNext());
        Iterator readResults = Stream.generate(() -> this.readResultFromString((String)chunksIterator.next(), chunksIterator.hasNext())).limit(chunks.length - 1).collect(Collectors.toList()).iterator();
        Mockito.when((Object)this.fccMock.getMessage()).thenReturn((Object)httpContent);
        Mockito.when((Object)this.fccMock.read()).thenAnswer(invocation -> (ReadResult)readResults.next());
        HttpHeader httpHeaderMock = (HttpHeader)Mockito.mock(HttpHeader.class);
        Mockito.when((Object)httpHeaderMock.isExpectContent()).thenAnswer(invocation -> readResults.hasNext());
        return new BlockingTransferInputStream(httpHeaderMock, this.fccMock);
    }

    private HttpContent httpContentFromString(String content, boolean last) {
        HttpHeader httpHeaderMock = (HttpHeader)Mockito.mock(HttpHeader.class);
        return HttpContent.builder((HttpHeader)httpHeaderMock).last(last).content(Buffers.wrap((MemoryManager)MemoryManager.DEFAULT_MEMORY_MANAGER, (String)content)).build();
    }

    private ReadResult<HttpContent, ?> readResultFromString(String content, boolean last) {
        HttpContent httpContent = this.httpContentFromString(content, last);
        return ReadResult.create(null, (Object)httpContent, null, (int)0);
    }
}

