/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.impl.service.client.GrizzlyHttpClient;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class GrizzlyHttpClientLifecycleTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final int DEFAULT_SELECTOR_THREAD_COUNT = Integer.getInteger(GrizzlyHttpClient.class.getName() + ".DEFAULT_SELECTOR_THREAD_COUNT", Integer.max(Runtime.getRuntime().availableProcessors(), 2));

    @Test
    public void cannotSendWhenNotStarted() throws Exception {
        HttpClient client = this.validateClientUsage();
        client.send(this.getHttpRequest());
    }

    @Test
    public void cannotSendAsyncWhenNotStarted() {
        HttpClient client = this.validateClientUsage();
        client.sendAsync(this.getHttpRequest());
    }

    @Test
    public void testSchedulerSize() {
        SchedulerService schedulerService = (SchedulerService)Mockito.mock(SchedulerService.class);
        SchedulerConfig schedulerConfig = (SchedulerConfig)Mockito.mock(SchedulerConfig.class);
        Scheduler selectorsScheduler = (Scheduler)Mockito.mock(Scheduler.class);
        Mockito.when((Object)schedulerService.customScheduler((SchedulerConfig)ArgumentMatchers.any(), ArgumentMatchers.anyInt())).thenReturn((Object)selectorsScheduler);
        Scheduler workersScheduler = (Scheduler)Mockito.mock(Scheduler.class);
        Mockito.when((Object)schedulerService.ioScheduler((SchedulerConfig)ArgumentMatchers.any())).thenReturn((Object)workersScheduler);
        Mockito.when((Object)schedulerConfig.withDirectRunCpuLightWhenTargetBusy(ArgumentMatchers.anyBoolean())).thenReturn((Object)schedulerConfig);
        Mockito.when((Object)schedulerConfig.withMaxConcurrentTasks(ArgumentMatchers.anyInt())).thenReturn((Object)schedulerConfig);
        Mockito.when((Object)schedulerConfig.withName(ArgumentMatchers.anyString())).thenReturn((Object)schedulerConfig);
        GrizzlyHttpClient client = new GrizzlyHttpClient((HttpClientConfiguration)Mockito.mock(HttpClientConfiguration.class, (Answer)Mockito.RETURNS_DEEP_STUBS), schedulerService, schedulerConfig);
        client.start();
        ((SchedulerService)Mockito.verify((Object)schedulerService, (VerificationMode)Mockito.times((int)1))).customScheduler((SchedulerConfig)ArgumentMatchers.any(), ArgumentMatchers.eq((int)DEFAULT_SELECTOR_THREAD_COUNT));
    }

    private HttpClient validateClientUsage() {
        GrizzlyHttpClient client = new GrizzlyHttpClient((HttpClientConfiguration)Mockito.mock(HttpClientConfiguration.class, (Answer)Mockito.RETURNS_DEEP_STUBS), (SchedulerService)Mockito.mock(SchedulerService.class), (SchedulerConfig)Mockito.mock(SchedulerConfig.class));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("The client must be started before use.");
        return client;
    }

    private HttpRequest getHttpRequest() {
        return HttpRequest.builder().uri("http://localhost:8081/").build();
    }
}

