/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.runtime.http.api.tcp.TcpServerSocketProperties;
import org.mule.service.http.impl.service.server.DefaultServerAddress;
import org.mule.service.http.impl.service.server.HttpListenerRegistry;
import org.mule.service.http.impl.service.server.ServerAddressMap;
import org.mule.service.http.impl.service.server.ServerIdentifier;
import org.mule.service.http.impl.service.server.grizzly.AbstractGrizzlyServerManagerTestCase;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyAddressDelegateFilter;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyServerManager;
import org.mule.service.http.impl.service.server.grizzly.WorkManagerSourceExecutorProvider;
import org.mule.tck.junit4.rule.SystemProperty;

@Feature(value="HTTP Service")
@Story(value="Server Management")
public class HttpGrizzlyServerManagerTestCase
extends AbstractGrizzlyServerManagerTestCase {
    private final TlsContextFactory tlsContextFactory = TlsContextFactory.builder().buildDefault();

    @After
    public void tearDown() {
        GrizzlyServerManager.refreshSystemProperties();
    }

    @Override
    protected HttpServer getServer(ServerAddress address, ServerIdentifier id) throws ServerCreationException {
        return this.serverManager.createServerFor(address, () -> muleContext.getSchedulerService().ioScheduler(), true, (int)TimeUnit.SECONDS.toMillis(60L), id, () -> muleContext.getConfiguration().getShutdownTimeout());
    }

    @Test
    public void serverIsHttp() throws Exception {
        HttpServer createdServer = this.getServer((ServerAddress)new DefaultServerAddress(HttpConstants.ALL_INTERFACES_ADDRESS, this.listenerPort.getNumber()), new ServerIdentifier("context", "name"));
        try {
            Assert.assertThat((Object)createdServer.getProtocol(), (Matcher)Matchers.is((Object)HttpConstants.Protocol.HTTP));
        }
        finally {
            createdServer.dispose();
        }
    }

    @Test
    public void enableTls() throws Exception {
        HttpServer createdServer = this.getServer((ServerAddress)new DefaultServerAddress(HttpConstants.ALL_INTERFACES_ADDRESS, this.listenerPort.getNumber()), new ServerIdentifier("context", "name"));
        try {
            Assert.assertThat((Object)createdServer.getProtocol(), (Matcher)Matchers.is((Object)HttpConstants.Protocol.HTTP));
            createdServer.enableTls(this.tlsContextFactory);
            Assert.assertThat((Object)createdServer.getProtocol(), (Matcher)Matchers.is((Object)HttpConstants.Protocol.HTTPS));
        }
        finally {
            createdServer.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Issue(value="MULE-19779")
    @Description(value="Tests that by default the read timeout field of TCPNIOTransport is set to 30 seconds")
    public void setDefaultReadTimeoutTo30secs() throws Exception {
        HttpServer createdServer = this.getServer((ServerAddress)new DefaultServerAddress(HttpConstants.ALL_INTERFACES_ADDRESS, this.listenerPort.getNumber()), new ServerIdentifier("context", "name"));
        try {
            Field transportField = GrizzlyServerManager.class.getDeclaredField("transport");
            transportField.setAccessible(true);
            TCPNIOTransport tcpnioTransport = (TCPNIOTransport)transportField.get(this.serverManager);
            Assert.assertThat((Object)tcpnioTransport.getReadTimeout(TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)30000L));
        }
        finally {
            createdServer.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Issue(value="MULE-19779")
    @Description(value="Tests that, when specified, the read timeout field of TCPNIOTransport is set to a custom value")
    public void setCustomReadTimeoutTo20secs() throws Exception {
        long readTimeout = 20000L;
        HttpServer createdServer = this.serverManager.createServerFor((ServerAddress)new DefaultServerAddress(HttpConstants.ALL_INTERFACES_ADDRESS, this.listenerPort.getNumber()), () -> muleContext.getSchedulerService().ioScheduler(), true, (int)TimeUnit.SECONDS.toMillis(60L), new ServerIdentifier("context", "name"), () -> muleContext.getConfiguration().getShutdownTimeout(), readTimeout);
        try {
            Field transportField = GrizzlyServerManager.class.getDeclaredField("transport");
            transportField.setAccessible(true);
            TCPNIOTransport tcpnioTransport = (TCPNIOTransport)transportField.get(this.serverManager);
            Assert.assertThat((Object)tcpnioTransport.getReadTimeout(TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)readTimeout));
        }
        finally {
            createdServer.dispose();
        }
    }

    @Test
    public void symmetricUsageOfWorkManagerSourceExecutorProviderOnStartAndStop() throws ServerCreationException, IOException {
        HttpServer createdServer = this.getServer((ServerAddress)new DefaultServerAddress(HttpConstants.ALL_INTERFACES_ADDRESS, this.listenerPort.getNumber()), new ServerIdentifier("context", "name"));
        int adds = 0;
        int removes = 0;
        this.assertProviderUsage(adds, removes);
        for (int i = 0; i < 3; ++i) {
            createdServer.start();
            this.assertProviderUsage(++adds, removes);
            createdServer.stop();
            this.assertProviderUsage(adds, ++removes);
        }
        createdServer.dispose();
        this.assertProviderUsage(adds, removes);
    }

    private void assertProviderUsage(int adds, int removes) {
        ((WorkManagerSourceExecutorProvider)Mockito.verify((Object)((HttpGrizzlyServerManagerTestDecorator)this.serverManager).getSpiedExecutorProvider(), (VerificationMode)Mockito.times((int)adds))).addExecutor((ServerAddress)ArgumentMatchers.any(), (Supplier)ArgumentMatchers.any());
        ((WorkManagerSourceExecutorProvider)Mockito.verify((Object)((HttpGrizzlyServerManagerTestDecorator)this.serverManager).getSpiedExecutorProvider(), (VerificationMode)Mockito.times((int)removes))).removeExecutor((ServerAddress)ArgumentMatchers.any());
    }

    @Issue(value="MULE-19837")
    @Description(value="When the max number of request and response headers are NOT set by System Properties, they should be assigned correctly by default. We check that the variables are properly set because we are delegating the max headers amount check to Grizzly")
    @Test
    public void testMaxRequestAndResponseHeadersIfNotSetBySystemPropertyAreSetByDefault() throws Throwable {
        GrizzlyServerManager.refreshSystemProperties();
        HttpServerFilter httpServerFilter = this.getHttpServerFilter(this.serverManager);
        Assert.assertThat((Object)this.getMaxHeaders(httpServerFilter, "maxRequestHeaders"), (Matcher)Matchers.is((Object)100));
        Assert.assertThat((Object)this.getMaxHeaders(httpServerFilter, "maxResponseHeaders"), (Matcher)Matchers.is((Object)100));
    }

    @Issue(value="MULE-19837")
    @Description(value="When the max number of request headers are set by System Properties, they should be assigned correctly. We check that the variables are properly set because we are delegating the max headers amount check to Grizzly")
    @Test
    public void testMaxRequestHeadersCanBeSetBySystemProperty() throws Throwable {
        String maxSetRequestHeaders = "80";
        GrizzlyServerManager grizzlyServerManager = (GrizzlyServerManager)SystemProperty.callWithProperty((String)"mule.http.MAX_SERVER_REQUEST_HEADERS", (String)maxSetRequestHeaders, this::refreshSystemPropertiesAndCreateServerManager);
        HttpServerFilter httpServerFilter = this.getHttpServerFilter(grizzlyServerManager);
        Assert.assertThat((Object)this.getMaxHeaders(httpServerFilter, "maxRequestHeaders"), (Matcher)Matchers.is((Object)Integer.parseInt(maxSetRequestHeaders)));
    }

    @Issue(value="MULE-19837")
    @Description(value="When the max number of response headers are set by System Properties, they should be assigned correctly. We check that the variables are properly set because we are delegating the max headers amount check to Grizzly")
    @Test
    public void testMaxResponseHeadersCanBeSetBySystemProperty() throws Throwable {
        String maxSetResponseHeaders = "70";
        GrizzlyServerManager grizzlyServerManager = (GrizzlyServerManager)SystemProperty.callWithProperty((String)"mule.http.MAX_SERVER_RESPONSE_HEADERS", (String)maxSetResponseHeaders, this::refreshSystemPropertiesAndCreateServerManager);
        HttpServerFilter httpServerFilter = this.getHttpServerFilter(grizzlyServerManager);
        Assert.assertThat((Object)this.getMaxHeaders(httpServerFilter, "maxResponseHeaders"), (Matcher)Matchers.is((Object)Integer.parseInt(maxSetResponseHeaders)));
    }

    private GrizzlyServerManager refreshSystemPropertiesAndCreateServerManager() {
        GrizzlyServerManager.refreshSystemProperties();
        return new GrizzlyServerManager(Executors.newCachedThreadPool(), Executors.newCachedThreadPool(), Executors.newCachedThreadPool(), new HttpListenerRegistry(), (TcpServerSocketProperties)new AbstractGrizzlyServerManagerTestCase.DefaultTcpServerSocketProperties(), Runtime.getRuntime().availableProcessors());
    }

    private HttpServerFilter getHttpServerFilter(GrizzlyServerManager grizzlyServerManager) throws Throwable {
        DefaultServerAddress serverAddress = new DefaultServerAddress(HttpConstants.ALL_INTERFACES_ADDRESS, this.listenerPort.getNumber());
        grizzlyServerManager.createServerFor((ServerAddress)serverAddress, () -> muleContext.getSchedulerService().ioScheduler(), true, (int)TimeUnit.SECONDS.toMillis(60L), new ServerIdentifier("context", "name"), () -> muleContext.getConfiguration().getShutdownTimeout());
        Field httpServerFilterDelegate = GrizzlyServerManager.class.getDeclaredField("httpServerFilterDelegate");
        httpServerFilterDelegate.setAccessible(true);
        GrizzlyAddressDelegateFilter grizzlyAddressDelegateFilter = (GrizzlyAddressDelegateFilter)httpServerFilterDelegate.get(grizzlyServerManager);
        Field filters = GrizzlyAddressDelegateFilter.class.getDeclaredField("filters");
        filters.setAccessible(true);
        ServerAddressMap serverAddressMap = (ServerAddressMap)filters.get(grizzlyAddressDelegateFilter);
        return (HttpServerFilter)serverAddressMap.get((Object)serverAddress);
    }

    private int getMaxHeaders(HttpServerFilter httpServerFilter, String maxHeaders) throws NoSuchFieldException, IllegalAccessException {
        Field maxRequestHeadersField = HttpServerFilter.class.getDeclaredField(maxHeaders);
        maxRequestHeadersField.setAccessible(true);
        return (Integer)maxRequestHeadersField.get(httpServerFilter);
    }

    @Override
    protected HttpGrizzlyServerManagerTestDecorator createServerManager(HttpListenerRegistry registry, AbstractGrizzlyServerManagerTestCase.DefaultTcpServerSocketProperties socketProperties) {
        return new HttpGrizzlyServerManagerTestDecorator(this.selectorPool, this.workerPool, this.idleTimeoutExecutorService, registry, socketProperties, Runtime.getRuntime().availableProcessors());
    }

    private static class HttpGrizzlyServerManagerTestDecorator
    extends GrizzlyServerManager {
        WorkManagerSourceExecutorProvider spiedExecutorProvider;

        HttpGrizzlyServerManagerTestDecorator(ExecutorService selectorPool, ExecutorService workerPool, ExecutorService idleTimeoutExecutorService, HttpListenerRegistry httpListenerRegistry, TcpServerSocketProperties serverSocketProperties, int selectorCount) {
            super(selectorPool, workerPool, idleTimeoutExecutorService, httpListenerRegistry, serverSocketProperties, selectorCount);
        }

        protected WorkManagerSourceExecutorProvider createExecutorProvider() {
            this.spiedExecutorProvider = (WorkManagerSourceExecutorProvider)Mockito.spy((Object)new WorkManagerSourceExecutorProvider());
            return this.spiedExecutorProvider;
        }

        WorkManagerSourceExecutorProvider getSpiedExecutorProvider() {
            return this.spiedExecutorProvider;
        }
    }
}

