/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.util;

import io.qameta.allure.Issue;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.service.http.impl.util.TimedPipedInputStream;
import org.mule.service.http.impl.util.TimedPipedOutputStream;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Stories(value={@Story(value="Responses"), @Story(value="Streaming")})
public class TimedPipedInputStreamTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final ExecutorService writerExecutor = Executors.newSingleThreadExecutor();
    private final AtomicInteger timesCallbackWasCalled = new AtomicInteger();
    private final Runnable onSpaceCallback = this.timesCallbackWasCalled::incrementAndGet;

    @Test
    public void itBehavesInAFIFOWayWhenWritingBytes() throws IOException {
        TimedPipedOutputStream out = new TimedPipedOutputStream();
        TimedPipedInputStream in = new TimedPipedInputStream(2, 10L, TimeUnit.MILLISECONDS, out, this.onSpaceCallback);
        out.write(1);
        out.write(2);
        MatcherAssert.assertThat((Object)in.read(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)in.read(), (Matcher)Matchers.is((Object)2));
        out.write(3);
        MatcherAssert.assertThat((Object)in.read(), (Matcher)Matchers.is((Object)3));
        out.write(4);
        out.write(5);
        MatcherAssert.assertThat((Object)in.read(), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)in.read(), (Matcher)Matchers.is((Object)5));
    }

    @Test
    public void itBehavesInAFIFOWayWhenWritingBuffers() throws IOException {
        TimedPipedOutputStream out = new TimedPipedOutputStream();
        TimedPipedInputStream in = new TimedPipedInputStream(5, 10L, TimeUnit.MILLISECONDS, out, this.onSpaceCallback);
        byte[] receiveBuf = new byte[2];
        out.write(new byte[]{1, 2, 3});
        MatcherAssert.assertThat((Object)in.read(receiveBuf), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)receiveBuf[0], (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)receiveBuf[1], (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)in.read(receiveBuf), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)receiveBuf[0], (Matcher)Matchers.is((Object)3));
        out.write(new byte[]{4, 5, 6, 7, 8});
        MatcherAssert.assertThat((Object)in.read(receiveBuf), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)in.read(receiveBuf), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)in.read(receiveBuf), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)receiveBuf[0], (Matcher)Matchers.is((Object)8));
    }

    @Test
    @Issue(value="MULE-19232")
    public void returnZeroAfterTimeoutWhenUsingBuffer() throws IOException {
        TimedPipedOutputStream out = new TimedPipedOutputStream();
        TimedPipedInputStream in = new TimedPipedInputStream(5, 10L, TimeUnit.MILLISECONDS, out, this.onSpaceCallback);
        byte[] receiveBuf = new byte[2];
        MatcherAssert.assertThat((Object)in.read(receiveBuf), (Matcher)Matchers.is((Object)0));
        out.write(new byte[]{1, 2, 3});
        MatcherAssert.assertThat((Object)in.read(receiveBuf), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)in.read(receiveBuf), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)in.read(receiveBuf), (Matcher)Matchers.is((Object)0));
    }

    @Test
    @Issue(value="MULE-19232")
    public void throwsExceptionAfterTimeoutWhenRequestingByte() throws IOException {
        TimedPipedOutputStream out = new TimedPipedOutputStream();
        TimedPipedInputStream in = new TimedPipedInputStream(5, 10L, TimeUnit.MILLISECONDS, out, this.onSpaceCallback);
        this.expectedException.expect(Matchers.instanceOf(IOException.class));
        this.expectedException.expectCause(Matchers.instanceOf(TimeoutException.class));
        in.read();
    }

    @Test
    @Issue(value="MULE-19232")
    public void throwsExceptionAfterTimeoutWhenRequestingByteAfterSomeBytes() throws IOException {
        TimedPipedOutputStream out = new TimedPipedOutputStream();
        TimedPipedInputStream in = new TimedPipedInputStream(5, 10L, TimeUnit.MILLISECONDS, out, this.onSpaceCallback);
        out.write(new byte[]{1, 2, 3});
        MatcherAssert.assertThat((Object)in.read(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)in.read(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)in.read(), (Matcher)Matchers.is((Object)3));
        this.expectedException.expect(Matchers.instanceOf(IOException.class));
        this.expectedException.expectCause(Matchers.instanceOf(TimeoutException.class));
        in.read();
    }

    @Test
    public void readerAndWriterInDifferentThreadsWithAPayloadThatDoesNotFitIntoTheBuffer() throws IOException, InterruptedException {
        TimedPipedOutputStream out = new TimedPipedOutputStream();
        TimedPipedInputStream in = new TimedPipedInputStream(5, 10L, TimeUnit.MILLISECONDS, out, this.onSpaceCallback);
        String testData = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.";
        Latch dataWritten = new Latch();
        this.writerExecutor.submit(() -> {
            try {
                out.write(testData.getBytes());
                dataWritten.release();
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        });
        StringBuilder sb = new StringBuilder();
        while (sb.length() != testData.length()) {
            byte[] buffer = new byte[64];
            int currentRead = in.read(buffer);
            sb.append(new String(buffer, 0, currentRead));
        }
        dataWritten.await();
        MatcherAssert.assertThat((Object)sb.toString(), (Matcher)Matchers.is((Object)testData));
    }

    @Test
    @Issue(value="W-17627284")
    public void callbackIsCalledWhenSpaceIsGenerated() throws IOException {
        String payloadThatFillsTheBuffer = "Lorem ipsum dolor sit amet";
        TimedPipedOutputStream out = new TimedPipedOutputStream();
        TimedPipedInputStream in = new TimedPipedInputStream(payloadThatFillsTheBuffer.length(), 10L, TimeUnit.HOURS, out, this.onSpaceCallback);
        out.write(payloadThatFillsTheBuffer.getBytes());
        MatcherAssert.assertThat((Object)this.timesCallbackWasCalled.get(), (Matcher)Matchers.is((Object)0));
        byte[] readBuf = new byte[2];
        in.read(readBuf);
        MatcherAssert.assertThat((Object)this.timesCallbackWasCalled.get(), (Matcher)Matchers.is((Object)1));
        in.read(readBuf);
        MatcherAssert.assertThat((Object)this.timesCallbackWasCalled.get(), (Matcher)Matchers.is((Object)1));
        in.read(readBuf);
        MatcherAssert.assertThat((Object)this.timesCallbackWasCalled.get(), (Matcher)Matchers.is((Object)1));
        out.write(payloadThatFillsTheBuffer.getBytes(), 0, 6);
        in.read(readBuf);
        MatcherAssert.assertThat((Object)this.timesCallbackWasCalled.get(), (Matcher)Matchers.is((Object)2));
    }
}

