/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.service.http.impl.service.server.DefaultServerAddress;
import org.mule.service.http.impl.service.server.ServerIdentifier;
import org.mule.service.http.impl.service.server.grizzly.AbstractGrizzlyServerManagerTestCase;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyServerManager;

@Feature(value="HTTP Service")
@Story(value="Server Management")
public class HttpsGrizzlyServerManagerTestCase
extends AbstractGrizzlyServerManagerTestCase {
    private final TlsContextFactory tlsContextFactory = TlsContextFactory.builder().buildDefault();

    @Override
    protected HttpServer getServer(ServerAddress address, ServerIdentifier id) throws ServerCreationException {
        return this.serverManager.createSslServerFor(this.tlsContextFactory, () -> muleContext.getSchedulerService().ioScheduler(), address, true, (int)TimeUnit.SECONDS.toMillis(60L), id, () -> muleContext.getConfiguration().getShutdownTimeout());
    }

    @Test
    public void sslServerIsHttps() throws Exception {
        HttpServer createdServer = this.getServer((ServerAddress)new DefaultServerAddress(HttpConstants.ALL_INTERFACES_ADDRESS, this.listenerPort.getNumber()), new ServerIdentifier("context", "name"));
        try {
            Assert.assertThat((Object)createdServer.getProtocol(), (Matcher)Matchers.is((Object)HttpConstants.Protocol.HTTPS));
        }
        finally {
            createdServer.dispose();
        }
    }

    @Test
    public void disableTls() throws Exception {
        HttpServer createdServer = this.getServer((ServerAddress)new DefaultServerAddress(HttpConstants.ALL_INTERFACES_ADDRESS, this.listenerPort.getNumber()), new ServerIdentifier("context", "name"));
        try {
            Assert.assertThat((Object)createdServer.getProtocol(), (Matcher)Matchers.is((Object)HttpConstants.Protocol.HTTPS));
            createdServer.disableTls();
            Assert.assertThat((Object)createdServer.getProtocol(), (Matcher)Matchers.is((Object)HttpConstants.Protocol.HTTP));
        }
        finally {
            createdServer.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Issue(value="MULE-19779")
    @Description(value="Tests that by default the read timeout field of TCPNIOTransport is set to 30 seconds")
    public void setDefaultReadTimeoutTo30secs() throws Exception {
        HttpServer createdServer = this.getServer((ServerAddress)new DefaultServerAddress(HttpConstants.ALL_INTERFACES_ADDRESS, this.listenerPort.getNumber()), new ServerIdentifier("context", "name"));
        try {
            Field transportField = GrizzlyServerManager.class.getDeclaredField("transport");
            transportField.setAccessible(true);
            TCPNIOTransport tcpnioTransport = (TCPNIOTransport)transportField.get(this.serverManager);
            Assert.assertThat((Object)tcpnioTransport.getReadTimeout(TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)30000L));
        }
        finally {
            createdServer.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Issue(value="MULE-19779")
    @Description(value="Tests that, when specified, the read timeout field of TCPNIOTransport is set to a custom value")
    public void setCustomReadTimeoutTo20secs() throws Exception {
        long readTimeout = 20000L;
        HttpServer createdServer = this.serverManager.createServerFor((ServerAddress)new DefaultServerAddress(HttpConstants.ALL_INTERFACES_ADDRESS, this.listenerPort.getNumber()), () -> muleContext.getSchedulerService().ioScheduler(), true, (int)TimeUnit.SECONDS.toMillis(60L), new ServerIdentifier("context", "name"), () -> muleContext.getConfiguration().getShutdownTimeout(), readTimeout);
        try {
            Field transportField = GrizzlyServerManager.class.getDeclaredField("transport");
            transportField.setAccessible(true);
            TCPNIOTransport tcpnioTransport = (TCPNIOTransport)transportField.get(this.serverManager);
            Assert.assertThat((Object)tcpnioTransport.getReadTimeout(TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)readTimeout));
        }
        finally {
            createdServer.dispose();
        }
    }
}

