/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.util;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import java.net.URI;
import java.net.URISyntaxException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.impl.service.util.RedirectUtils;

@RunWith(value=MockitoJUnitRunner.class)
@Feature(value="HTTP Service")
@Issue(value="MULE-19908")
public class RedirectUtilsTestCase {
    @Mock
    private HttpResponse response;
    @Mock
    private HttpRequest originalRequest;
    private final MultiMap<String, String> responseHeaders = new MultiMap();

    @Before
    public void setup() throws URISyntaxException {
        URI originalRequestURI = new URI("http://somehost/originalPath?param=original");
        MultiMap originalRequestHeaders = new MultiMap();
        HttpEntity originalRequestEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)this.originalRequest.getUri()).thenReturn((Object)originalRequestURI);
        Mockito.when((Object)this.originalRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.originalRequest.getProtocol()).thenReturn((Object)HttpProtocol.HTTP_1_1);
        Mockito.when((Object)this.originalRequest.getHeaders()).thenReturn((Object)originalRequestHeaders);
        Mockito.when((Object)this.originalRequest.getEntity()).thenReturn((Object)originalRequestEntity);
        Mockito.when((Object)this.response.getHeaders()).thenReturn(this.responseHeaders);
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)301);
        this.responseHeaders.put((Object)"Location", (Object)"http://redirecthost/redirectPath");
    }

    @Test
    public void redirectedRequestWithHostUsesQueryParamsFromResponseLocation() {
        this.testRedirectRequest("http://redirecthost/redirectPath?param=redirect");
    }

    @Test
    public void redirectedRequestWithoutHostUsesQueryParamsFromResponseLocation() {
        this.testRedirectRequest("/redirectPath?param=redirect");
    }

    private void testRedirectRequest(String path) {
        this.setLocationHeader(path);
        HttpRequest redirectedRequest = RedirectUtils.createRedirectRequest((HttpResponse)this.response, (HttpRequest)this.originalRequest);
        Assert.assertThat((Object)redirectedRequest.getUri().getRawQuery(), (Matcher)Matchers.is((Object)"param=redirect"));
    }

    private void setLocationHeader(String path) {
        this.responseHeaders.removeAll((Object)"Location");
        this.responseHeaders.put((Object)"Location", (Object)path);
    }
}

