/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import io.qameta.allure.Feature;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.service.http.impl.service.server.grizzly.ExecutorPerServerAddressIOStrategy;
import org.mule.service.http.impl.service.server.grizzly.ExecutorProvider;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
@Feature(value="HTTP Service")
public class ExecutorPerServerAddressIOStrategyTestCase
extends AbstractMuleTestCase {
    @Mock
    private ExecutorProvider executorProvider;
    @Mock
    private Connection connection;
    @Mock
    private Executor executor;
    @Mock
    private AttributeHolder attributeHolder;
    private IOStrategy ioStrategy;

    @Before
    public void before() throws UnknownHostException {
        this.ioStrategy = new ExecutorPerServerAddressIOStrategy(this.executorProvider);
        Mockito.when((Object)this.connection.getLocalAddress()).thenReturn((Object)new InetSocketAddress(InetAddress.getLocalHost(), 80));
        Mockito.when((Object)this.executorProvider.getExecutor((ServerAddress)Mockito.any(ServerAddress.class))).thenReturn((Object)this.executor);
        Mockito.when((Object)this.connection.getAttributes()).thenReturn((Object)this.attributeHolder);
    }

    @Test
    public void acceptIOEventDoesNotUseExecutor() {
        Assert.assertThat((Object)this.ioStrategy.getThreadPoolFor(this.connection, IOEvent.SERVER_ACCEPT), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void readIOEventDoesNotUseExecutor() {
        Assert.assertThat((Object)this.ioStrategy.getThreadPoolFor(this.connection, IOEvent.READ), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void writeIOEventDoesNotUseExecutor() {
        Assert.assertThat((Object)this.ioStrategy.getThreadPoolFor(this.connection, IOEvent.WRITE), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void closeIOEventDoesNotUseExecutor() {
        Assert.assertThat((Object)this.ioStrategy.getThreadPoolFor(this.connection, IOEvent.CLOSED), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void acceptIOEventDoesNotUseExecutorWhenDelegatePropertyInTrue() {
        Mockito.when((Object)this.attributeHolder.getAttribute(ArgumentMatchers.matches((String)"__WRITES_TO_IO__"))).thenReturn((Object)true);
        Assert.assertThat((Object)this.ioStrategy.getThreadPoolFor(this.connection, IOEvent.SERVER_ACCEPT), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void readIOEventDoesNotUseExecutorWhenDelegatePropertyInTrue() {
        Mockito.when((Object)this.attributeHolder.getAttribute(ArgumentMatchers.matches((String)"__WRITES_TO_IO__"))).thenReturn((Object)true);
        Assert.assertThat((Object)this.ioStrategy.getThreadPoolFor(this.connection, IOEvent.READ), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void writeIOEventUsesExecutorWhenDelegatePropertyInTrue() {
        Mockito.when((Object)this.attributeHolder.getAttribute(ArgumentMatchers.matches((String)"__WRITES_TO_IO__"))).thenReturn((Object)true);
        Assert.assertThat((Object)this.ioStrategy.getThreadPoolFor(this.connection, IOEvent.WRITE), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.executor)));
    }

    @Test
    public void closeIOEventDoesNotUseExecutorWhenDelegatePropertyInTrue() {
        Mockito.when((Object)this.attributeHolder.getAttribute(ArgumentMatchers.matches((String)"__WRITES_TO_IO__"))).thenReturn((Object)true);
        Assert.assertThat((Object)this.ioStrategy.getThreadPoolFor(this.connection, IOEvent.CLOSED), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void acceptIOEventDoesNotUseExecutorWhenDelegatePropertyInFalse() {
        Mockito.when((Object)this.attributeHolder.getAttribute(ArgumentMatchers.matches((String)"__WRITES_TO_IO__"))).thenReturn((Object)false);
        Assert.assertThat((Object)this.ioStrategy.getThreadPoolFor(this.connection, IOEvent.SERVER_ACCEPT), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void readIOEventDoesNotUseExecutorWhenDelegatePropertyInFalse() {
        Mockito.when((Object)this.attributeHolder.getAttribute(ArgumentMatchers.matches((String)"__WRITES_TO_IO__"))).thenReturn((Object)false);
        Assert.assertThat((Object)this.ioStrategy.getThreadPoolFor(this.connection, IOEvent.READ), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void writeIOEventDoesNotUseExecutorWhenDelegatePropertyInFalse() {
        Mockito.when((Object)this.attributeHolder.getAttribute(ArgumentMatchers.matches((String)"__WRITES_TO_IO__"))).thenReturn((Object)false);
        Assert.assertThat((Object)this.ioStrategy.getThreadPoolFor(this.connection, IOEvent.WRITE), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void closeIOEventDoesNotUseExecutorWhenDelegatePropertyInFalse() {
        Mockito.when((Object)this.attributeHolder.getAttribute(ArgumentMatchers.matches((String)"__WRITES_TO_IO__"))).thenReturn((Object)false);
        Assert.assertThat((Object)this.ioStrategy.getThreadPoolFor(this.connection, IOEvent.CLOSED), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

