/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.service.http.impl.service.server.grizzly.HttpParser;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@Feature(value="HTTP Service")
@Story(value="Parsing")
public class HttpParserTestCase
extends AbstractMuleTestCase {
    private static final String CONTENT_ID = "someContentId";
    private static final String MULTIPART_RELATED_WITH_CONTENT_ID = String.format("--the-boundary\r\nContent-Type: text/plain\r\nContent-ID: %s\r\n\r\ncontent\r\n--the-boundary\r\n", "someContentId");

    @Test
    public void normalizePath() {
        String expectedNormalizedPath = " some path";
        Assert.assertThat((Object)HttpParser.normalizePathWithSpacesOrEncodedSpaces((String)expectedNormalizedPath), (Matcher)Is.is((Object)expectedNormalizedPath));
        Assert.assertThat((Object)HttpParser.normalizePathWithSpacesOrEncodedSpaces((String)"%20some%20path"), (Matcher)Is.is((Object)expectedNormalizedPath));
        Assert.assertThat((Object)HttpParser.normalizePathWithSpacesOrEncodedSpaces((String)"+some+path"), (Matcher)Is.is((Object)expectedNormalizedPath));
        Assert.assertThat((Object)HttpParser.normalizePathWithSpacesOrEncodedSpaces((String)"%20some+path"), (Matcher)Is.is((Object)expectedNormalizedPath));
        Assert.assertThat((Object)HttpParser.normalizePathWithSpacesOrEncodedSpaces((String)"+some%20path"), (Matcher)Is.is((Object)expectedNormalizedPath));
    }

    @Test
    public void partWithoutNameButWithPresentContentIdHeader() throws IOException {
        ByteArrayInputStream content = new ByteArrayInputStream(MULTIPART_RELATED_WITH_CONTENT_ID.getBytes());
        Collection httpPartCollection = HttpParser.parseMultipartContent((InputStream)content, (String)MediaType.MULTIPART_RELATED.toString());
        Assert.assertThat((Object)httpPartCollection.size(), (Matcher)Is.is((Object)1));
        HttpPart httpPart = (HttpPart)httpPartCollection.iterator().next();
        Assert.assertThat((Object)httpPart.getName(), (Matcher)Is.is((Object)CONTENT_ID));
    }
}

