/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.TestLogger;
import com.github.valfirst.slf4jtest.TestLoggerFactory;
import io.qameta.allure.Description;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.service.http.impl.functional.server.AbstractHttpServerTestCase;
import org.mule.service.http.impl.service.server.HttpListenerRegistry;
import org.mule.service.http.impl.service.server.HttpServerDelegate;
import org.mule.service.http.impl.service.server.NoListenerRequestHandler;
import org.mule.service.http.impl.service.server.grizzly.BaseResponseCompletionHandler;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyHttpServer;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public class HttpBrokenPipeLoggingConfigTestCase
extends AbstractHttpServerTestCase {
    private CountDownLatch requestLatch;
    private CountDownLatch responseLatch;
    private ClassLoader requestHandlerClassLoader;
    private RequestMatcherRegistry<RequestHandler> serverAddressRequestHandlerRegistry;
    private TestLogger testLogger = TestLoggerFactory.getTestLogger(BaseResponseCompletionHandler.class);

    public HttpBrokenPipeLoggingConfigTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void setUp() throws Exception {
        GrizzlyHttpServer.refreshSystemProperties();
        this.requestLatch = new CountDownLatch(1);
        this.responseLatch = new CountDownLatch(1);
        this.setUpServer();
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        this.requestHandlerClassLoader = CompositeClassLoader.from((ClassLoader[])new ClassLoader[]{Thread.currentThread().getContextClassLoader()});
        ClassUtils.setContextClassLoader((Thread)currentThread, (ClassLoader)originalClassLoader, (ClassLoader)this.requestHandlerClassLoader);
        try {
            this.server.addRequestHandler(Collections.singletonList(HttpConstants.Method.POST.name()), "/brokenPipe", (RequestHandler)new ServerErrorResponseHandler());
        }
        finally {
            ClassUtils.setContextClassLoader((Thread)currentThread, (ClassLoader)this.requestHandlerClassLoader, (ClassLoader)originalClassLoader);
        }
        this.createRequestMatcherRegistrySpy();
    }

    @Override
    protected String getServerName() {
        return "broken-pipe-logging-test";
    }

    @Test
    @Description(value="Verifies that HTTP broken pipe errors are logged in the app log for an app endpoint by checking the TCCL when the log was created")
    public void brokenPipeErrorOnAppEndpointShouldBeLoggedOnTheAppLog() throws Exception {
        this.sendRequest("brokenPipe");
        this.responseLatch.await();
        new PollingProber(30000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)this.testLogger.getAllLoggingEvents().size(), (Matcher)Matchers.is((Object)1));
            Assert.assertThat((Object)((LoggingEvent)this.testLogger.getAllLoggingEvents().get(0)).getThreadContextClassLoader(), (Matcher)Matchers.is((Object)this.requestHandlerClassLoader));
            return true;
        }));
    }

    @Test
    @Description(value="Verifies that HTTP broken pipe errors are logged in the runtime log for unmapped paths by checking the TCCL when the log was created")
    public void brokenPipeErrorOnUnmappedEndpointShouldBeLoggedOnTheRuntimeLog() throws Exception {
        ((RequestMatcherRegistry)Mockito.doReturn((Object)new NotFoundResponseHandler()).when(this.serverAddressRequestHandlerRegistry)).find((HttpRequest)ArgumentMatchers.any());
        this.sendRequest("unmapped");
        this.responseLatch.await();
        new PollingProber(30000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)this.testLogger.getAllLoggingEvents().size(), (Matcher)Matchers.is((Object)1));
            Assert.assertThat((Object)((LoggingEvent)this.testLogger.getAllLoggingEvents().get(0)).getThreadContextClassLoader(), (Matcher)Matchers.is((Object)Thread.currentThread().getContextClassLoader()));
            return true;
        }));
    }

    private void createRequestMatcherRegistrySpy() throws NoSuchFieldException, IllegalAccessException {
        Field listenerRegistryField = GrizzlyHttpServer.class.getDeclaredField("listenerRegistry");
        listenerRegistryField.setAccessible(true);
        HttpServer serverDelegate = ((HttpServerDelegate)this.server).getDelegate();
        HttpListenerRegistry httpListenerRegistry = (HttpListenerRegistry)listenerRegistryField.get(serverDelegate);
        Field requestHandlerPerServerAddressField = HttpListenerRegistry.class.getDeclaredField("requestHandlerPerServerAddress");
        requestHandlerPerServerAddressField.setAccessible(true);
        Map requestHandlerPerServerAddress = (Map)requestHandlerPerServerAddressField.get(httpListenerRegistry);
        this.serverAddressRequestHandlerRegistry = (RequestMatcherRegistry)requestHandlerPerServerAddress.get(serverDelegate);
        this.serverAddressRequestHandlerRegistry = (RequestMatcherRegistry)Mockito.spy(this.serverAddressRequestHandlerRegistry);
        requestHandlerPerServerAddress.put(serverDelegate, this.serverAddressRequestHandlerRegistry);
    }

    private void sendRequest(String endpoint) throws IOException {
        try {
            Request.Post((String)String.format("http://localhost:%s/%s", this.port.getValue(), endpoint)).bodyString("That is not dead which can eternal lie, And with strange aeons even death may die.", ContentType.DEFAULT_TEXT).socketTimeout(1).addHeader("Connection", "close").execute().returnResponse();
            Assert.fail();
        }
        catch (SocketTimeoutException ste) {
            this.requestLatch.countDown();
        }
    }

    private ResponseStatusCallback getCountDownLatchResponseStatusCallbackWrapper(final ResponseStatusCallback responseStatusCallback) {
        return new ResponseStatusCallback(){

            public void responseSendFailure(Throwable throwable) {
                if (responseStatusCallback != null) {
                    responseStatusCallback.responseSendFailure(throwable);
                }
                HttpBrokenPipeLoggingConfigTestCase.this.responseLatch.countDown();
            }

            public void responseSendSuccessfully() {
                if (responseStatusCallback != null) {
                    responseStatusCallback.responseSendSuccessfully();
                }
                HttpBrokenPipeLoggingConfigTestCase.this.responseLatch.countDown();
            }

            public void onErrorSendingResponse(Throwable throwable) {
                if (responseStatusCallback != null) {
                    responseStatusCallback.onErrorSendingResponse(throwable);
                }
                HttpBrokenPipeLoggingConfigTestCase.this.responseLatch.countDown();
            }
        };
    }

    private HttpResponseReadyCallback getCountDownLatchHttpResponseReadyCallbackWrapper(final HttpResponseReadyCallback responseCallback) {
        return new HttpResponseReadyCallback(){

            public void responseReady(HttpResponse response, ResponseStatusCallback responseStatusCallback) {
                responseCallback.responseReady(response, HttpBrokenPipeLoggingConfigTestCase.this.getCountDownLatchResponseStatusCallbackWrapper(responseStatusCallback));
            }

            public Writer startResponse(HttpResponse response, ResponseStatusCallback responseStatusCallback, Charset encoding) {
                return responseCallback.startResponse(response, HttpBrokenPipeLoggingConfigTestCase.this.getCountDownLatchResponseStatusCallbackWrapper(responseStatusCallback), encoding);
            }
        };
    }

    private class NotFoundResponseHandler
    extends BrokenPipeCausingHandler {
        private NotFoundResponseHandler() {
        }

        @Override
        public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
            super.handleRequest(requestContext, responseCallback);
            NoListenerRequestHandler.getInstance().handleRequest(requestContext, HttpBrokenPipeLoggingConfigTestCase.this.getCountDownLatchHttpResponseReadyCallbackWrapper(responseCallback));
        }
    }

    private class ServerErrorResponseHandler
    extends BrokenPipeCausingHandler {
        private ServerErrorResponseHandler() {
        }

        @Override
        public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
            super.handleRequest(requestContext, responseCallback);
            responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode())).entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream("test".getBytes())))).addHeader("Content-Type", MediaType.TEXT.toRfcString())).build(), HttpBrokenPipeLoggingConfigTestCase.this.getCountDownLatchResponseStatusCallbackWrapper(null));
        }
    }

    private class BrokenPipeCausingHandler
    implements RequestHandler {
        private BrokenPipeCausingHandler() {
        }

        public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
            try {
                HttpBrokenPipeLoggingConfigTestCase.this.requestLatch.await();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }
}

