/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.util;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.glassfish.grizzly.http.util.Header;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.auth.HttpAuthenticationType;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.impl.service.util.RedirectUtils;

@RunWith(value=Parameterized.class)
@Feature(value="HTTP Service")
@Issue(value="MULE-19908")
public class RedirectUtilsTestCase {
    @Rule
    public MockitoRule mockitorule = MockitoJUnit.rule();
    @Mock
    private HttpResponse response;
    @Mock
    private HttpRequest originalRequest;
    @Mock
    private HttpRequestOptions options;
    @Mock
    private HttpAuthentication httpAuthentication;
    private final MultiMap<String, String> originalRequestHeaders = new MultiMap();
    private final MultiMap<String, String> responseHeaders = new MultiMap();
    @Parameterized.Parameter
    public String method;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"POST"}, {"GET"}, {"PUT"});
    }

    @Before
    public void setup() throws URISyntaxException {
        this.originalRequestHeaders.clear();
        URI originalRequestURI = new URI("http://somehost/originalPath?param=original");
        HttpEntity originalRequestEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)this.originalRequest.getUri()).thenReturn((Object)originalRequestURI);
        Mockito.when((Object)this.originalRequest.getProtocol()).thenReturn((Object)HttpProtocol.HTTP_1_1);
        Mockito.when((Object)this.originalRequest.getHeaders()).thenReturn(this.originalRequestHeaders);
        Mockito.when((Object)this.originalRequest.getEntity()).thenReturn((Object)originalRequestEntity);
        Mockito.when((Object)this.originalRequest.getMethod()).thenReturn((Object)this.method);
        Mockito.when((Object)this.options.getAuthentication()).thenReturn(Optional.empty());
        Mockito.when((Object)this.response.getHeaders()).thenReturn(this.responseHeaders);
        this.responseHeaders.put((Object)"Location", (Object)"http://redirecthost/redirectPath");
    }

    @Test
    public void redirectedRequestWithHostUsesQueryParamsFromResponseLocation() {
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)301);
        this.testRedirectRequest("http://redirecthost/redirectPath?param=redirect", this.method, false, false);
    }

    @Test
    public void redirectedRequestWithoutHostUsesQueryParamsFromResponseLocation() {
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)301);
        this.testRedirectRequest("/redirectPath?param=redirect", this.method, false, false);
    }

    @Test
    public void redirectedRequestWith302AndPostMethod() {
        Mockito.when((Object)this.originalRequest.getMethod()).thenReturn((Object)"POST");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)302);
        this.testRedirectRequest("/redirectPath?param=redirect", "GET", false, false);
    }

    @Test
    public void redirectedRequestWith302AndPostMethodWithStrict302Handling() {
        Mockito.when((Object)this.originalRequest.getMethod()).thenReturn((Object)"POST");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)302);
        this.testRedirectRequest("/redirectPath?param=redirect", "POST", true, false);
    }

    @Test
    public void redirectedRequestWith303AndPostMethod() {
        Mockito.when((Object)this.originalRequest.getMethod()).thenReturn((Object)"POST");
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)303);
        this.testRedirectRequest("/redirectPath?param=redirect", "GET", false, false);
    }

    @Test
    public void redirectedRequestWithHostHeader() {
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)301);
        this.originalRequestHeaders.put((Object)Header.Host.toString(), (Object)"HOST");
        this.testRedirectRequest("/redirectPath?param=redirect", this.method, false, false);
    }

    @Test
    public void redirectedRequestWithContentLengthHeader() {
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)301);
        this.originalRequestHeaders.put((Object)Header.ContentLength.toString(), (Object)"ContentLength");
        this.testRedirectRequest("/redirectPath?param=redirect", this.method, false, false);
    }

    @Test
    public void redirectedRequestWithNTLM() {
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)301);
        this.originalRequestHeaders.put((Object)Header.ContentLength.toString(), (Object)"ContentLength");
        Mockito.when((Object)this.options.getAuthentication()).thenReturn(Optional.of(this.httpAuthentication));
        Mockito.when((Object)this.httpAuthentication.getType()).thenReturn((Object)HttpAuthenticationType.NTLM);
        this.originalRequestHeaders.put((Object)Header.Authorization.toString(), (Object)"Authorization");
        this.originalRequestHeaders.put((Object)Header.ProxyAuthorization.toString(), (Object)"ProxyAuthorization");
        HttpRequest redirectedRequest = this.testRedirectRequest("/redirectPath?param=redirect", this.method, false, false);
        Assert.assertThat((Object)redirectedRequest.getHeaders().containsKey((Object)Header.Authorization.toString()), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)redirectedRequest.getHeaders().containsKey((Object)Header.ProxyAuthorization.toString()), (Matcher)Matchers.is((Object)false));
    }

    @Test
    @Issue(value="W-10822777")
    public void caseSensitivity() {
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)301);
        String testString = "CaseSensitive";
        this.originalRequestHeaders.put((Object)testString, (Object)testString);
        HttpRequest redirectedRequest = this.testRedirectRequest("/redirectPath?param=redirect", this.method, false, true);
        Assert.assertThat(((Map.Entry)redirectedRequest.getHeaders().entryList().get(0)).getKey(), (Matcher)Matchers.is((Object)testString));
    }

    private HttpRequest testRedirectRequest(String path, String method, boolean isStrict302Handling, boolean preserveHeaderCase) {
        this.setLocationHeader(path);
        RedirectUtils redirectUtils = new RedirectUtils(isStrict302Handling, preserveHeaderCase);
        HttpRequest redirectedRequest = redirectUtils.createRedirectRequest(this.response, this.originalRequest, this.options);
        Assert.assertThat((Object)redirectedRequest.getUri().getRawQuery(), (Matcher)Matchers.is((Object)"param=redirect"));
        Assert.assertThat((Object)redirectedRequest.getMethod(), (Matcher)Matchers.is((Object)method));
        Assert.assertThat((Object)redirectedRequest.getHeaders().containsKey((Object)Header.Host.toString()), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)redirectedRequest.getHeaders().containsKey((Object)Header.ContentLength.toString()), (Matcher)Matchers.is((Object)false));
        return redirectedRequest;
    }

    private void setLocationHeader(String path) {
        this.responseHeaders.removeAll((Object)"Location");
        this.responseHeaders.put((Object)"Location", (Object)path);
    }
}

