/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.Collections;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.client.fluent.Request;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.service.http.impl.functional.server.AbstractHttpServerTestCase;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyServerManager;
import org.mule.tck.junit4.rule.SystemProperty;

public class HttpServiceMaxHeadersTestCase
extends AbstractHttpServerTestCase {
    private static final String SIMPLE_ENDPOINT = "test";
    private static final String PAYLOAD1 = "p1";

    public HttpServiceMaxHeadersTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    protected String getServerName() {
        return "max-headers-test";
    }

    private void registerHandler(HttpConstants.Method httpMethod, String endpoint, String payload, HttpServer httpServer) {
        httpServer.addRequestHandler(Collections.singletonList(httpMethod.name()), "/" + endpoint, (requestContext, responseCallback) -> responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)org.mule.runtime.http.api.domain.message.response.HttpResponse.builder().entity((HttpEntity)new ByteArrayHttpEntity(payload.getBytes()))).addHeader("Content-Type", MediaType.TEXT.toRfcString())).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback()));
    }

    @Override
    @After
    public void tearDown() {
        GrizzlyServerManager.refreshSystemProperties();
    }

    @Issue(value="MULE-19837")
    @Description(value="When the max number of request headers are set by System Properties, they should be assigned correctly. If this max number is exceeded, a 413 status code should be returned.")
    @Test
    public void whenRequestHasMoreHeadersThanMaxNumberThen413ShouldBeReturned() throws Throwable {
        HttpServer httpServer = (HttpServer)SystemProperty.callWithProperty((String)"mule.http.MAX_SERVER_REQUEST_HEADERS", (String)"3", this::refreshSystemPropertiesAndCreateServer);
        this.registerHandler(HttpConstants.Method.GET, SIMPLE_ENDPOINT, PAYLOAD1, httpServer);
        Request request = Request.Get((String)String.format("http://%s:%s/%s", httpServer.getServerAddress().getIp(), this.port.getValue(), SIMPLE_ENDPOINT));
        request.addHeader("header1", "someValue");
        request.addHeader("header2", "someValue");
        request.addHeader("header3", "someValue");
        request.addHeader("header4", "someValue");
        HttpResponse response = request.execute().returnResponse();
        StatusLine statusLine = response.getStatusLine();
        Assert.assertThat((Object)statusLine.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.REQUEST_TOO_LONG.getStatusCode()));
        httpServer.stop();
        httpServer.dispose();
    }

    @Issue(value="MULE-19837")
    @Description(value="When the max number of response headers are set by System Properties, they should be assigned correctly. If this max number is exceeded, a NoHttpResponseException should be thrown")
    @Test(expected=NoHttpResponseException.class)
    public void whenResponseHasMoreHeadersThanMaxNumberThenExceptionShouldBeThrown() throws Throwable {
        HttpServer httpServer = (HttpServer)SystemProperty.callWithProperty((String)"mule.http.MAX_SERVER_RESPONSE_HEADERS", (String)"2", this::refreshSystemPropertiesAndCreateServer);
        this.registerHandler(HttpConstants.Method.GET, SIMPLE_ENDPOINT, PAYLOAD1, httpServer);
        Request request = Request.Get((String)String.format("http://%s:%s/%s", httpServer.getServerAddress().getIp(), this.port.getValue(), SIMPLE_ENDPOINT));
        try {
            request.execute();
        }
        finally {
            httpServer.stop();
            httpServer.dispose();
        }
    }

    private HttpServer refreshSystemPropertiesAndCreateServer() throws Exception {
        GrizzlyServerManager.refreshSystemProperties();
        HttpServer httpServer = this.service.getServerFactory().create(this.configureServer(new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.port.getNumber()).setName(this.getServerName())).build());
        httpServer.start();
        return httpServer;
    }
}

