/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.util;

import com.ning.http.client.RequestBuilder;
import com.ning.http.client.cookie.CookieDecoder;
import com.ning.http.client.uri.Uri;
import org.glassfish.grizzly.http.util.Header;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthenticationType;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class RedirectUtils {
    private final boolean isStrict302Handling;
    private final boolean preserveHeaderCase;

    public RedirectUtils(boolean isStrict302Handling, boolean preserveHeaderCase) {
        this.isStrict302Handling = isStrict302Handling;
        this.preserveHeaderCase = preserveHeaderCase;
    }

    public boolean shouldFollowRedirect(HttpResponse response, HttpRequestOptions options, boolean enableMuleRedirect) {
        return enableMuleRedirect && this.isRedirected(response.getStatusCode()) && response.getHeaders().containsKey((Object)"Location") && options.isFollowsRedirect();
    }

    private boolean isRedirected(int statusCode) {
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    private boolean mustBeSendAsGet(int statusCode) {
        return statusCode >= 302 && statusCode <= 303 && (statusCode != 302 || !this.isStrict302Handling);
    }

    public HttpRequest createRedirectRequest(HttpResponse response, HttpRequest request, HttpRequestOptions options) {
        String redirectMethod;
        Uri path = Uri.create((Uri)Uri.create((String)request.getUri().toString()), (String)((String)response.getHeaders().get((Object)"Location")));
        MultiMap headers = new MultiMap(request.getHeaders());
        headers.remove((Object)Header.Host.toString());
        headers.remove((Object)Header.ContentLength.toString());
        if (this.mustBeSendAsGet(response.getStatusCode())) {
            redirectMethod = HttpConstants.Method.GET.name();
            headers.remove((Object)Header.ContentType.toString());
        } else {
            redirectMethod = request.getMethod();
        }
        options.getAuthentication().ifPresent(httpAuthentication -> {
            if (httpAuthentication.getType().equals((Object)HttpAuthenticationType.NTLM)) {
                headers.remove((Object)Header.Authorization.toString());
                headers.remove((Object)Header.ProxyAuthorization.toString());
            }
        });
        return ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder((boolean)this.preserveHeaderCase).uri(path.toUrl()).method(redirectMethod).protocol(request.getProtocol()).headers(headers)).entity(request.getEntity())).build();
    }

    public void handleResponseCookies(RequestBuilder requestBuilder, HttpResponse response) {
        for (String cookieStr : response.getHeaderValues(Header.SetCookie.toString())) {
            requestBuilder.addOrReplaceCookie(CookieDecoder.decode((String)cookieStr));
        }
    }
}

