/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional;

import com.github.peterwippermann.junit4.parameterizedsuite.ParameterContext;
import io.qameta.allure.Feature;
import java.util.Collections;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.service.HttpServiceImplementation;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=Parameterized.class)
@Feature(value="HTTP Service")
public abstract class AbstractHttpServiceTestCase
extends AbstractMuleTestCase {
    @Parameter
    public String serviceToLoad;
    protected HttpServiceImplementation service;
    private SimpleUnitTestSupportSchedulerService schedulerService;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> params() {
        if (ParameterContext.isParameterSet()) {
            return Collections.singletonList((Object[])ParameterContext.getParameter(Object[].class));
        }
        return Collections.singletonList(new String[]{HttpServiceImplementation.class.getName()});
    }

    public AbstractHttpServiceTestCase(String serviceToLoad) {
        this.serviceToLoad = serviceToLoad;
    }

    @Before
    public void createServices() throws Exception {
        this.schedulerService = new SimpleUnitTestSupportSchedulerService();
        this.service = (HttpServiceImplementation)ClassUtils.instantiateClass((String)this.serviceToLoad, (Object[])new Object[]{this.schedulerService}, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.service.start();
    }

    @After
    public void closeServices() throws Exception {
        if (this.service != null) {
            this.service.stop();
        }
        if (this.schedulerService != null) {
            this.schedulerService.stop();
        }
    }

    public static class IgnoreResponseStatusCallback
    implements ResponseStatusCallback {
        public void responseSendFailure(Throwable throwable) {
            TestCase.fail((String)throwable.getMessage());
        }

        public void responseSendSuccessfully() {
        }
    }
}

