/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import com.ning.http.client.AsyncHttpClient;
import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.lang.reflect.Field;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.service.http.impl.service.client.GrizzlyHttpClient;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyServerManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

public class GrizzlyHttpClientTestCase
extends AbstractMuleTestCase {
    SchedulerService schedulerService;
    SchedulerConfig schedulerConfig;
    SchedulerConfig schedulerConfig2;

    @Before
    public void setUp() {
        this.schedulerService = (SchedulerService)Mockito.mock(SchedulerService.class);
        this.schedulerConfig = (SchedulerConfig)Mockito.mock(SchedulerConfig.class);
        this.schedulerConfig2 = (SchedulerConfig)Mockito.mock(SchedulerConfig.class);
        Mockito.when((Object)this.schedulerService.customScheduler((SchedulerConfig)ArgumentMatchers.any())).thenReturn((Object)((Scheduler)Mockito.mock(Scheduler.class)));
        Mockito.when((Object)this.schedulerService.ioScheduler((SchedulerConfig)ArgumentMatchers.any())).thenReturn((Object)((Scheduler)Mockito.mock(Scheduler.class)));
        Mockito.when((Object)this.schedulerConfig.withDirectRunCpuLightWhenTargetBusy(ArgumentMatchers.anyBoolean())).thenReturn((Object)this.schedulerConfig2);
        Mockito.when((Object)this.schedulerConfig2.withMaxConcurrentTasks(ArgumentMatchers.anyInt())).thenReturn((Object)((SchedulerConfig)Mockito.mock(SchedulerConfig.class)));
        Mockito.when((Object)this.schedulerConfig.withName((String)ArgumentMatchers.any())).thenReturn((Object)((SchedulerConfig)Mockito.mock(SchedulerConfig.class)));
    }

    @After
    public void tearDown() {
        GrizzlyServerManager.refreshSystemProperties();
    }

    @Issue(value="MULE-19837")
    @Description(value="When the max number of request headers are NOT set by System Properties, they should be assigned correctly by default. We check that the variables are properly set because we are delegating the max headers amount check to Grizzly")
    @Test
    public void testMaxClientRequestHeadersIfNotSetBySystemPropertyIsSetByDefault() throws Throwable {
        GrizzlyHttpClient client = this.refreshSystemPropertiesAndCreateGrizzlyHttpClient();
        client.start();
        Field asyncHttpClientField = GrizzlyHttpClient.class.getDeclaredField("asyncHttpClient");
        asyncHttpClientField.setAccessible(true);
        AsyncHttpClient asyncHttpClient = (AsyncHttpClient)asyncHttpClientField.get(client);
        Assert.assertThat((Object)asyncHttpClient.getConfig().getMaxRequestHeaders(), (Matcher)Matchers.is((Object)100));
    }

    @Issue(value="MULE-19837")
    @Description(value="When the max number of request headers are set by System Properties, they should be assigned correctly to Grizzly's AsyncHttpClient. We check that the variables are properly set because we are delegating the max headers amount check to Grizzly")
    @Test
    public void testMaxClientRequestHeadersCanBeSetBySystemProperty() throws Throwable {
        String maxSetRequestHeaders = "150";
        HttpClient client = (HttpClient)SystemProperty.callWithProperty((String)"mule.http.MAX_CLIENT_REQUEST_HEADERS", (String)maxSetRequestHeaders, this::refreshSystemPropertiesAndCreateGrizzlyHttpClient);
        client.start();
        Field asyncHttpClientField = GrizzlyHttpClient.class.getDeclaredField("asyncHttpClient");
        asyncHttpClientField.setAccessible(true);
        AsyncHttpClient asyncHttpClient = (AsyncHttpClient)asyncHttpClientField.get(client);
        Assert.assertThat((Object)asyncHttpClient.getConfig().getMaxRequestHeaders(), (Matcher)Matchers.is((Object)Integer.parseInt(maxSetRequestHeaders)));
    }

    private GrizzlyHttpClient refreshSystemPropertiesAndCreateGrizzlyHttpClient() {
        GrizzlyHttpClient.refreshSystemProperties();
        return new GrizzlyHttpClient((HttpClientConfiguration)Mockito.mock(HttpClientConfiguration.class, (Answer)Mockito.RETURNS_DEEP_STUBS), this.schedulerService, this.schedulerConfig);
    }
}

