/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.service.http.impl.service.client.async.PreservingClassLoaderAsyncHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class PreservingClassLoaderAsyncHandlerTestCase
extends AbstractMuleTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Mock
    private AsyncHandler<Integer> delegate;
    @Mock
    private ClassLoader mockClassLoader;
    private PreservingClassLoaderAsyncHandler<Integer> asyncHandler;
    private ClassLoader classLoaderOnCreation;

    @Before
    public void setup() {
        this.classLoaderOnCreation = Thread.currentThread().getContextClassLoader();
        this.asyncHandler = new PreservingClassLoaderAsyncHandler(this.delegate);
    }

    @Test
    public void creationClassLoaderIsPreservedOnCompleted() throws Exception {
        Reference classLoaderOnCompleted = new Reference();
        Mockito.when((Object)((Integer)this.delegate.onCompleted())).then(invocation -> {
            classLoaderOnCompleted.set((Object)Thread.currentThread().getContextClassLoader());
            return "completed";
        });
        ClassUtils.withContextClassLoader((ClassLoader)this.mockClassLoader, () -> this.asyncHandler.onCompleted());
        Assert.assertThat((Object)((ClassLoader)classLoaderOnCompleted.get()), (Matcher)Matchers.is((Object)this.classLoaderOnCreation));
    }

    @Test
    public void creationClassLoaderIsPreservedOnThrowable() {
        Reference classLoaderOnThrowable = new Reference();
        ((AsyncHandler)Mockito.doAnswer(invocation -> {
            classLoaderOnThrowable.set((Object)Thread.currentThread().getContextClassLoader());
            return "completed";
        }).when(this.delegate)).onThrowable((Throwable)ArgumentMatchers.any(Throwable.class));
        ClassUtils.withContextClassLoader((ClassLoader)this.mockClassLoader, () -> this.asyncHandler.onThrowable(new Throwable()));
        Assert.assertThat((Object)((ClassLoader)classLoaderOnThrowable.get()), (Matcher)Matchers.is((Object)this.classLoaderOnCreation));
    }

    @Test
    public void creationClassLoaderIsPreservedOnBodyPartReceived() throws Exception {
        Reference classLoaderOnBodyPartReceived = new Reference();
        Mockito.when((Object)this.delegate.onBodyPartReceived((HttpResponseBodyPart)ArgumentMatchers.any())).then(invocation -> {
            classLoaderOnBodyPartReceived.set((Object)Thread.currentThread().getContextClassLoader());
            return null;
        });
        ClassUtils.withContextClassLoader((ClassLoader)this.mockClassLoader, () -> this.asyncHandler.onBodyPartReceived(null));
        Assert.assertThat((Object)((ClassLoader)classLoaderOnBodyPartReceived.get()), (Matcher)Matchers.is((Object)this.classLoaderOnCreation));
    }

    @Test
    public void creationClassLoaderIsPreservedOnStatusReceived() throws Exception {
        Reference classLoaderOnStatusReceived = new Reference();
        Mockito.when((Object)this.delegate.onStatusReceived((HttpResponseStatus)ArgumentMatchers.any())).then(invocation -> {
            classLoaderOnStatusReceived.set((Object)Thread.currentThread().getContextClassLoader());
            return null;
        });
        ClassUtils.withContextClassLoader((ClassLoader)this.mockClassLoader, () -> this.asyncHandler.onStatusReceived(null));
        Assert.assertThat((Object)((ClassLoader)classLoaderOnStatusReceived.get()), (Matcher)Matchers.is((Object)this.classLoaderOnCreation));
    }

    @Test
    public void creationClassLoaderIsPreservedOnHeadersReceived() throws Exception {
        Reference classLoaderOnHeadersReceived = new Reference();
        Mockito.when((Object)this.delegate.onHeadersReceived((HttpResponseHeaders)ArgumentMatchers.any())).then(invocation -> {
            classLoaderOnHeadersReceived.set((Object)Thread.currentThread().getContextClassLoader());
            return null;
        });
        ClassUtils.withContextClassLoader((ClassLoader)this.mockClassLoader, () -> this.asyncHandler.onHeadersReceived(null));
        Assert.assertThat((Object)((ClassLoader)classLoaderOnHeadersReceived.get()), (Matcher)Matchers.is((Object)this.classLoaderOnCreation));
    }
}

