/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.text.IsEqualIgnoringCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.auth.HttpAuthenticationType;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.ResponseReceivedProbe;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

@Feature(value="HTTP Service")
@Story(value="Client Authentication")
public class HttpRequestMultipleAuthenticationMethodsSupportedTestCase
extends AbstractHttpClientTestCase {
    private static final int TIMEOUT_MILLIS = 1000;
    private static final int POLL_DELAY_MILLIS = 200;
    private static final String NONCE = "+Upgraded+v1a574e295ff1f41c52582b82815bb734c5c50331c97c4d301bc97f789c5e9e73ca9564b24cbd898ce5f1c13598999faa2ab013ee5b1597087";
    private static final String TEST_USER = "user";
    private static final String TEST_PASS = "password";
    private static final String BASIC_AUTH_METHOD = "BASIC";
    private static final String DIGEST_AUTH_METHOD = "DIGEST";
    private static final String NTLM_AUTH_METHOD = "NTLM";
    private HttpClient client;
    private String chosenAuthMethod = "";
    private final HttpClientConfiguration.Builder clientBuilder = new HttpClientConfiguration.Builder().setName("auth-test");
    private final PollingProber pollingProber = new PollingProber(1000L, 200L);
    private final Reference<HttpResponse> responseReference = new Reference();

    public HttpRequestMultipleAuthenticationMethodsSupportedTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void setUpClient() {
        this.client = this.service.getClientFactory().create(this.clientBuilder.build());
        this.client.start();
    }

    @After
    public void stopClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    public void onMultipleAuthenticationMethodsSupportedLocallySetMethodIsChosenDigest() {
        this.sendRequestAssertCorrectAuthMethodChosen(DIGEST_AUTH_METHOD);
    }

    @Test
    public void onMultipleAuthenticationMethodsSupportedLocallySetMethodIsChosenNtlm() {
        this.sendRequestAssertCorrectAuthMethodChosen(NTLM_AUTH_METHOD);
    }

    @Test
    public void onMultipleAuthenticationMethodsSupportedLocallySetMethodIsChosenBasic() {
        this.sendRequestAssertCorrectAuthMethodChosen(BASIC_AUTH_METHOD);
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        HttpResponseBuilder responseBuilder = HttpResponse.builder();
        String authHeader = request.getHeaderValue("Authorization");
        this.chosenAuthMethod = this.getRequestAuthType(authHeader);
        if (StringUtils.isEmpty((String)authHeader)) {
            ((HttpResponseBuilder)((HttpResponseBuilder)responseBuilder.statusCode(Integer.valueOf(HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode())).addHeader("WWW-Authenticate", BASIC_AUTH_METHOD)).addHeader("WWW-Authenticate", NTLM_AUTH_METHOD)).addHeader("WWW-Authenticate", "DIGEST qop=\"auth\",algorithm=MD5-sess,nonce=\"+Upgraded+v1a574e295ff1f41c52582b82815bb734c5c50331c97c4d301bc97f789c5e9e73ca9564b24cbd898ce5f1c13598999faa2ab013ee5b1597087\",charset=utf-8,realm=\"INT\"");
        } else if (this.chosenAuthMethod.length() > 0) {
            responseBuilder.statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode())).reasonPhrase(HttpConstants.HttpStatus.OK.getReasonPhrase());
        } else {
            responseBuilder.statusCode(Integer.valueOf(HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
        }
        return responseBuilder.build();
    }

    protected void sendRequestAssertCorrectAuthMethodChosen(String authMethod) {
        HttpRequestOptions options = this.getOptions(authMethod);
        HttpRequest request = this.getRequest();
        this.client.sendAsync(request, options).whenComplete((response, exception) -> this.responseReference.set(response));
        this.pollingProber.check((Probe)new ResponseReceivedProbe(this.responseReference));
        this.pollingProber.check((Probe)new ResponseSuccessProbe(authMethod));
        MatcherAssert.assertThat((Object)this.chosenAuthMethod, (Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)authMethod));
    }

    private HttpRequestOptions getOptions(String authMethod) {
        HttpAuthentication auth = HttpAuthentication.builder().type(HttpAuthenticationType.valueOf((String)authMethod)).username(TEST_USER).password(TEST_PASS).preemptive(false).build();
        return HttpRequestOptions.builder().authentication(auth).build();
    }

    private HttpRequest getRequest() {
        return HttpRequest.builder().method(HttpConstants.Method.GET).uri(this.getUri()).build();
    }

    private String getRequestAuthType(String authHeader) {
        return StringUtils.isEmpty((String)authHeader) ? "" : authHeader.substring(0, authHeader.indexOf(" "));
    }

    private class ResponseSuccessProbe
    implements Probe {
        private final String authType;

        public ResponseSuccessProbe(String httpAuthType) {
            this.authType = httpAuthType;
        }

        public boolean isSatisfied() {
            return ((HttpResponse)HttpRequestMultipleAuthenticationMethodsSupportedTestCase.this.responseReference.get()).getStatusCode() == HttpConstants.HttpStatus.OK.getStatusCode();
        }

        public String describeFailure() {
            return "Authorization method chosen should be " + this.authType;
        }
    }
}

