/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.IOException;
import java.io.InputStream;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.http.ProcessingState;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.service.server.grizzly.BaseResponseCompletionHandler;
import org.mule.service.http.impl.service.server.grizzly.BaseResponseCompletionHandlerTestCase;
import org.mule.service.http.impl.service.server.grizzly.ResponseStreamingCompletionHandler;

@Feature(value="HTTP Service")
@Story(value="Responses")
public class ResponseStreamingCompletionHandlerTestCase
extends BaseResponseCompletionHandlerTestCase {
    private ResponseStreamingCompletionHandler handler;
    private InputStream mockStream;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() {
        Mockito.when((Object)this.ctx.getConnection()).thenReturn((Object)this.connection);
        Mockito.when((Object)this.connection.getTransport()).thenReturn((Object)((Transport)Mockito.mock(Transport.class, (Answer)Mockito.RETURNS_DEEP_STUBS)));
        this.mockStream = (InputStream)Mockito.spy((Object)((InputStream)Mockito.mock(InputStream.class)));
        this.responseMock = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new InputStreamHttpEntity(this.mockStream))).build();
        this.handler = new ResponseStreamingCompletionHandler(this.ctx, Thread.currentThread().getContextClassLoader(), this.request, this.responseMock, this.callback);
    }

    @Override
    protected BaseResponseCompletionHandler getHandler() {
        return this.handler;
    }

    @Test
    public void keepAliveConnection() {
        MultiMap headers = new MultiMap();
        headers.put((Object)"Connection", (Object)"Keep-Alive");
        this.responseMock = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new InputStreamHttpEntity(this.mockStream))).headers(headers)).build();
        this.handler = new ResponseStreamingCompletionHandler(this.ctx, Thread.currentThread().getContextClassLoader(), this.request, this.responseMock, this.callback);
        MatcherAssert.assertThat((Object)this.handler.getHttpResponsePacket().getHeader("Connection"), (Matcher)Matchers.equalTo((Object)"Keep-Alive"));
    }

    @Test
    public void cLoseConnection() {
        MultiMap headers = new MultiMap();
        headers.put((Object)"Connection", (Object)"close");
        this.responseMock = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new InputStreamHttpEntity(this.mockStream))).headers(headers)).build();
        Mockito.when((Object)this.request.getProcessingState()).thenReturn((Object)new ProcessingState());
        this.handler = new ResponseStreamingCompletionHandler(this.ctx, Thread.currentThread().getContextClassLoader(), this.request, this.responseMock, this.callback);
        MatcherAssert.assertThat((Object)this.getHandler().getHttpResponsePacket().getHeader("Connection"), (Matcher)Matchers.equalTo((Object)"close"));
    }

    @Test
    public void completionHandlerFailsIfAReadOperationThrowsAMuleRuntimeException() throws IOException {
        this.responseMock = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new InputStreamHttpEntity(this.mockStream))).build();
        Mockito.when((Object)this.request.getProcessingState()).thenReturn((Object)new ProcessingState());
        this.handler = (ResponseStreamingCompletionHandler)Mockito.spy((Object)new ResponseStreamingCompletionHandler(this.ctx, Thread.currentThread().getContextClassLoader(), this.request, this.responseMock, this.callback));
        Mockito.when((Object)this.mockStream.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{new MuleRuntimeException((Throwable)new NullPointerException())});
        this.handler.sendInputStreamChunk();
        ((BaseResponseCompletionHandler)Mockito.verify((Object)this.getHandler(), (VerificationMode)Mockito.times((int)1))).failed((Throwable)ArgumentMatchers.any(Throwable.class));
    }

    @Test
    public void IOExceptionIsRethrownIfCauseOfFailure() throws IOException {
        this.responseMock = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new InputStreamHttpEntity(this.mockStream))).build();
        Mockito.when((Object)this.request.getProcessingState()).thenReturn((Object)new ProcessingState());
        this.handler = (ResponseStreamingCompletionHandler)Mockito.spy((Object)new ResponseStreamingCompletionHandler(this.ctx, Thread.currentThread().getContextClassLoader(), this.request, this.responseMock, this.callback));
        this.exception.expect(IOException.class);
        Mockito.when((Object)this.mockStream.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{new MuleRuntimeException((Throwable)new IOException())});
        this.handler.sendInputStreamChunk();
    }

    @Test
    @Issue(value="MULE-19727")
    public void handlerDoesntThrowNPEWhenConnectionIsNull() {
        this.handler = new ResponseStreamingCompletionHandler(this.ctx, Thread.currentThread().getContextClassLoader(), this.request, this.responseMock, this.callback);
        Mockito.when((Object)this.ctx.getConnection()).thenReturn(null);
        this.handler.failed((Throwable)this.createExpectedException());
    }

    @Test
    @Issue(value="MULE-19727")
    public void failedMethodBehaviorIsExecutedOnlyOnceForTheSameHandler() throws IOException {
        this.handler = new ResponseStreamingCompletionHandler(this.ctx, Thread.currentThread().getContextClassLoader(), this.request, this.responseMock, this.callback);
        this.handler.failed((Throwable)this.createExpectedException());
        this.handler.failed((Throwable)this.createExpectedException());
        this.handler.failed((Throwable)this.createExpectedException());
        ((InputStream)Mockito.verify((Object)this.mockStream, (VerificationMode)Mockito.times((int)1))).close();
        ((ResponseStatusCallback)Mockito.verify((Object)this.callback, (VerificationMode)Mockito.times((int)1))).onErrorSendingResponse((Throwable)ArgumentMatchers.any(Exception.class));
    }

    private Exception createExpectedException() {
        return new Exception("EXPECTED EXCEPTION");
    }
}

