/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.IOException;
import java.io.InputStream;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.io.InputBuffer;

final class BlockingTransferInputStream
extends InputStream {
    private final HttpHeader httpHeader;
    private final InputBuffer inputBuffer;
    private volatile String readNotAllowedReason = null;

    BlockingTransferInputStream(HttpHeader httpHeader, FilterChainContext ctx) {
        this.httpHeader = httpHeader;
        this.inputBuffer = new InputBuffer();
        this.inputBuffer.initialize(httpHeader, ctx);
    }

    @Override
    public int read() throws IOException {
        this.throwIfReadingNotAllowedAndWouldBlock(1L);
        return this.inputBuffer.readByte();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.throwIfReadingNotAllowedAndWouldBlock(1L);
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.throwIfReadingNotAllowedAndWouldBlock(1L);
        return this.inputBuffer.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.throwIfReadingNotAllowedAndWouldBlock(n);
        return this.inputBuffer.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.inputBuffer.available();
    }

    @Override
    public void close() throws IOException {
        this.inputBuffer.close();
    }

    @Override
    public void mark(int readlimit) {
        this.inputBuffer.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.inputBuffer.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputBuffer.markSupported();
    }

    public void preventFurtherBlockingReading(String reason) {
        this.readNotAllowedReason = reason;
    }

    private void throwIfReadingNotAllowedAndWouldBlock(long numBytes) {
        if (this.readNotAllowedReason != null && this.advancingWouldBlock(numBytes)) {
            throw new IllegalStateException("Reading from this stream is not allowed. Reason: " + this.readNotAllowedReason);
        }
    }

    private boolean advancingWouldBlock(long numBytes) {
        return (long)this.inputBuffer.readyData() < numBytes && this.httpHeader.isExpectContent();
    }
}

