/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import io.qameta.allure.junit4.DisplayName;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Before;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.client.HttpClientPostStreamingTestCase;

@Story(value="Streaming")
@DisplayName(value="Validates request streaming with a large payload")
@Issue(value="W-14543363")
public class RequestStreamingLargePayloadTestCase
extends HttpClientPostStreamingTestCase {
    @Before
    public void before() throws Exception {
        RequestStreamingLargePayloadTestCase.setRequestStreaming(true);
    }

    public RequestStreamingLargePayloadTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @After
    public void after() throws Exception {
        RequestStreamingLargePayloadTestCase.setRequestStreaming(false);
    }

    protected InputStream getInputStream() {
        try {
            return Files.newInputStream(Paths.get(ClassUtils.getClassPathRoot(RequestStreamingLargePayloadTestCase.class).getPath() + File.separator + "largePayload", new String[0]), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new AssertionError((Object)"Error on loading the large payload file");
        }
    }

    @Override
    public HttpRequest getRequest() {
        return ((HttpRequestBuilder)HttpRequest.builder().method(HttpConstants.Method.POST).uri(this.getUri()).entity((HttpEntity)new InputStreamHttpEntity(this.getInputStream()))).build();
    }

    @Override
    public HttpRequestOptions getOptions() {
        return HttpRequestOptions.builder().responseTimeout(3000).build();
    }

    @Override
    public HttpResponse doSetUpHttpResponse(HttpRequest request) {
        HttpResponseBuilder response = HttpResponse.builder();
        this.extractPayload(request);
        response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode()));
        return response.build();
    }

    @Override
    protected String expectedPayload() {
        try {
            return FileUtils.readFileToString((File)new File(ClassUtils.getClassPathRoot(RequestStreamingLargePayloadTestCase.class).getPath() + File.separator + "largePayload"));
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Error on loading the large payload file");
        }
    }
}

