/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.mule.runtime.core.api.util.ClassLoaderResourceNotFoundExceptionFactory;

public class ClassUtils {
    private static final Map<Class<?>, Class<?>> wrapperToPrimitiveMap = new HashMap();
    private static final Map<String, Class<?>> primitiveTypeNameMap = new HashMap(32);

    public static Class loadClass(String className, Class<?> callingClass) throws ClassNotFoundException {
        return ClassUtils.loadClass(className, callingClass, Object.class);
    }

    public static <T extends Class> T loadClass(String className, Class<?> callingClass, T type) throws ClassNotFoundException {
        if (className.length() <= 8 && primitiveTypeNameMap.containsKey(className)) {
            return (T)primitiveTypeNameMap.get(className);
        }
        Class clazz = AccessController.doPrivileged(() -> {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl != null ? cl.loadClass(className) : null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        });
        if (clazz == null) {
            clazz = AccessController.doPrivileged(() -> {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            });
        }
        if (clazz == null) {
            clazz = AccessController.doPrivileged(() -> {
                try {
                    return ClassUtils.class.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            });
        }
        if (clazz == null) {
            clazz = AccessController.doPrivileged(() -> {
                try {
                    return callingClass.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            });
        }
        if (clazz == null) {
            throw new ClassNotFoundException(className);
        }
        if (type.isAssignableFrom(clazz)) {
            return (T)clazz;
        }
        throw new IllegalArgumentException(String.format("Loaded class '%s' is not assignable from type '%s'", clazz.getName(), type.getName()));
    }

    public static Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = classLoader.loadClass(ClassUtils.getInnerClassName(className));
            }
            catch (ClassNotFoundException e2) {
                throw ClassLoaderResourceNotFoundExceptionFactory.getDefaultFactory().createClassNotFoundException(className, classLoader);
            }
        }
        return clazz;
    }

    private static String getInnerClassName(String identifier) {
        int lastIndex = identifier.lastIndexOf(46);
        if (lastIndex > -1) {
            StringBuilder builder = new StringBuilder(identifier);
            builder.setCharAt(lastIndex, '$');
            return builder.toString();
        }
        return identifier;
    }

    public static <T> T instantiateClass(Class<? extends T> clazz, Object ... constructorArgs) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor ctor;
        Class[] args;
        if (constructorArgs != null) {
            args = new Class[constructorArgs.length];
            for (int i = 0; i < constructorArgs.length; ++i) {
                args[i] = constructorArgs[i] == null ? null : constructorArgs[i].getClass();
            }
        } else {
            args = new Class[]{};
        }
        if ((ctor = ClassUtils.getConstructor(clazz, args)) == null) {
            ctor = ClassUtils.getConstructor(clazz, ClassUtils.wrappersToPrimitives(args));
        }
        if (ctor == null) {
            StringBuilder argsString = new StringBuilder(100);
            for (Class arg : args) {
                argsString.append(arg.getName()).append(", ");
            }
            throw new NoSuchMethodException("could not find constructor on class: " + clazz + ", with matching arg params: " + argsString);
        }
        return ctor.newInstance(constructorArgs);
    }

    public static Object instantiateClass(String name, Object[] constructorArgs, ClassLoader classLoader) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class clazz = classLoader != null ? ClassUtils.loadClass(name, classLoader) : ClassUtils.loadClass(name, ClassUtils.class);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return ClassUtils.instantiateClass(clazz, constructorArgs);
    }

    public static Constructor getConstructor(Class clazz, Class[] paramTypes) {
        return ClassUtils.getConstructor(clazz, paramTypes, false);
    }

    public static Constructor getConstructor(Class clazz, Class[] paramTypes, boolean exactMatch) {
        for (Constructor<?> ctor : clazz.getConstructors()) {
            Class<?>[] types = ctor.getParameterTypes();
            if (types.length != paramTypes.length) continue;
            int matchCount = 0;
            for (int x = 0; x < types.length; ++x) {
                if (paramTypes[x] == null) {
                    ++matchCount;
                    continue;
                }
                if (exactMatch) {
                    if (!paramTypes[x].equals(types[x]) && !types[x].equals(paramTypes[x])) continue;
                    ++matchCount;
                    continue;
                }
                if (!paramTypes[x].isAssignableFrom(types[x]) && !types[x].isAssignableFrom(paramTypes[x])) continue;
                ++matchCount;
            }
            if (matchCount != types.length) continue;
            return ctor;
        }
        return null;
    }

    public static Class[] wrappersToPrimitives(Class[] wrappers) {
        if (wrappers == null) {
            return null;
        }
        if (wrappers.length == 0) {
            return wrappers;
        }
        Class[] primitives = new Class[wrappers.length];
        for (int i = 0; i < wrappers.length; ++i) {
            primitives[i] = wrapperToPrimitiveMap.getOrDefault(wrappers[i], wrappers[i]);
        }
        return primitives;
    }

    private ClassUtils() {
    }

    static {
        wrapperToPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitiveMap.put(Byte.class, Byte.TYPE);
        wrapperToPrimitiveMap.put(Character.class, Character.TYPE);
        wrapperToPrimitiveMap.put(Short.class, Short.TYPE);
        wrapperToPrimitiveMap.put(Integer.class, Integer.TYPE);
        wrapperToPrimitiveMap.put(Long.class, Long.TYPE);
        wrapperToPrimitiveMap.put(Double.class, Double.TYPE);
        wrapperToPrimitiveMap.put(Float.class, Float.TYPE);
        wrapperToPrimitiveMap.put(Void.TYPE, Void.TYPE);
        HashSet primitiveTypes = new HashSet(32);
        primitiveTypes.addAll(wrapperToPrimitiveMap.values());
        for (Class clazz : primitiveTypes) {
            primitiveTypeNameMap.put(clazz.getName(), clazz);
        }
    }
}

