/*
 * Decompiled with CFR 0.152.
 */
package org.mule.services.http.impl.service.client;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.HttpProbe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMessageLogger
extends HttpProbe.Adapter {
    private static final Logger logger = LoggerFactory.getLogger(HttpMessageLogger.class);
    private final LoggerType loggerType;

    public HttpMessageLogger(LoggerType loggerType) {
        this.loggerType = loggerType;
    }

    public void onDataReceivedEvent(Connection connection, Buffer buffer) {
        this.logBuffer(buffer);
    }

    public void onDataSentEvent(Connection connection, Buffer buffer) {
        this.logBuffer(buffer);
    }

    private void logBuffer(Buffer buffer) {
        if (logger.isDebugEnabled()) {
            logger.debug(this.loggerType.name() + "\n" + buffer.toStringContent());
        }
    }

    public static enum LoggerType {
        LISTENER,
        REQUESTER;

    }
}

