/*
 * Decompiled with CFR 0.152.
 */
package org.mule.services.http.impl.service.server.grizzly;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.service.http.api.server.HttpServer;
import org.mule.service.http.api.server.RequestHandler;
import org.mule.service.http.api.server.RequestHandlerManager;
import org.mule.service.http.api.server.ServerAddress;
import org.mule.services.http.impl.service.server.HttpListenerRegistry;
import org.mule.services.http.impl.service.server.grizzly.AcceptsAllMethodsRequestMatcher;
import org.mule.services.http.impl.service.server.grizzly.DefaultMethodRequestMatcher;
import org.mule.services.http.impl.service.server.grizzly.ListenerRequestMatcher;

public class GrizzlyHttpServer
implements HttpServer,
Supplier<ExecutorService> {
    private final TCPNIOTransport transport;
    private final ServerAddress serverAddress;
    private final HttpListenerRegistry listenerRegistry;
    private TCPNIOServerConnection serverConnection;
    private Supplier<Scheduler> schedulerSource;
    private Runnable schedulerDisposer;
    private Scheduler scheduler;
    private boolean stopped = true;
    private boolean stopping;
    private String ownerName;

    public GrizzlyHttpServer(ServerAddress serverAddress, TCPNIOTransport transport, HttpListenerRegistry listenerRegistry, Supplier<Scheduler> schedulerSource, Runnable schedulerDisposer) {
        this.serverAddress = serverAddress;
        this.transport = transport;
        this.listenerRegistry = listenerRegistry;
        this.schedulerSource = schedulerSource;
        this.schedulerDisposer = schedulerDisposer;
    }

    public synchronized void start() throws IOException {
        this.scheduler = this.schedulerSource != null ? this.schedulerSource.get() : null;
        this.serverConnection = this.transport.bind(this.serverAddress.getIp(), this.serverAddress.getPort());
        this.serverConnection.addCloseListener((closeable, type) -> {
            try {
                this.scheduler.stop(5000L, TimeUnit.MILLISECONDS);
            }
            finally {
                this.scheduler = null;
            }
            this.schedulerDisposer.run();
        });
        this.stopped = false;
    }

    public synchronized void stop() {
        this.stopping = true;
        try {
            this.transport.unbind((Connection)this.serverConnection);
        }
        finally {
            this.stopping = false;
        }
    }

    public void dispose() {
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public RequestHandlerManager addRequestHandler(Collection<String> methods, String path, RequestHandler requestHandler) {
        return this.listenerRegistry.addRequestHandler(this, requestHandler, new ListenerRequestMatcher(new DefaultMethodRequestMatcher(methods.toArray(new String[methods.size()])), path));
    }

    public RequestHandlerManager addRequestHandler(String path, RequestHandler requestHandler) {
        return this.listenerRegistry.addRequestHandler(this, requestHandler, new ListenerRequestMatcher(AcceptsAllMethodsRequestMatcher.instance(), path));
    }

    @Override
    public ExecutorService get() {
        return this.scheduler;
    }
}

