/*
 * Decompiled with CFR 0.152.
 */
package org.mule.services.http.impl.service.server.grizzly;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpProbe;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.KeepAlive;
import org.glassfish.grizzly.nio.NIOChannelDistributor;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RoundRobinConnectionDistributor;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.service.http.api.server.HttpServer;
import org.mule.service.http.api.server.ServerAddress;
import org.mule.service.http.api.tcp.TcpServerSocketProperties;
import org.mule.services.http.impl.service.client.HttpMessageLogger;
import org.mule.services.http.impl.service.server.HttpListenerRegistry;
import org.mule.services.http.impl.service.server.HttpServerManager;
import org.mule.services.http.impl.service.server.grizzly.ExecutorPerServerAddressIOStrategy;
import org.mule.services.http.impl.service.server.grizzly.GrizzlyAddressDelegateFilter;
import org.mule.services.http.impl.service.server.grizzly.GrizzlyHttpServer;
import org.mule.services.http.impl.service.server.grizzly.GrizzlyRequestDispatcherFilter;
import org.mule.services.http.impl.service.server.grizzly.IdleExecutor;
import org.mule.services.http.impl.service.server.grizzly.MuleSslFilter;
import org.mule.services.http.impl.service.server.grizzly.WorkManagerSourceExecutorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyServerManager
implements HttpServerManager {
    public static final String MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY = "mule.http.headerSectionSize";
    private static final int MAX_KEEP_ALIVE_REQUESTS = -1;
    private final GrizzlyAddressDelegateFilter<SSLFilter> sslFilterDelegate;
    private final GrizzlyAddressDelegateFilter<HttpServerFilter> httpServerFilterDelegate;
    private final TCPNIOTransport transport;
    private final GrizzlyRequestDispatcherFilter requestHandlerFilter;
    private final HttpListenerRegistry httpListenerRegistry;
    private final WorkManagerSourceExecutorProvider executorProvider;
    private final ExecutorService idleTimeoutExecutorService;
    private Logger logger = LoggerFactory.getLogger(GrizzlyServerManager.class);
    private Map<ServerAddress, GrizzlyHttpServer> servers = new ConcurrentHashMap<ServerAddress, GrizzlyHttpServer>();
    private Map<ServerAddress, IdleExecutor> idleExecutorPerServerAddressMap = new ConcurrentHashMap<ServerAddress, IdleExecutor>();
    private boolean transportStarted;

    public GrizzlyServerManager(ExecutorService selectorPool, ExecutorService workerPool, ExecutorService idleTimeoutExecutorService, HttpListenerRegistry httpListenerRegistry, TcpServerSocketProperties serverSocketProperties) throws IOException {
        this.httpListenerRegistry = httpListenerRegistry;
        this.requestHandlerFilter = new GrizzlyRequestDispatcherFilter(httpListenerRegistry);
        this.sslFilterDelegate = new GrizzlyAddressDelegateFilter();
        this.httpServerFilterDelegate = new GrizzlyAddressDelegateFilter();
        FilterChainBuilder serverFilterChainBuilder = FilterChainBuilder.stateless();
        serverFilterChainBuilder.add((Filter)new TransportFilter());
        serverFilterChainBuilder.add(this.sslFilterDelegate);
        serverFilterChainBuilder.add(this.httpServerFilterDelegate);
        serverFilterChainBuilder.add((Filter)this.requestHandlerFilter);
        this.executorProvider = new WorkManagerSourceExecutorProvider();
        TCPNIOTransportBuilder transportBuilder = (TCPNIOTransportBuilder)((TCPNIOTransportBuilder)TCPNIOTransportBuilder.newInstance().setOptimizedForMultiplexing(true)).setIOStrategy((IOStrategy)new ExecutorPerServerAddressIOStrategy(this.executorProvider));
        this.configureServerSocketProperties(transportBuilder, serverSocketProperties);
        this.transport = transportBuilder.build();
        this.transport.setNIOChannelDistributor((NIOChannelDistributor)new RoundRobinConnectionDistributor((NIOTransport)this.transport, true, true));
        this.transport.setWorkerThreadPool(workerPool);
        this.transport.setKernelThreadPool(selectorPool);
        this.transport.setProcessor((Processor)serverFilterChainBuilder.build());
        this.idleTimeoutExecutorService = idleTimeoutExecutorService;
    }

    private void configureServerSocketProperties(TCPNIOTransportBuilder transportBuilder, TcpServerSocketProperties serverSocketProperties) {
        if (serverSocketProperties.getKeepAlive() != null) {
            transportBuilder.setKeepAlive(serverSocketProperties.getKeepAlive().booleanValue());
        }
        if (serverSocketProperties.getLinger() != null) {
            transportBuilder.setLinger(serverSocketProperties.getLinger().intValue());
        }
        if (serverSocketProperties.getReceiveBufferSize() != null) {
            transportBuilder.setReadBufferSize(serverSocketProperties.getReceiveBufferSize().intValue());
        }
        if (serverSocketProperties.getSendBufferSize() != null) {
            transportBuilder.setWriteBufferSize(serverSocketProperties.getSendBufferSize().intValue());
        }
        if (serverSocketProperties.getClientTimeout() != null) {
            transportBuilder.setClientSocketSoTimeout(serverSocketProperties.getClientTimeout().intValue());
        }
        if (serverSocketProperties.getServerTimeout() != null) {
            transportBuilder.setServerSocketSoTimeout(serverSocketProperties.getServerTimeout().intValue());
        }
        transportBuilder.setReuseAddress(serverSocketProperties.getReuseAddress().booleanValue());
        transportBuilder.setTcpNoDelay(serverSocketProperties.getSendTcpNoDelay().booleanValue());
        transportBuilder.setServerConnectionBackLog(serverSocketProperties.getReceiveBacklog().intValue());
    }

    private void startTransportIfNotStarted() throws IOException {
        ClassUtils.withContextClassLoader((ClassLoader)this.getClass().getClassLoader(), () -> {
            if (!this.transportStarted) {
                this.transportStarted = true;
                this.transport.start();
            }
            return null;
        }, IOException.class, e -> {
            throw new IOException(e);
        });
    }

    @Override
    public boolean containsServerFor(ServerAddress serverAddress) {
        return this.servers.containsKey(serverAddress) || this.containsOverlappingServerFor(serverAddress);
    }

    private boolean containsOverlappingServerFor(ServerAddress newServerAddress) {
        for (ServerAddress serverAddress : this.servers.keySet()) {
            if (!serverAddress.overlaps(newServerAddress)) continue;
            return true;
        }
        return false;
    }

    @Override
    public HttpServer createSslServerFor(TlsContextFactory tlsContextFactory, Supplier<Scheduler> schedulerSupplier, ServerAddress serverAddress, boolean usePersistentConnections, int connectionIdleTimeout) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Creating https server socket for ip {} and port {}", (Object)serverAddress.getIp(), (Object)serverAddress.getPort());
        }
        if (this.servers.containsKey(serverAddress)) {
            throw new IllegalStateException(String.format("Could not create a server for %s since there's already one.", serverAddress));
        }
        this.startTransportIfNotStarted();
        this.sslFilterDelegate.addFilterForAddress(serverAddress, this.createSslFilter(tlsContextFactory));
        this.httpServerFilterDelegate.addFilterForAddress(serverAddress, this.createHttpServerFilter(serverAddress, connectionIdleTimeout, usePersistentConnections));
        GrizzlyHttpServerWrapper grizzlyServer = new GrizzlyHttpServerWrapper(serverAddress, this.transport, this.httpListenerRegistry, schedulerSupplier, () -> this.executorProvider.removeExecutor(serverAddress));
        this.executorProvider.addExecutor(serverAddress, grizzlyServer);
        this.servers.put(serverAddress, grizzlyServer);
        return grizzlyServer;
    }

    @Override
    public HttpServer createServerFor(ServerAddress serverAddress, Supplier<Scheduler> schedulerSupplier, boolean usePersistentConnections, int connectionIdleTimeout) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Creating http server socket for ip {} and port {}", (Object)serverAddress.getIp(), (Object)serverAddress.getPort());
        }
        if (this.servers.containsKey(serverAddress)) {
            throw new IllegalStateException(String.format("Could not create a server for %s since there's already one.", serverAddress));
        }
        this.startTransportIfNotStarted();
        this.httpServerFilterDelegate.addFilterForAddress(serverAddress, this.createHttpServerFilter(serverAddress, connectionIdleTimeout, usePersistentConnections));
        GrizzlyHttpServerWrapper grizzlyServer = new GrizzlyHttpServerWrapper(serverAddress, this.transport, this.httpListenerRegistry, schedulerSupplier, () -> this.executorProvider.removeExecutor(serverAddress));
        this.executorProvider.addExecutor(serverAddress, grizzlyServer);
        this.servers.put(serverAddress, grizzlyServer);
        return grizzlyServer;
    }

    @Override
    public void dispose() {
        if (this.transportStarted) {
            this.transport.shutdown();
            this.servers.clear();
        }
    }

    private SSLFilter createSslFilter(TlsContextFactory tlsContextFactory) {
        try {
            String[] enabledCipherSuites;
            boolean clientAuth = tlsContextFactory.isTrustStoreConfigured();
            SSLEngineConfigurator serverConfig = new SSLEngineConfigurator(tlsContextFactory.createSslContext(), false, clientAuth, false);
            String[] enabledProtocols = tlsContextFactory.getEnabledProtocols();
            if (enabledProtocols != null) {
                serverConfig.setEnabledProtocols(enabledProtocols);
            }
            if ((enabledCipherSuites = tlsContextFactory.getEnabledCipherSuites()) != null) {
                serverConfig.setEnabledCipherSuites(enabledCipherSuites);
            }
            SSLEngineConfigurator clientConfig = serverConfig.copy().setClientMode(true);
            return new MuleSslFilter(serverConfig, clientConfig);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private HttpServerFilter createHttpServerFilter(ServerAddress serverAddress, int connectionIdleTimeout, boolean usePersistentConnections) {
        KeepAlive ka = null;
        if (usePersistentConnections) {
            ka = new KeepAlive();
            ka.setMaxRequestsCount(-1);
            ka.setIdleTimeoutInSeconds((int)TimeUnit.MILLISECONDS.toSeconds(connectionIdleTimeout));
        }
        IdleExecutor idleExecutor = new IdleExecutor(this.idleTimeoutExecutorService);
        this.idleExecutorPerServerAddressMap.put(serverAddress, idleExecutor);
        HttpServerFilter httpServerFilter = new HttpServerFilter(true, this.retrieveMaximumHeaderSectionSize(), ka, idleExecutor.getIdleTimeoutDelayedExecutor());
        httpServerFilter.getMonitoringConfig().addProbes((Object[])new HttpProbe[]{new HttpMessageLogger(HttpMessageLogger.LoggerType.LISTENER)});
        httpServerFilter.setAllowPayloadForUndefinedHttpMethods(true);
        return httpServerFilter;
    }

    private int retrieveMaximumHeaderSectionSize() {
        try {
            return Integer.valueOf(System.getProperty(MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY, String.valueOf(8192)));
        }
        catch (NumberFormatException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Invalid value %s for %s configuration", System.getProperty(MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY), MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY)), (Throwable)e);
        }
    }

    private class GrizzlyHttpServerWrapper
    extends GrizzlyHttpServer {
        public GrizzlyHttpServerWrapper(ServerAddress serverAddress, TCPNIOTransport transport, HttpListenerRegistry listenerRegistry, Supplier<Scheduler> schedulerSupplier, Runnable schedulerDisposer) {
            super(serverAddress, transport, listenerRegistry, schedulerSupplier, schedulerDisposer);
        }

        @Override
        public synchronized void start() throws IOException {
            ((IdleExecutor)GrizzlyServerManager.this.idleExecutorPerServerAddressMap.get(this.getServerAddress())).start();
            super.start();
        }

        @Override
        public synchronized void dispose() {
            super.dispose();
            ServerAddress serverAddress = this.getServerAddress();
            GrizzlyServerManager.this.servers.remove(serverAddress);
            GrizzlyServerManager.this.httpListenerRegistry.removeHandlersFor(this);
            GrizzlyServerManager.this.httpServerFilterDelegate.removeFilterForAddress(serverAddress);
            ((IdleExecutor)GrizzlyServerManager.this.idleExecutorPerServerAddressMap.get(serverAddress)).dispose();
            GrizzlyServerManager.this.idleExecutorPerServerAddressMap.remove(serverAddress);
            GrizzlyServerManager.this.sslFilterDelegate.removeFilterForAddress(serverAddress);
        }
    }
}

