/*
 * Decompiled with CFR 0.152.
 */
package org.mule.services.http.impl.service.server.grizzly;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLSession;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.mule.runtime.module.http.internal.domain.request.DefaultClientConnection;
import org.mule.runtime.module.http.internal.domain.request.DefaultHttpRequestContext;
import org.mule.runtime.module.http.internal.listener.RequestHandlerProvider;
import org.mule.runtime.module.http.internal.listener.grizzly.GrizzlyHttpRequestAdapter;
import org.mule.runtime.module.http.internal.listener.grizzly.ResponseCompletionHandler;
import org.mule.runtime.module.http.internal.listener.grizzly.ResponseStreamingCompletionHandler;
import org.mule.service.http.api.HttpConstants;
import org.mule.service.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.service.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.api.domain.request.HttpRequestContext;
import org.mule.service.http.api.server.RequestHandler;

public class GrizzlyRequestDispatcherFilter
extends BaseFilter {
    private final RequestHandlerProvider requestHandlerProvider;

    GrizzlyRequestDispatcherFilter(RequestHandlerProvider requestHandlerProvider) {
        this.requestHandlerProvider = requestHandlerProvider;
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        String scheme = ctx.getAttributes().getAttribute(HttpConstants.Protocols.HTTPS.getScheme()) == null ? HttpConstants.Protocols.HTTP.getScheme() : HttpConstants.Protocols.HTTPS.getScheme();
        String ip = ((InetSocketAddress)ctx.getConnection().getLocalAddress()).getAddress().getHostAddress();
        int port = ((InetSocketAddress)ctx.getConnection().getLocalAddress()).getPort();
        if (ctx.getMessage() instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)ctx.getMessage();
            HttpRequestPacket request = (HttpRequestPacket)httpContent.getHttpHeader();
            if (request.requiresAcknowledgement()) {
                HttpResponsePacket.Builder responsePacketBuilder = HttpResponsePacket.builder((HttpRequestPacket)request);
                if ("100-continue".equalsIgnoreCase(request.getHeader("Expect"))) {
                    responsePacketBuilder.status(HttpStatus.CONINTUE_100.getStatusCode());
                    HttpResponsePacket packet = responsePacketBuilder.build();
                    packet.setAcknowledgement(true);
                    ctx.write((Object)packet);
                    return ctx.getStopAction();
                }
                responsePacketBuilder.status(HttpStatus.EXPECTATION_FAILED_417.getStatusCode());
                ctx.write((Object)responsePacketBuilder.build());
                return ctx.getStopAction();
            }
            GrizzlyHttpRequestAdapter httpRequest = new GrizzlyHttpRequestAdapter(ctx, httpContent);
            DefaultHttpRequestContext requestContext = this.createRequestContext(ctx, scheme, httpRequest);
            RequestHandler requestHandler = this.requestHandlerProvider.getRequestHandler(ip, port, (HttpRequest)httpRequest);
            requestHandler.handleRequest((HttpRequestContext)requestContext, (httpResponse, responseStatusCallback) -> {
                try {
                    if (httpResponse.getEntity() instanceof InputStreamHttpEntity) {
                        new ResponseStreamingCompletionHandler(ctx, request, httpResponse, responseStatusCallback).start();
                    } else {
                        new ResponseCompletionHandler(ctx, request, httpResponse, responseStatusCallback).start();
                    }
                }
                catch (Exception e) {
                    responseStatusCallback.responseSendFailure((Throwable)e);
                }
            });
            return ctx.getSuspendAction();
        }
        return ctx.getInvokeAction();
    }

    private DefaultHttpRequestContext createRequestContext(FilterChainContext ctx, String scheme, GrizzlyHttpRequestAdapter httpRequest) {
        SSLSession sslSession = (SSLSession)ctx.getAttributes().getAttribute("muleSslSession");
        DefaultClientConnection clientConnection = sslSession != null ? new DefaultClientConnection(sslSession, (InetSocketAddress)ctx.getConnection().getPeerAddress()) : new DefaultClientConnection((InetSocketAddress)ctx.getConnection().getPeerAddress());
        return new DefaultHttpRequestContext((HttpRequest)httpRequest, clientConnection, scheme);
    }
}

