/*
 * Decompiled with CFR 0.152.
 */
package org.mule.services.http;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.junit.rules.ExternalResource;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.service.http.api.HttpService;
import org.mule.service.http.api.client.HttpClient;
import org.mule.service.http.api.client.HttpClientConfiguration;
import org.mule.service.http.api.client.HttpRequestAuthentication;
import org.mule.service.http.api.client.async.ResponseHandler;
import org.mule.service.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.api.domain.message.response.HttpResponse;
import org.mule.services.http.impl.service.HttpServiceImplementation;

public class TestHttpClient
extends ExternalResource
implements HttpClient {
    private final HttpService httpService;
    private TlsContextFactory tlsContextFactory;
    private HttpClient httpClient;

    private TestHttpClient() {
        this((HttpService)new HttpServiceImplementation());
    }

    private TestHttpClient(HttpService httpService) {
        Preconditions.checkArgument((httpService != null ? 1 : 0) != 0, (String)"httpService cannot be null");
        this.httpService = httpService;
    }

    protected void before() throws Throwable {
        HttpClientConfiguration.Builder builder = new HttpClientConfiguration.Builder();
        if (this.tlsContextFactory != null) {
            builder.setTlsContextFactory(this.tlsContextFactory);
        }
        HttpClientConfiguration configuration = builder.build();
        this.httpClient = this.httpService.getClientFactory().create(configuration);
        this.httpClient.start();
    }

    protected void after() {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }

    public void start() {
        this.httpClient.start();
    }

    public void stop() {
        this.httpClient.stop();
    }

    public HttpResponse send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpRequestAuthentication authentication) throws IOException, TimeoutException {
        return this.httpClient.send(request, responseTimeout, followRedirects, authentication);
    }

    public void send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpRequestAuthentication authentication, ResponseHandler handler) {
        this.httpClient.send(request, responseTimeout, followRedirects, authentication, handler);
    }

    public static class Builder {
        private final HttpService service;
        private TlsContextFactory tlsContextFactory;

        public Builder() {
            this.service = null;
        }

        public Builder(HttpService httpService) {
            this.service = httpService;
        }

        public Builder tlsContextFactory(TlsContextFactory tlsContextFactory) {
            this.tlsContextFactory = tlsContextFactory;
            return this;
        }

        public TestHttpClient build() {
            TestHttpClient httpClient = this.service == null ? new TestHttpClient() : new TestHttpClient(this.service);
            httpClient.tlsContextFactory = this.tlsContextFactory;
            return httpClient;
        }
    }
}

