/*
 * Decompiled with CFR 0.152.
 */
package org.mule.services.http.impl.service.server.grizzly;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.module.http.internal.listener.DefaultServerAddress;
import org.mule.runtime.module.http.internal.listener.HttpListenerRegistry;
import org.mule.service.http.api.HttpConstants;
import org.mule.service.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.api.server.HttpServer;
import org.mule.service.http.api.server.ServerAddress;
import org.mule.service.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.api.tcp.TcpServerSocketProperties;
import org.mule.services.http.impl.service.server.grizzly.GrizzlyServerManager;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class GrizzlyServerManagerTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public DynamicPort listenerPort = new DynamicPort("listener.port");
    private ExecutorService selectorPool;
    private ExecutorService workerPool;
    private ExecutorService idleTimeoutExecutorService;

    @Before
    public void before() {
        this.selectorPool = Executors.newCachedThreadPool();
        this.workerPool = Executors.newCachedThreadPool();
        this.idleTimeoutExecutorService = Executors.newCachedThreadPool();
    }

    @After
    public void after() {
        this.selectorPool.shutdown();
        this.workerPool.shutdown();
        this.idleTimeoutExecutorService.shutdown();
    }

    @Test
    public void managerDisposeClosesServerOpenConnections() throws IOException {
        GrizzlyServerManager serverManager = new GrizzlyServerManager("prefix", new HttpListenerRegistry(), (TcpServerSocketProperties)new DefaultTcpServerSocketProperties());
        HttpServer server = serverManager.createServerFor((ServerAddress)new DefaultServerAddress("0.0.0.0", this.listenerPort.getNumber()), () -> muleContext.getSchedulerService().ioScheduler(), true, (int)TimeUnit.SECONDS.toMillis(60L));
        ResponseStatusCallback responseStatusCallback = (ResponseStatusCallback)Mockito.mock(ResponseStatusCallback.class);
        server.addRequestHandler("/path", (requestContext, responseCallback) -> responseCallback.responseReady(HttpResponse.builder().setStatusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode())).build(), responseStatusCallback));
        server.start();
        try (Socket clientSocket = new Socket("localhost", this.listenerPort.getNumber());){
            String t;
            PrintWriter writer = new PrintWriter(clientSocket.getOutputStream());
            writer.println("GET /path HTTP/1.1");
            writer.println("Host: localhost");
            writer.println("");
            writer.flush();
            BufferedReader br = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
            while ((t = br.readLine()) != null && !t.equals("0")) {
            }
            ((ResponseStatusCallback)Mockito.verify((Object)responseStatusCallback, (VerificationMode)Mockito.timeout((long)1000L))).responseSendSuccessfully();
            server.stop();
            serverManager.dispose();
            while ((t = br.readLine()) != null) {
            }
            br.close();
        }
    }

    private class DefaultTcpServerSocketProperties
    implements TcpServerSocketProperties {
        private DefaultTcpServerSocketProperties() {
        }

        public Integer getSendBufferSize() {
            return null;
        }

        public Integer getReceiveBufferSize() {
            return null;
        }

        public Integer getClientTimeout() {
            return null;
        }

        public Boolean getSendTcpNoDelay() {
            return true;
        }

        public Integer getLinger() {
            return null;
        }

        public Boolean getKeepAlive() {
            return false;
        }

        public Boolean getReuseAddress() {
            return true;
        }

        public Integer getReceiveBacklog() {
            return 50;
        }

        public Integer getServerTimeout() {
            return null;
        }
    }
}

