/*
 * Decompiled with CFR 0.152.
 */
package org.mule.services.http.impl.service.server;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.NetworkUtils;
import org.mule.runtime.module.http.internal.listener.DefaultServerAddress;
import org.mule.runtime.module.http.internal.listener.HttpListenerRegistry;
import org.mule.runtime.module.http.internal.listener.HttpServerManager;
import org.mule.service.http.api.server.HttpServer;
import org.mule.service.http.api.server.HttpServerConfiguration;
import org.mule.service.http.api.server.HttpServerFactory;
import org.mule.service.http.api.server.ServerAddress;
import org.mule.service.http.api.tcp.TcpServerSocketProperties;
import org.mule.services.http.impl.service.server.grizzly.GrizzlyServerManager;

public class HttpListenerConnectionManager
implements HttpServerFactory,
Initialisable,
Disposable {
    public static final String SERVER_ALREADY_EXISTS_FORMAT = "A server in port(%s) already exists for ip(%s) or one overlapping it (0.0.0.0).";
    private static final String LISTENER_THREAD_NAME_PREFIX = "http.listener";
    private HttpListenerRegistry httpListenerRegistry = new HttpListenerRegistry();
    private HttpServerManager httpServerManager;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public void initialise() throws InitialisationException {
        if (this.initialized.getAndSet(true)) {
            return;
        }
        DefaultTcpServerSocketProperties tcpServerSocketProperties = new DefaultTcpServerSocketProperties();
        try {
            this.httpServerManager = new GrizzlyServerManager(LISTENER_THREAD_NAME_PREFIX, this.httpListenerRegistry, tcpServerSocketProperties);
        }
        catch (IOException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public synchronized void dispose() {
        this.httpServerManager.dispose();
    }

    public HttpServer create(HttpServerConfiguration configuration) throws ConnectionException {
        ServerAddress serverAddress;
        String host = configuration.getHost();
        try {
            serverAddress = this.createServerAddress(host, configuration.getPort());
        }
        catch (UnknownHostException e) {
            throw new ConnectionException(String.format("Cannot resolve host %s", host), (Throwable)e);
        }
        TlsContextFactory tlsContextFactory = configuration.getTlsContextFactory();
        HttpServer httpServer = tlsContextFactory == null ? this.createServer(serverAddress, configuration.getSchedulerSupplier(), configuration.isUsePersistentConnections(), configuration.getConnectionIdleTimeout()) : this.createSslServer(serverAddress, tlsContextFactory, configuration.getSchedulerSupplier(), configuration.isUsePersistentConnections(), configuration.getConnectionIdleTimeout());
        return httpServer;
    }

    public HttpServer createServer(ServerAddress serverAddress, Supplier<Scheduler> schedulerSupplier, boolean usePersistentConnections, int connectionIdleTimeout) {
        if (!this.containsServerFor(serverAddress)) {
            try {
                return this.httpServerManager.createServerFor(serverAddress, schedulerSupplier, usePersistentConnections, connectionIdleTimeout);
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format(SERVER_ALREADY_EXISTS_FORMAT, serverAddress.getPort(), serverAddress.getIp())));
    }

    public boolean containsServerFor(ServerAddress serverAddress) {
        return this.httpServerManager.containsServerFor(serverAddress);
    }

    public HttpServer createSslServer(ServerAddress serverAddress, TlsContextFactory tlsContext, Supplier<Scheduler> schedulerSupplier, boolean usePersistentConnections, int connectionIdleTimeout) {
        if (!this.containsServerFor(serverAddress)) {
            try {
                return this.httpServerManager.createSslServerFor(tlsContext, schedulerSupplier, serverAddress, usePersistentConnections, connectionIdleTimeout);
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format(SERVER_ALREADY_EXISTS_FORMAT, serverAddress.getPort(), serverAddress.getIp())));
    }

    private ServerAddress createServerAddress(String host, int port) throws UnknownHostException {
        return new DefaultServerAddress(NetworkUtils.getLocalHostIp((String)host), port);
    }

    private class DefaultTcpServerSocketProperties
    implements TcpServerSocketProperties {
        private DefaultTcpServerSocketProperties() {
        }

        public Integer getSendBufferSize() {
            return null;
        }

        public Integer getReceiveBufferSize() {
            return null;
        }

        public Integer getClientTimeout() {
            return null;
        }

        public Boolean getSendTcpNoDelay() {
            return true;
        }

        public Integer getLinger() {
            return null;
        }

        public Boolean getKeepAlive() {
            return false;
        }

        public Boolean getReuseAddress() {
            return true;
        }

        public Integer getReceiveBacklog() {
            return 50;
        }

        public Integer getServerTimeout() {
            return null;
        }
    }
}

