/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.oauth.internal.builder;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.api.builder.OAuthClientCredentialsDancerBuilder;
import org.mule.runtime.oauth.api.state.DefaultResourceOwnerOAuthContext;
import org.mule.service.oauth.internal.DefaultClientCredentialsOAuthDancer;
import org.mule.service.oauth.internal.builder.AbstractOAuthDancerBuilder;

public class DefaultOAuthClientCredentialsDancerBuilder
extends AbstractOAuthDancerBuilder<ClientCredentialsOAuthDancer>
implements OAuthClientCredentialsDancerBuilder {
    public DefaultOAuthClientCredentialsDancerBuilder(LockFactory lockProvider, Map<String, DefaultResourceOwnerOAuthContext> tokensStore, LoadingCache<Pair<TlsContextFactory, ProxyConfig>, HttpClient> httpClientCache, MuleExpressionLanguage expressionEvaluator) {
        super(lockProvider, tokensStore, httpClientCache, expressionEvaluator);
    }

    public OAuthClientCredentialsDancerBuilder encodeClientCredentialsInBody(boolean encodeClientCredentialsInBody) {
        return (OAuthClientCredentialsDancerBuilder)super.encodeClientCredentialsInBody(encodeClientCredentialsInBody);
    }

    public ClientCredentialsOAuthDancer build() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientId), (String)"clientId cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientSecret), (String)"clientSecret cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.tokenUrl), (String)"tokenUrl cannot be blank");
        return new DefaultClientCredentialsOAuthDancer(this.clientId, this.clientSecret, this.tokenUrl, this.scopes, this.clientCredentialsLocation, this.encoding, this.responseAccessTokenExpr, this.responseRefreshTokenExpr, this.responseExpiresInExpr, (Map<String, String>)this.customParametersExtractorsExprs, (Function<String, String>)this.resourceOwnerIdTransformer, this.lockProvider, (Map<String, DefaultResourceOwnerOAuthContext>)this.tokensStore, (HttpClient)this.httpClientFactory.get(), this.expressionEvaluator);
    }
}

