/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.oauth.internal;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.api.builder.ClientCredentialsLocation;
import org.mule.runtime.oauth.api.exception.RequestAuthenticationException;
import org.mule.runtime.oauth.api.exception.TokenNotFoundException;
import org.mule.runtime.oauth.api.exception.TokenUrlResponseException;
import org.mule.runtime.oauth.api.state.DefaultResourceOwnerOAuthContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.service.oauth.internal.AbstractOAuthDancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientCredentialsOAuthDancer
extends AbstractOAuthDancer
implements Startable,
ClientCredentialsOAuthDancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClientCredentialsOAuthDancer.class);
    private boolean accessTokenRefreshedOnStart = false;
    private volatile CompletableFuture<Void> lastRefreshTokenFuture;
    private Lock refreshTokenLock;

    public DefaultClientCredentialsOAuthDancer(String clientId, String clientSecret, String tokenUrl, String scopes, ClientCredentialsLocation clientCredentialsLocation, Charset encoding, String responseAccessTokenExpr, String responseRefreshTokenExpr, String responseExpiresInExpr, Map<String, String> customParametersExprs, Function<String, String> resourceOwnerIdTransformer, LockFactory lockProvider, Map<String, DefaultResourceOwnerOAuthContext> tokensStore, HttpClient httpClient, MuleExpressionLanguage expressionEvaluator) {
        super(clientId, clientSecret, tokenUrl, encoding, scopes, clientCredentialsLocation, responseAccessTokenExpr, responseRefreshTokenExpr, responseExpiresInExpr, customParametersExprs, resourceOwnerIdTransformer, lockProvider, tokensStore, httpClient, expressionEvaluator);
    }

    @Override
    public void start() throws MuleException {
        super.start();
        this.refreshTokenLock = new ReentrantLock();
        try {
            this.refreshToken().get();
            this.accessTokenRefreshedOnStart = true;
        }
        catch (ExecutionException e) {
            if (!(e.getCause() instanceof TokenUrlResponseException) && !(e.getCause() instanceof TokenNotFoundException)) {
                super.stop();
                throw new LifecycleException(e.getCause(), (Object)this);
            }
        }
        catch (InterruptedException e) {
            super.stop();
            Thread.currentThread().interrupt();
            throw new LifecycleException((Throwable)e, (Object)this);
        }
    }

    public CompletableFuture<String> accessToken() throws RequestAuthenticationException {
        if (!this.accessTokenRefreshedOnStart) {
            this.accessTokenRefreshedOnStart = true;
            return this.refreshToken().thenApply(v -> this.getContext().getAccessToken());
        }
        String accessToken = this.getContext().getAccessToken();
        if (accessToken == null) {
            LOGGER.info("Previously stored token has been invalidated. Refreshing...");
            return this.refreshToken().thenApply(v -> this.getContext().getAccessToken());
        }
        return CompletableFuture.completedFuture(accessToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> refreshToken() {
        boolean lockWasAcqired = this.refreshTokenLock.tryLock();
        if (lockWasAcqired) {
            try {
                CompletableFuture<Void> completableFuture = this.lastRefreshTokenFuture = this.doRefreshToken();
                return completableFuture;
            }
            finally {
                this.refreshTokenLock.unlock();
            }
        }
        this.refreshTokenLock.lock();
        try {
            CompletableFuture<Void> completableFuture = this.lastRefreshTokenFuture;
            return completableFuture;
        }
        finally {
            this.refreshTokenLock.unlock();
        }
    }

    private CompletableFuture<Void> doRefreshToken() {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("grant_type", "client_credentials");
        if (this.scopes != null) {
            formData.put("scope", this.scopes);
        }
        String authorization = this.handleClientCredentials(formData);
        return this.invokeTokenUrl(this.tokenUrl, formData, (MultiMap<String, String>)MultiMap.emptyMultiMap(), authorization, false, this.encoding).thenAccept(tokenResponse -> ClassUtils.withContextClassLoader((ClassLoader)DefaultClientCredentialsOAuthDancer.class.getClassLoader(), () -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Retrieved access token, refresh token and expires from token url are: %s, %s, %s", new Object[]{tokenResponse.getAccessToken(), tokenResponse.getRefreshToken(), tokenResponse.getExpiresIn()});
            }
            DefaultResourceOwnerOAuthContext defaultUserState = (DefaultResourceOwnerOAuthContext)this.getContext();
            defaultUserState.setAccessToken(tokenResponse.getAccessToken());
            defaultUserState.setExpiresIn(tokenResponse.getExpiresIn());
            for (Map.Entry<String, Object> customResponseParameterEntry : tokenResponse.getCustomResponseParameters().entrySet()) {
                defaultUserState.getTokenResponseParameters().put(customResponseParameterEntry.getKey(), customResponseParameterEntry.getValue());
            }
            this.updateResourceOwnerOAuthContext(defaultUserState);
        }));
    }

    public void invalidateContext() {
        this.invalidateContext("default");
    }

    public ResourceOwnerOAuthContext getContext() {
        return this.getContextForResourceOwner("default");
    }
}

