/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.oauth.internal.builder;

import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.runtime.oauth.api.AuthorizationCodeOAuthDancer;
import org.mule.runtime.oauth.api.AuthorizationCodeRequest;
import org.mule.runtime.oauth.api.builder.AuthorizationCodeDanceCallbackContext;
import org.mule.runtime.oauth.api.builder.AuthorizationCodeListener;
import org.mule.runtime.oauth.api.builder.ClientCredentialsLocation;
import org.mule.runtime.oauth.api.builder.OAuthAuthorizationCodeDancerBuilder;
import org.mule.runtime.oauth.api.state.DefaultResourceOwnerOAuthContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.service.oauth.internal.DefaultAuthorizationCodeOAuthDancer;
import org.mule.service.oauth.internal.builder.AbstractOAuthDancerBuilder;

public class DefaultOAuthAuthorizationCodeDancerBuilder
extends AbstractOAuthDancerBuilder<AuthorizationCodeOAuthDancer>
implements OAuthAuthorizationCodeDancerBuilder {
    private Supplier<HttpServer> localCallbackServerFactory;
    private String localCallbackUrlPath;
    private String localAuthorizationUrlPath;
    private String localAuthorizationUrlResourceOwnerId;
    private String externalCallbackUrl;
    private String state;
    private String authorizationUrl;
    private List<AuthorizationCodeListener> listeners = new LinkedList<AuthorizationCodeListener>();
    private Supplier<Map<String, String>> customParameters = () -> Collections.emptyMap();
    private Supplier<Map<String, String>> customHeaders = () -> Collections.emptyMap();
    private Function<AuthorizationCodeRequest, AuthorizationCodeDanceCallbackContext> beforeDanceCallback = r -> k -> Optional.empty();
    private BiConsumer<AuthorizationCodeDanceCallbackContext, ResourceOwnerOAuthContext> afterDanceCallback = (vars, ctx) -> {};

    public DefaultOAuthAuthorizationCodeDancerBuilder(SchedulerService schedulerService, LockFactory lockProvider, Map<String, DefaultResourceOwnerOAuthContext> tokensStore, HttpService httpService, MuleExpressionLanguage expressionEvaluator) {
        super(lockProvider, tokensStore, httpService, expressionEvaluator);
        this.clientCredentialsLocation = ClientCredentialsLocation.BODY;
    }

    public OAuthAuthorizationCodeDancerBuilder localCallback(URL localCallbackUrl) {
        this.localCallbackServerFactory = () -> {
            HttpServerConfiguration.Builder serverConfigBuilder = new HttpServerConfiguration.Builder();
            serverConfigBuilder.setHost(localCallbackUrl.getHost()).setPort(localCallbackUrl.getPort()).setName(localCallbackUrl.toString());
            try {
                return this.httpService.getServerFactory().create(serverConfigBuilder.build());
            }
            catch (ServerCreationException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        };
        this.localCallbackUrlPath = localCallbackUrl.getPath();
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder localCallback(URL localCallbackUrl, TlsContextFactory tlsContextFactory) {
        this.localCallbackServerFactory = () -> {
            HttpServerConfiguration.Builder serverConfigBuilder = new HttpServerConfiguration.Builder();
            serverConfigBuilder.setHost(localCallbackUrl.getHost()).setPort(localCallbackUrl.getPort()).setName(localCallbackUrl.toString());
            serverConfigBuilder.setTlsContextFactory(tlsContextFactory);
            try {
                return this.httpService.getServerFactory().create(serverConfigBuilder.build());
            }
            catch (ServerCreationException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        };
        this.localCallbackUrlPath = localCallbackUrl.getPath();
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder localCallback(HttpServer server, String localCallbackConfigPath) {
        this.localCallbackServerFactory = () -> server;
        this.localCallbackUrlPath = localCallbackConfigPath;
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder localAuthorizationUrlPath(String path) {
        this.localAuthorizationUrlPath = path;
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder localAuthorizationUrlResourceOwnerId(String localAuthorizationUrlResourceOwnerIdExpr) {
        this.localAuthorizationUrlResourceOwnerId = localAuthorizationUrlResourceOwnerIdExpr;
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder customParameters(Map<String, String> customParameters) {
        Objects.requireNonNull(customParameters, "customParameters cannot be null");
        return this.customParameters(() -> customParameters);
    }

    public OAuthAuthorizationCodeDancerBuilder customParameters(Supplier<Map<String, String>> customParameters) {
        Objects.requireNonNull(customParameters, "customParameters cannot be null");
        this.customParameters = customParameters;
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder customHeaders(Map<String, String> customHeaders) {
        Objects.requireNonNull(customHeaders, "customHeaders cannot be null");
        return this.customHeaders(() -> customHeaders);
    }

    public OAuthAuthorizationCodeDancerBuilder customHeaders(Supplier<Map<String, String>> customHeaders) {
        Objects.requireNonNull(customHeaders, "customHeaders cannot be null");
        this.customHeaders = customHeaders;
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder state(String stateExpr) {
        this.state = stateExpr;
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder authorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder externalCallbackUrl(String externalCallbackUrl) {
        this.externalCallbackUrl = externalCallbackUrl;
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder beforeDanceCallback(Function<AuthorizationCodeRequest, AuthorizationCodeDanceCallbackContext> beforeDanceCallback) {
        Objects.requireNonNull(beforeDanceCallback, "beforeDanceCallback cannot be null");
        this.beforeDanceCallback = beforeDanceCallback;
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder afterDanceCallback(BiConsumer<AuthorizationCodeDanceCallbackContext, ResourceOwnerOAuthContext> afterDanceCallback) {
        Objects.requireNonNull(afterDanceCallback, "afterDanceCallback cannot be null");
        this.afterDanceCallback = afterDanceCallback;
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder encodeClientCredentialsInBody(boolean encodeClientCredentialsInBody) {
        return (OAuthAuthorizationCodeDancerBuilder)super.encodeClientCredentialsInBody(encodeClientCredentialsInBody);
    }

    public OAuthAuthorizationCodeDancerBuilder addListener(AuthorizationCodeListener listener) {
        Objects.requireNonNull(listener, "Cannot add a null listener");
        this.listeners.add(listener);
        return this;
    }

    public AuthorizationCodeOAuthDancer build() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientId), (String)"clientId cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientSecret), (String)"clientSecret cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.tokenUrl), (String)"tokenUrl cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.authorizationUrl), (String)"authorizationUrl cannot be blank");
        Optional<HttpServer> httpServer = this.localCallbackServerFactory != null ? Optional.of(this.localCallbackServerFactory.get()) : Optional.empty();
        return new DefaultAuthorizationCodeOAuthDancer(httpServer, this.clientId, this.clientSecret, this.tokenUrl, this.scopes, this.clientCredentialsLocation, this.externalCallbackUrl, this.encoding, this.localCallbackUrlPath, this.localAuthorizationUrlPath, this.localAuthorizationUrlResourceOwnerId, this.state, this.authorizationUrl, this.responseAccessTokenExpr, this.responseRefreshTokenExpr, this.responseExpiresInExpr, this.customParameters, this.customHeaders, this.customParametersExtractorsExprs, this.resourceOwnerIdTransformer, this.lockProvider, this.tokensStore, (HttpClient)this.httpClientFactory.get(), this.expressionEvaluator, this.beforeDanceCallback, this.afterDanceCallback, this.listeners);
    }
}

