/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.oauth.internal.builder;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.api.builder.ClientCredentialsListener;
import org.mule.runtime.oauth.api.builder.OAuthClientCredentialsDancerBuilder;
import org.mule.runtime.oauth.api.state.DefaultResourceOwnerOAuthContext;
import org.mule.service.oauth.internal.DefaultClientCredentialsOAuthDancer;
import org.mule.service.oauth.internal.builder.AbstractOAuthDancerBuilder;

public class DefaultOAuthClientCredentialsDancerBuilder
extends AbstractOAuthDancerBuilder<ClientCredentialsOAuthDancer>
implements OAuthClientCredentialsDancerBuilder {
    private List<ClientCredentialsListener> listeners = new LinkedList<ClientCredentialsListener>();
    private MultiMap<String, String> customParameters = new MultiMap();
    private MultiMap<String, String> customHeaders = new MultiMap();

    public DefaultOAuthClientCredentialsDancerBuilder(LockFactory lockProvider, Map<String, DefaultResourceOwnerOAuthContext> tokensStore, HttpService httpService, MuleExpressionLanguage expressionEvaluator) {
        super(lockProvider, tokensStore, httpService, expressionEvaluator);
    }

    public OAuthClientCredentialsDancerBuilder encodeClientCredentialsInBody(boolean encodeClientCredentialsInBody) {
        return (OAuthClientCredentialsDancerBuilder)super.encodeClientCredentialsInBody(encodeClientCredentialsInBody);
    }

    public OAuthClientCredentialsDancerBuilder customParameters(Map<String, String> customParameters) {
        Objects.requireNonNull(customParameters, "customParameters cannot be null");
        this.putAll(customParameters, this.customParameters);
        return this;
    }

    private void putAll(Map<String, String> source, MultiMap<String, String> target) {
        if (source instanceof MultiMap) {
            target.putAll((MultiMap)source);
        } else {
            target.putAll(source);
        }
    }

    public OAuthClientCredentialsDancerBuilder customHeaders(Map<String, String> customHeaders) {
        Objects.requireNonNull(customHeaders, "customHeaders cannot be null");
        this.putAll(customHeaders, this.customHeaders);
        return this;
    }

    public OAuthClientCredentialsDancerBuilder addListener(ClientCredentialsListener listener) {
        Objects.requireNonNull(listener, "Cannot add a null listener");
        this.listeners.add(listener);
        return this;
    }

    public ClientCredentialsOAuthDancer build() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientId), (String)"clientId cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientSecret), (String)"clientSecret cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.tokenUrl), (String)"tokenUrl cannot be blank");
        return new DefaultClientCredentialsOAuthDancer(this.clientId, this.clientSecret, this.tokenUrl, this.scopes, this.clientCredentialsLocation, this.encoding, this.responseAccessTokenExpr, this.responseRefreshTokenExpr, this.responseExpiresInExpr, this.customParametersExtractorsExprs, this.resourceOwnerIdTransformer, this.lockProvider, this.tokensStore, (HttpClient)this.httpClientFactory.get(), this.expressionEvaluator, this.customParameters, this.customHeaders, this.listeners);
    }
}

