/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.oauth.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpHeaders;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;
import org.mule.runtime.oauth.api.builder.ClientCredentialsLocation;
import org.mule.runtime.oauth.api.exception.TokenNotFoundException;
import org.mule.runtime.oauth.api.exception.TokenUrlResponseException;
import org.mule.runtime.oauth.api.state.DefaultResourceOwnerOAuthContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.service.oauth.internal.state.TokenResponse;

public abstract class AbstractOAuthDancer
implements Startable,
Stoppable {
    private static final int TOKEN_REQUEST_TIMEOUT_MILLIS = 60000;
    protected final String clientId;
    protected final String clientSecret;
    protected final String tokenUrl;
    protected final Charset encoding;
    protected final String scopes;
    protected final ClientCredentialsLocation clientCredentialsLocation;
    protected final String responseAccessTokenExpr;
    protected final String responseRefreshTokenExpr;
    protected final String responseExpiresInExpr;
    protected final Map<String, String> customParametersExtractorsExprs;
    protected final Function<String, String> resourceOwnerIdTransformer;
    private final LockFactory lockProvider;
    private final Map<String, DefaultResourceOwnerOAuthContext> tokensStore;
    private final HttpClient httpClient;
    private final MuleExpressionLanguage expressionEvaluator;

    protected AbstractOAuthDancer(String clientId, String clientSecret, String tokenUrl, Charset encoding, String scopes, ClientCredentialsLocation clientCredentialsLocation, String responseAccessTokenExpr, String responseRefreshTokenExpr, String responseExpiresInExpr, Map<String, String> customParametersExtractorsExprs, Function<String, String> resourceOwnerIdTransformer, LockFactory lockProvider, Map<String, DefaultResourceOwnerOAuthContext> tokensStore, HttpClient httpClient, MuleExpressionLanguage expressionEvaluator) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenUrl = tokenUrl;
        this.encoding = encoding;
        this.scopes = scopes;
        this.clientCredentialsLocation = clientCredentialsLocation;
        this.responseAccessTokenExpr = responseAccessTokenExpr;
        this.responseRefreshTokenExpr = responseRefreshTokenExpr;
        this.responseExpiresInExpr = responseExpiresInExpr;
        this.customParametersExtractorsExprs = customParametersExtractorsExprs;
        this.resourceOwnerIdTransformer = resourceOwnerIdTransformer;
        this.lockProvider = lockProvider;
        this.tokensStore = tokensStore;
        this.httpClient = httpClient;
        this.expressionEvaluator = expressionEvaluator;
    }

    public void start() throws MuleException {
        this.httpClient.start();
    }

    public void stop() throws MuleException {
        this.httpClient.stop();
    }

    protected String handleClientCredentials(Map<String, String> formData) {
        switch (this.clientCredentialsLocation) {
            case BASIC_AUTH_HEADER: {
                return "Basic " + Base64.encodeBase64String((byte[])String.format("%s:%s", this.clientId, this.clientSecret).getBytes());
            }
            case BODY: {
                formData.put("client_id", this.clientId);
                formData.put("client_secret", this.clientSecret);
            }
        }
        return null;
    }

    protected CompletableFuture<TokenResponse> invokeTokenUrl(String tokenUrl, Map<String, String> tokenRequestFormToSend, MultiMap<String, String> queryParams, MultiMap<String, String> headers, String authorization, boolean retrieveRefreshToken, Charset encoding) {
        HttpRequestBuilder requestBuilder = (HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(tokenUrl).method(HttpConstants.Method.POST.name()).entity((HttpEntity)new ByteArrayHttpEntity(HttpEncoderDecoderUtils.encodeString(tokenRequestFormToSend, (Charset)encoding).getBytes()))).addHeader("Content-Type", HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString())).queryParams(queryParams).headers(headers);
        if (authorization != null) {
            requestBuilder.addHeader("Authorization", authorization);
        } else if (ClientCredentialsLocation.QUERY_PARAMS.equals((Object)this.clientCredentialsLocation)) {
            requestBuilder.addQueryParam("client_id", this.clientId);
            requestBuilder.addQueryParam("client_secret", this.clientSecret);
        }
        return ((CompletableFuture)this.httpClient.sendAsync(requestBuilder.build(), HttpRequestOptions.builder().responseTimeout(60000).build()).exceptionally(t -> (HttpResponse)ClassUtils.withContextClassLoader((ClassLoader)AbstractOAuthDancer.class.getClassLoader(), () -> {
            if (t instanceof IOException) {
                throw new CompletionException((Throwable)new TokenUrlResponseException(tokenUrl, (Exception)((IOException)t)));
            }
            throw new CompletionException((Throwable)t);
        }))).thenApply(response -> (TokenResponse)ClassUtils.withContextClassLoader((ClassLoader)AbstractOAuthDancer.class.getClassLoader(), () -> {
            String body;
            String contentType = response.getHeaderValue("Content-Type");
            MediaType responseContentType = contentType != null ? MediaType.parse((String)contentType) : MediaType.ANY;
            try (InputStream content = response.getEntity().getContent();){
                body = IOUtils.toString((InputStream)content);
                if (response.getStatusCode() >= HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()) {
                    try {
                        throw new CompletionException((Throwable)new TokenUrlResponseException(tokenUrl, response, body));
                    }
                    catch (IOException e) {
                        throw new CompletionException((Throwable)new TokenUrlResponseException(tokenUrl, (Exception)e));
                    }
                }
            }
            MultiMap responseHeaders = response.getHeaders();
            TokenResponse tokenResponse = new TokenResponse();
            tokenResponse.setAccessToken((String)this.resolveExpression(this.responseAccessTokenExpr, body, (MultiMap<String, String>)responseHeaders, responseContentType));
            if (tokenResponse.getAccessToken() == null) {
                throw new CompletionException((Throwable)new TokenNotFoundException(tokenUrl, response, body));
            }
            if (retrieveRefreshToken) {
                tokenResponse.setRefreshToken((String)this.resolveExpression(this.responseRefreshTokenExpr, body, (MultiMap<String, String>)responseHeaders, responseContentType));
            }
            tokenResponse.setExpiresIn((String)this.resolveExpression(this.responseExpiresInExpr, body, (MultiMap<String, String>)responseHeaders, responseContentType));
            if (this.customParametersExtractorsExprs != null && !this.customParametersExtractorsExprs.isEmpty()) {
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                for (Map.Entry<String, String> customParamExpr : this.customParametersExtractorsExprs.entrySet()) {
                    customParams.put(customParamExpr.getKey(), this.resolveExpression(customParamExpr.getValue(), body, (MultiMap<String, String>)responseHeaders, responseContentType));
                }
                tokenResponse.setCustomResponseParameters(customParams);
            }
            return tokenResponse;
        }));
    }

    protected <T> T resolveExpression(String expr, Object body, MultiMap<String, String> headers, MediaType responseContentType) {
        if (expr == null) {
            return null;
        }
        if (!this.expressionEvaluator.isExpression(expr)) {
            return (T)expr;
        }
        BindingContext resultContext = BindingContext.builder().addBinding("payload", new TypedValue(body, DataType.builder().fromObject(body).mediaType(responseContentType).build())).addBinding("attributes", new TypedValue(Collections.singletonMap("headers", headers.toImmutableMultiMap()), DataType.fromType(Map.class))).addBinding("dataType", new TypedValue((Object)DataType.builder().fromObject(body).mediaType(responseContentType).build(), DataType.fromType(DataType.class))).build();
        return (T)this.expressionEvaluator.evaluate(expr, DataType.STRING, resultContext).getValue();
    }

    protected <T> T resolveExpression(String expr, Object body, MultiMap<String, String> headers, MultiMap<String, String> queryParams, MediaType responseContentType) {
        if (expr == null) {
            return null;
        }
        if (!this.expressionEvaluator.isExpression(expr)) {
            return (T)expr;
        }
        HashMap<String, MultiMap> attributes = new HashMap<String, MultiMap>(2);
        attributes.put("headers", headers.toImmutableMultiMap());
        attributes.put("queryParams", queryParams.toImmutableMultiMap());
        BindingContext resultContext = BindingContext.builder().addBinding("payload", new TypedValue(body, DataType.builder().fromObject(body).mediaType(responseContentType).build())).addBinding("attributes", new TypedValue(attributes, DataType.fromType(Map.class))).addBinding("dataType", new TypedValue((Object)DataType.builder().fromObject(body).mediaType(responseContentType).build(), DataType.fromType(DataType.class))).build();
        return (T)this.expressionEvaluator.evaluate(expr, DataType.STRING, resultContext).getValue();
    }

    public void invalidateContext(String resourceOwner) {
        DefaultResourceOwnerOAuthContext context = (DefaultResourceOwnerOAuthContext)this.getContextForResourceOwner(resourceOwner);
        context.getRefreshUserOAuthContextLock().lock();
        try {
            this.tokensStore.remove(this.resourceOwnerIdTransformer.apply(resourceOwner));
        }
        finally {
            context.getRefreshUserOAuthContextLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceOwnerOAuthContext getContextForResourceOwner(String resourceOwnerId) {
        if (resourceOwnerId == null) {
            resourceOwnerId = "default";
        }
        String transformedResourceOwnerId = this.resourceOwnerIdTransformer.apply(resourceOwnerId);
        DefaultResourceOwnerOAuthContext resourceOwnerOAuthContext = null;
        if (!this.tokensStore.containsKey(transformedResourceOwnerId)) {
            Lock lock = this.lockProvider.createLock(this.toString() + "-config-oauth-context");
            lock.lock();
            try {
                if (!this.tokensStore.containsKey(transformedResourceOwnerId)) {
                    resourceOwnerOAuthContext = new DefaultResourceOwnerOAuthContext(this.createLockForResourceOwner(transformedResourceOwnerId), resourceOwnerId);
                    this.tokensStore.put(transformedResourceOwnerId, resourceOwnerOAuthContext);
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (resourceOwnerOAuthContext == null) {
            resourceOwnerOAuthContext = this.tokensStore.get(transformedResourceOwnerId);
            resourceOwnerOAuthContext.setRefreshUserOAuthContextLock(this.createLockForResourceOwner(transformedResourceOwnerId));
        }
        return resourceOwnerOAuthContext;
    }

    private Lock createLockForResourceOwner(String resourceOwnerId) {
        String lockId = this.toString() + (StringUtils.isBlank((CharSequence)resourceOwnerId) ? "" : "-" + resourceOwnerId);
        return this.lockProvider.createLock(lockId);
    }

    protected void updateResourceOwnerOAuthContext(DefaultResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        Lock resourceOwnerContextLock = resourceOwnerOAuthContext.getRefreshUserOAuthContextLock();
        resourceOwnerContextLock.lock();
        try {
            this.tokensStore.put(this.resourceOwnerIdTransformer.apply(resourceOwnerOAuthContext.getResourceOwnerId()), resourceOwnerOAuthContext);
        }
        finally {
            resourceOwnerContextLock.unlock();
        }
    }
}

