/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.oauth.internal;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.api.builder.ClientCredentialsLocation;
import org.mule.runtime.oauth.api.exception.RequestAuthenticationException;
import org.mule.runtime.oauth.api.exception.TokenNotFoundException;
import org.mule.runtime.oauth.api.exception.TokenUrlResponseException;
import org.mule.runtime.oauth.api.listener.ClientCredentialsListener;
import org.mule.runtime.oauth.api.listener.OAuthStateListener;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.service.oauth.internal.AbstractOAuthDancer;
import org.mule.service.oauth.internal.ResourceOwnerOAuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientCredentialsOAuthDancer
extends AbstractOAuthDancer
implements Startable,
ClientCredentialsOAuthDancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClientCredentialsOAuthDancer.class);
    private boolean accessTokenRefreshedOnStart = false;
    private final MultiMap<String, String> customParameters;
    private final MultiMap<String, String> customHeaders;

    public DefaultClientCredentialsOAuthDancer(String name, String clientId, String clientSecret, String tokenUrl, String scopes, ClientCredentialsLocation clientCredentialsLocation, Charset encoding, String responseAccessTokenExpr, String responseRefreshTokenExpr, String responseExpiresInExpr, Map<String, String> customParametersExprs, Function<String, String> resourceOwnerIdTransformer, SchedulerService schedulerService, LockFactory lockProvider, Map<String, ResourceOwnerOAuthContext> tokensStore, HttpClient httpClient, MuleExpressionLanguage expressionEvaluator, MultiMap<String, String> customParameters, MultiMap<String, String> customHeaders, List<ClientCredentialsListener> listeners) {
        super(name, clientId, clientSecret, tokenUrl, encoding, scopes, clientCredentialsLocation, responseAccessTokenExpr, responseRefreshTokenExpr, responseExpiresInExpr, customParametersExprs, resourceOwnerIdTransformer, schedulerService, lockProvider, tokensStore, httpClient, expressionEvaluator, listeners);
        this.customParameters = customParameters;
        this.customHeaders = customHeaders;
    }

    @Override
    public void start() throws MuleException {
        super.start();
        try {
            this.refreshToken().get();
            this.accessTokenRefreshedOnStart = true;
        }
        catch (ExecutionException e) {
            if (!(e.getCause() instanceof TokenUrlResponseException) && !(e.getCause() instanceof TokenNotFoundException)) {
                super.stop();
                throw new LifecycleException(e.getCause(), (Object)this);
            }
        }
        catch (InterruptedException e) {
            super.stop();
            Thread.currentThread().interrupt();
            throw new LifecycleException((Throwable)e, (Object)this);
        }
    }

    public CompletableFuture<String> accessToken() throws RequestAuthenticationException {
        if (!this.accessTokenRefreshedOnStart) {
            this.accessTokenRefreshedOnStart = true;
            return this.refreshToken().thenApply(v -> this.getContext().getAccessToken());
        }
        String accessToken = this.getContext().getAccessToken();
        if (accessToken == null) {
            LOGGER.info("Previously stored token has been invalidated. Refreshing...");
            return this.doRefreshTokenRequest(false).thenApply(v -> this.getContext().getAccessToken());
        }
        return CompletableFuture.completedFuture(accessToken);
    }

    public CompletableFuture<Void> refreshToken() {
        return this.doRefreshTokenRequest(true);
    }

    private CompletableFuture<Void> doRefreshTokenRequest(boolean notifyListeners) {
        return this.doRefreshToken(() -> this.getContext(), ctx -> this.doRefreshTokenRequest(notifyListeners, (ResourceOwnerOAuthContext)ctx));
    }

    private CompletableFuture<Void> doRefreshTokenRequest(boolean notifyListeners, ResourceOwnerOAuthContext defaultUserState) {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("grant_type", "client_credentials");
        if (this.scopes != null) {
            formData.put("scope", this.scopes);
        }
        String authorization = this.handleClientCredentials(formData);
        return ((CompletableFuture)this.invokeTokenUrl(this.tokenUrl, formData, this.customParameters, this.customHeaders, authorization, false, this.encoding).thenAccept(tokenResponse -> ClassUtils.withContextClassLoader((ClassLoader)DefaultClientCredentialsOAuthDancer.class.getClassLoader(), () -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Retrieved access token, refresh token and expires from token url are: %s, %s, %s", new Object[]{tokenResponse.getAccessToken(), tokenResponse.getRefreshToken(), tokenResponse.getExpiresIn()});
            }
            ResourceOwnerOAuthContextUtils.setAccessToken(defaultUserState, tokenResponse.getAccessToken());
            ResourceOwnerOAuthContextUtils.setExpiresIn(defaultUserState, tokenResponse.getExpiresIn());
            for (Map.Entry<String, Object> customResponseParameterEntry : tokenResponse.getCustomResponseParameters().entrySet()) {
                defaultUserState.getTokenResponseParameters().put(customResponseParameterEntry.getKey(), customResponseParameterEntry.getValue());
            }
            this.updateOAuthContextAfterTokenResponse(defaultUserState);
            if (notifyListeners) {
                this.forEachListener(l -> l.onTokenRefreshed(defaultUserState));
            }
        }))).exceptionally(this.tokenUrlExceptionHandler(defaultUserState));
    }

    public void addListener(ClientCredentialsListener listener) {
        this.doAddListener((OAuthStateListener)listener);
    }

    public void removeListener(ClientCredentialsListener listener) {
        this.doRemoveListener((OAuthStateListener)listener);
    }

    public void invalidateContext() {
        this.invalidateContext("default");
    }

    public ResourceOwnerOAuthContext getContext() {
        return this.getContextForResourceOwner("default");
    }

    private void forEachListener(Consumer<ClientCredentialsListener> action) {
        this.onEachListener(listener -> action.accept((ClientCredentialsListener)listener));
    }
}

