/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.oauth;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.apache.commons.io.input.ReaderInputStream;
import org.junit.After;
import org.junit.Before;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpClientFactory;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.HttpServerFactory;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.builder.OAuthAuthorizationCodeDancerBuilder;
import org.mule.runtime.oauth.api.builder.OAuthClientCredentialsDancerBuilder;
import org.mule.runtime.oauth.api.builder.OAuthDancerBuilder;
import org.mule.service.oauth.internal.DefaultOAuthService;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public abstract class AbstractOAuthTestCase
extends AbstractMuleContextTestCase {
    protected OAuthService service;
    protected HttpClientFactory httpClientFactory;
    protected HttpClient httpClient;
    protected HttpServer httpServer;
    protected ExecutorService httpClientCallbackExecutor;
    @Inject
    protected LockFactory lockFactory;

    public AbstractOAuthTestCase() {
        this.setStartContext(true);
    }

    protected boolean doTestClassInjection() {
        return true;
    }

    @Before
    public void setupServices() throws Exception {
        this.httpClientCallbackExecutor = Executors.newSingleThreadExecutor();
        HttpService httpService = (HttpService)Mockito.mock(HttpService.class);
        this.httpClientFactory = (HttpClientFactory)Mockito.mock(HttpClientFactory.class);
        this.httpClient = (HttpClient)Mockito.mock(HttpClient.class);
        Mockito.when((Object)this.httpClientFactory.create((HttpClientConfiguration)ArgumentMatchers.any())).thenReturn((Object)this.httpClient);
        Mockito.when((Object)httpService.getClientFactory()).thenReturn((Object)this.httpClientFactory);
        HttpServerFactory httpServerFactory = (HttpServerFactory)Mockito.mock(HttpServerFactory.class);
        this.httpServer = (HttpServer)Mockito.mock(HttpServer.class);
        Mockito.when((Object)httpServerFactory.create((HttpServerConfiguration)ArgumentMatchers.any())).thenReturn((Object)this.httpServer);
        Mockito.when((Object)httpService.getServerFactory()).thenReturn((Object)httpServerFactory);
        this.service = this.createOAuthService(httpService);
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        InputStreamHttpEntity httpEntity = (InputStreamHttpEntity)Mockito.mock(InputStreamHttpEntity.class);
        Mockito.when((Object)httpEntity.getContent()).thenReturn((Object)new ReaderInputStream((Reader)new StringReader("")));
        Mockito.when((Object)httpResponse.getEntity()).thenReturn((Object)httpEntity);
        Mockito.when((Object)this.httpClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenAnswer(invocation -> {
            CompletableFuture httpResponseFuture = new CompletableFuture();
            this.httpClientCallbackExecutor.execute(() -> {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    httpResponseFuture.completeExceptionally(e);
                }
                httpResponseFuture.complete(httpResponse);
            });
            return httpResponseFuture;
        });
    }

    protected DefaultOAuthService createOAuthService(HttpService httpService) {
        return new DefaultOAuthService(httpService, (SchedulerService)new SimpleUnitTestSupportSchedulerService());
    }

    @After
    public void teardownServices() {
        this.httpClientCallbackExecutor.shutdown();
    }

    protected OAuthClientCredentialsDancerBuilder baseClientCredentialsDancerBuilder() {
        return this.baseClientCredentialsDancerBuilder(new HashMap());
    }

    protected OAuthClientCredentialsDancerBuilder baseClientCredentialsDancerBuilder(Map<String, ?> tokensStore) {
        OAuthClientCredentialsDancerBuilder builder = this.service.clientCredentialsGrantTypeDancerBuilder(this.lockFactory, tokensStore, (MuleExpressionLanguage)Mockito.mock(MuleExpressionLanguage.class));
        builder.clientCredentials("clientId", "clientSecret");
        return builder;
    }

    protected OAuthAuthorizationCodeDancerBuilder baseAuthCodeDancerbuilder() {
        OAuthAuthorizationCodeDancerBuilder builder = this.service.authorizationCodeGrantTypeDancerBuilder(this.lockFactory, new HashMap(), (MuleExpressionLanguage)Mockito.mock(MuleExpressionLanguage.class));
        builder.clientCredentials("clientId", "clientSecret");
        return builder;
    }

    protected <D> D startDancer(OAuthDancerBuilder<D> builder) throws InitialisationException, MuleException {
        Object dancer = builder.build();
        LifecycleUtils.initialiseIfNeeded((Object)dancer);
        LifecycleUtils.startIfNeeded((Object)dancer);
        return (D)dancer;
    }
}

