/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.oauth.internal;

import io.qameta.allure.Feature;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.input.ReaderInputStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.oauth.api.AuthorizationCodeOAuthDancer;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.api.builder.AuthorizationCodeDanceCallbackContext;
import org.mule.runtime.oauth.api.builder.OAuthAuthorizationCodeDancerBuilder;
import org.mule.runtime.oauth.api.builder.OAuthClientCredentialsDancerBuilder;
import org.mule.runtime.oauth.api.exception.TokenUrlResponseException;
import org.mule.runtime.oauth.api.state.DancerState;
import org.mule.runtime.oauth.api.state.DefaultResourceOwnerOAuthContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContextWithRefreshState;
import org.mule.tck.probe.PollingProber;
import org.mule.test.oauth.AbstractOAuthTestCase;

@Feature(value="OAuth Service")
public class DancerConfigTestCase
extends AbstractOAuthTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private final ArgumentCaptor<RequestHandler> requestHandlerCaptor = ArgumentCaptor.forClass(RequestHandler.class);

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.httpServer.addRequestHandler(ArgumentMatchers.anyString(), (RequestHandler)this.requestHandlerCaptor.capture())).thenReturn(Mockito.mock(RequestHandlerManager.class));
        Mockito.when((Object)this.httpServer.addRequestHandler((Collection)ArgumentMatchers.any(), ArgumentMatchers.anyString(), (RequestHandler)this.requestHandlerCaptor.capture())).thenReturn(Mockito.mock(RequestHandlerManager.class));
        Mockito.when((Object)this.httpServer.addRequestHandler((Collection)ArgumentMatchers.any(), (String)ArgumentMatchers.isNull(), (RequestHandler)this.requestHandlerCaptor.capture())).thenReturn(Mockito.mock(RequestHandlerManager.class));
    }

    @Test
    public void clientCredentialsMinimal() throws MuleException {
        OAuthClientCredentialsDancerBuilder builder = this.baseClientCredentialsDancerBuilder();
        builder.tokenUrl("http://host/token");
        ClientCredentialsOAuthDancer minimalDancer = (ClientCredentialsOAuthDancer)this.startDancer(builder);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).start();
        LifecycleUtils.stopIfNeeded((Object)minimalDancer);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).stop();
    }

    @Test
    public void clientCredentialsTokenUrlFailsDuringAppStartup() throws Exception {
        HashMap tokensStore = new HashMap();
        OAuthClientCredentialsDancerBuilder builder = this.baseClientCredentialsDancerBuilder(tokensStore);
        builder.tokenUrl("http://host/token");
        Mockito.reset((Object[])new HttpClient[]{this.httpClient});
        CompletableFuture failedFuture = new CompletableFuture();
        failedFuture.completeExceptionally(new IOException("It failed!"));
        Mockito.when((Object)this.httpClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenReturn(failedFuture);
        ClientCredentialsOAuthDancer minimalDancer = (ClientCredentialsOAuthDancer)this.startDancer(builder);
        this.expected.expectCause(Matchers.instanceOf(TokenUrlResponseException.class));
        minimalDancer.accessToken().get();
        Assert.assertThat((Object)((ResourceOwnerOAuthContextWithRefreshState)tokensStore.get("default")).getDancerState(), (Matcher)Matchers.is((Object)DancerState.NO_TOKEN));
    }

    @Test
    public void accessTokenNotRetrieve() throws Exception {
        OAuthClientCredentialsDancerBuilder builder = this.baseClientCredentialsDancerBuilder();
        builder.tokenUrl("http://host/token");
        Mockito.reset((Object[])new HttpClient[]{this.httpClient});
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        InputStreamHttpEntity httpEntity = (InputStreamHttpEntity)Mockito.mock(InputStreamHttpEntity.class);
        Mockito.when((Object)httpEntity.getContent()).thenReturn((Object)new ReaderInputStream((Reader)new StringReader("")));
        Mockito.when((Object)httpResponse.getEntity()).thenReturn((Object)httpEntity);
        Mockito.when((Object)httpResponse.getStatusCode()).thenReturn((Object)403);
        Mockito.when((Object)this.httpClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(httpResponse));
        ClientCredentialsOAuthDancer minimalDancer = (ClientCredentialsOAuthDancer)this.startDancer(builder);
        this.expected.expectCause(Matchers.instanceOf(TokenUrlResponseException.class));
        minimalDancer.accessToken().get();
    }

    @Test
    public void authorizationCodeMinimal() throws MuleException, MalformedURLException {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        this.minimalAuthCodeConfig(builder);
        Object minimalDancer = this.startDancer(builder);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).start();
        LifecycleUtils.stopIfNeeded(minimalDancer);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).stop();
    }

    private void minimalAuthCodeConfig(OAuthAuthorizationCodeDancerBuilder builder) throws MalformedURLException {
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.localCallback(new URL("http://localhost:8080/localCallback"));
    }

    @Test
    public void clientCredentialsReuseHttpClient() throws MuleException, MalformedURLException {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        this.minimalAuthCodeConfig(builder);
        builder.tokenUrl(this.httpClient, "http://host/token");
        Object minimalDancer = this.startDancer(builder);
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.never())).start();
        LifecycleUtils.stopIfNeeded(minimalDancer);
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.never())).stop();
    }

    @Test
    public void authorizationCodeReuseHttpClient() throws MuleException, MalformedURLException {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        this.minimalAuthCodeConfig(builder);
        builder.tokenUrl(this.httpClient, "http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.localCallback(new URL("http://localhost:8080/localCallback"));
        Object minimalDancer = this.startDancer(builder);
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.never())).start();
        LifecycleUtils.stopIfNeeded(minimalDancer);
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.never())).stop();
    }

    @Test
    public void authorizationCodeReuseHttpServer() throws MuleException, IOException {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        this.minimalAuthCodeConfig(builder);
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.localCallback(this.httpServer, "/localCallback");
        Object minimalDancer = this.startDancer(builder);
        ((HttpServer)Mockito.verify((Object)this.httpServer)).start();
        ((HttpServer)Mockito.verify((Object)this.httpServer)).addRequestHandler((Collection)ArgumentMatchers.eq(Collections.singleton(HttpConstants.Method.GET.name())), (String)ArgumentMatchers.eq((Object)"/localCallback"), (RequestHandler)ArgumentMatchers.any());
        LifecycleUtils.stopIfNeeded(minimalDancer);
        ((HttpServer)Mockito.verify((Object)this.httpServer)).stop();
    }

    @Test
    public void authorizationCodeBeforeCallback() throws MuleException, IOException {
        AtomicBoolean beforeCallbackCalled = new AtomicBoolean(false);
        String resourceOwner = "someOwner";
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        this.minimalAuthCodeConfig(builder);
        builder.beforeDanceCallback(r -> {
            Assert.assertThat((Object)r.getResourceOwnerId(), (Matcher)Matchers.is((Object)resourceOwner));
            Assert.assertThat((Object)r.getAuthorizationUrl(), (Matcher)Matchers.is((Object)"http://host/auth"));
            Assert.assertThat((Object)r.getTokenUrl(), (Matcher)Matchers.is((Object)"http://host/token"));
            Assert.assertThat((Object)r.getClientId(), (Matcher)Matchers.is((Object)"clientId"));
            Assert.assertThat((Object)r.getClientSecret(), (Matcher)Matchers.is((Object)"clientSecret"));
            Assert.assertThat((Object)r.getScopes(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            Assert.assertThat((Object)r.getState(), (Matcher)Matchers.is(Optional.empty()));
            beforeCallbackCalled.set(true);
            return null;
        });
        this.startDancer(builder);
        this.configureRequestHandler(resourceOwner, "");
        Assert.assertThat((Object)beforeCallbackCalled.get(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void authorizationCodeBeforeCallbackWithState() throws MuleException, IOException {
        AtomicBoolean beforeCallbackCalled = new AtomicBoolean(false);
        String originalState = "originalState";
        String resourceOwner = "someOwner";
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        this.minimalAuthCodeConfig(builder);
        builder.beforeDanceCallback(r -> {
            Assert.assertThat(r.getState().get(), (Matcher)Matchers.is((Object)originalState));
            beforeCallbackCalled.set(true);
            return null;
        });
        this.startDancer(builder);
        this.configureRequestHandler(resourceOwner, originalState);
        Assert.assertThat((Object)beforeCallbackCalled.get(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void authorizationCodeBeforeCallbackWithScopes() throws MuleException, IOException {
        AtomicBoolean beforeCallbackCalled = new AtomicBoolean(false);
        String resourceOwner = "someOwner";
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        this.minimalAuthCodeConfig(builder);
        builder.scopes("aScope");
        builder.beforeDanceCallback(r -> {
            Assert.assertThat((Object)r.getScopes(), (Matcher)Matchers.is((Object)"aScope"));
            beforeCallbackCalled.set(true);
            return null;
        });
        this.startDancer(builder);
        this.configureRequestHandler(resourceOwner, "");
        Assert.assertThat((Object)beforeCallbackCalled.get(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void authorizationCodeAfterCallback() throws MuleException, IOException {
        AtomicBoolean afterCallbackCalled = new AtomicBoolean(false);
        String resourceOwner = "someOwner";
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        this.minimalAuthCodeConfig(builder);
        builder.responseAccessTokenExpr("someAccessToken").responseExpiresInExpr("someExpiresIn").responseRefreshTokenExpr("someRefreshToken");
        builder.afterDanceCallback((vars, ctx) -> {
            Assert.assertThat((Object)ctx.getAccessToken(), (Matcher)Matchers.is((Object)"someAccessToken"));
            Assert.assertThat((Object)ctx.getExpiresIn(), (Matcher)Matchers.is((Object)"someExpiresIn"));
            Assert.assertThat((Object)ctx.getRefreshToken(), (Matcher)Matchers.is((Object)"someRefreshToken"));
            Assert.assertThat((Object)ctx.getResourceOwnerId(), (Matcher)Matchers.is((Object)resourceOwner));
            Assert.assertThat((Object)ctx.getState(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            Assert.assertThat((Object)ctx.getTokenResponseParameters(), (Matcher)Matchers.equalTo(Collections.emptyMap()));
            afterCallbackCalled.set(true);
        });
        this.startDancer(builder);
        this.configureRequestHandler(resourceOwner, "");
        PollingProber.probe(() -> afterCallbackCalled.get());
    }

    @Test
    public void authorizationCodeAfterCallbackWithState() throws MuleException, IOException {
        AtomicBoolean afterCallbackCalled = new AtomicBoolean(false);
        String originalState = "originalState";
        String resourceOwner = "someOwner";
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        this.minimalAuthCodeConfig(builder);
        builder.responseAccessTokenExpr("someAccessToken").responseExpiresInExpr("someExpiresIn").responseRefreshTokenExpr("someRefreshToken");
        builder.afterDanceCallback((vars, ctx) -> {
            Assert.assertThat((Object)ctx.getState(), (Matcher)Matchers.is((Object)originalState));
            afterCallbackCalled.set(true);
        });
        this.startDancer(builder);
        this.configureRequestHandler(resourceOwner, originalState);
        PollingProber.probe(() -> afterCallbackCalled.get());
    }

    @Test
    public void authorizationCodeAfterCallbackWithTokenResponseParams() throws MuleException, IOException {
        AtomicBoolean afterCallbackCalled = new AtomicBoolean(false);
        String resourceOwner = "someOwner";
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        this.minimalAuthCodeConfig(builder);
        builder.responseAccessTokenExpr("someAccessToken").responseExpiresInExpr("someExpiresIn").responseRefreshTokenExpr("someRefreshToken");
        builder.customParametersExtractorsExprs(Collections.singletonMap("someKey", "someValue"));
        builder.afterDanceCallback((vars, ctx) -> {
            Assert.assertThat((Object)ctx.getTokenResponseParameters(), (Matcher)Matchers.equalTo(Collections.singletonMap("someKey", "someValue")));
            afterCallbackCalled.set(true);
        });
        this.startDancer(builder);
        this.configureRequestHandler(resourceOwner, "");
        PollingProber.probe(() -> afterCallbackCalled.get());
    }

    @Test
    public void authorizationCodeBeforeAfterCallbackVariables() throws MuleException, IOException {
        AtomicBoolean afterCallbackCalled = new AtomicBoolean(false);
        String resourceOwner = "someOwner";
        AuthorizationCodeDanceCallbackContext callbackContext = paramKey -> Optional.empty();
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        this.minimalAuthCodeConfig(builder);
        builder.beforeDanceCallback(r -> callbackContext);
        builder.afterDanceCallback((callbackCtx, ctx) -> {
            Assert.assertThat((Object)callbackCtx, (Matcher)Matchers.sameInstance((Object)callbackContext));
            afterCallbackCalled.set(true);
        });
        this.startDancer(builder);
        this.configureRequestHandler(resourceOwner, "");
        PollingProber.probe(() -> afterCallbackCalled.get());
    }

    @Test
    public void multipleDancersShareTokensStore() throws MalformedURLException, InitialisationException, MuleException {
        HashMap<String, ResourceOwnerOAuthContextWithRefreshState> tokensStore = new HashMap<String, ResourceOwnerOAuthContextWithRefreshState>();
        MuleExpressionLanguage el = (MuleExpressionLanguage)Mockito.mock(MuleExpressionLanguage.class);
        OAuthAuthorizationCodeDancerBuilder builder1 = this.service.authorizationCodeGrantTypeDancerBuilder(this.lockFactory, tokensStore, el);
        OAuthAuthorizationCodeDancerBuilder builder2 = this.service.authorizationCodeGrantTypeDancerBuilder(this.lockFactory, tokensStore, el);
        builder1.clientCredentials("clientId", "clientSecret");
        builder2.clientCredentials("clientId", "clientSecret");
        this.minimalAuthCodeConfig(builder1);
        this.minimalAuthCodeConfig(builder2);
        builder1.resourceOwnerIdTransformer(roid -> "conn1-" + roid);
        builder2.resourceOwnerIdTransformer(roid -> "conn2-" + roid);
        AuthorizationCodeOAuthDancer dancer1 = (AuthorizationCodeOAuthDancer)this.startDancer(builder1);
        AuthorizationCodeOAuthDancer dancer2 = (AuthorizationCodeOAuthDancer)this.startDancer(builder2);
        ResourceOwnerOAuthContextWithRefreshState contextOwnerConn1 = new ResourceOwnerOAuthContextWithRefreshState("owner");
        ResourceOwnerOAuthContextWithRefreshState contextOwnerConn2 = new ResourceOwnerOAuthContextWithRefreshState("owner");
        tokensStore.put("conn1-owner", contextOwnerConn1);
        tokensStore.put("conn2-owner", contextOwnerConn2);
        Assert.assertThat((Object)dancer1.getContextForResourceOwner("owner"), (Matcher)Matchers.sameInstance((Object)contextOwnerConn1));
        Assert.assertThat((Object)dancer2.getContextForResourceOwner("owner"), (Matcher)Matchers.sameInstance((Object)contextOwnerConn2));
    }

    @Test
    public void multipleDancersShareTokensStoreMigrateContext() throws MalformedURLException, InitialisationException, MuleException {
        HashMap<String, DefaultResourceOwnerOAuthContext> tokensStore = new HashMap<String, DefaultResourceOwnerOAuthContext>();
        MuleExpressionLanguage el = (MuleExpressionLanguage)Mockito.mock(MuleExpressionLanguage.class);
        OAuthAuthorizationCodeDancerBuilder builder1 = this.service.authorizationCodeGrantTypeDancerBuilder(this.lockFactory, tokensStore, el);
        OAuthAuthorizationCodeDancerBuilder builder2 = this.service.authorizationCodeGrantTypeDancerBuilder(this.lockFactory, tokensStore, el);
        builder1.clientCredentials("clientId", "clientSecret");
        builder2.clientCredentials("clientId", "clientSecret");
        this.minimalAuthCodeConfig(builder1);
        this.minimalAuthCodeConfig(builder2);
        builder1.resourceOwnerIdTransformer(roid -> "conn1-" + roid);
        builder2.resourceOwnerIdTransformer(roid -> "conn2-" + roid);
        AuthorizationCodeOAuthDancer dancer1 = (AuthorizationCodeOAuthDancer)this.startDancer(builder1);
        AuthorizationCodeOAuthDancer dancer2 = (AuthorizationCodeOAuthDancer)this.startDancer(builder2);
        DefaultResourceOwnerOAuthContext contextOwnerConn1 = new DefaultResourceOwnerOAuthContext((Lock)new ReentrantLock(), "owner1");
        DefaultResourceOwnerOAuthContext contextOwnerConn2 = new DefaultResourceOwnerOAuthContext((Lock)new ReentrantLock(), "owner2");
        tokensStore.put("conn1-owner", contextOwnerConn1);
        tokensStore.put("conn2-owner", contextOwnerConn2);
        ResourceOwnerOAuthContext ctx1 = dancer1.getContextForResourceOwner("owner1");
        Assert.assertThat((Object)ctx1, (Matcher)Matchers.instanceOf(ResourceOwnerOAuthContextWithRefreshState.class));
        Assert.assertThat((Object)ctx1.getResourceOwnerId(), (Matcher)Matchers.is((Object)"owner1"));
        ResourceOwnerOAuthContext ctx2 = dancer2.getContextForResourceOwner("owner2");
        Assert.assertThat((Object)ctx2, (Matcher)Matchers.instanceOf(ResourceOwnerOAuthContextWithRefreshState.class));
        Assert.assertThat((Object)ctx2.getResourceOwnerId(), (Matcher)Matchers.is((Object)"owner2"));
    }

    @Test
    public void dancerDoesNotReturnNullValuesWhenGettingAndRemovingContextsConcurrently() throws MalformedURLException, MuleException, InterruptedException {
        int i;
        HashMap<String, DefaultResourceOwnerOAuthContext> tokensStore = new HashMap<String, DefaultResourceOwnerOAuthContext>();
        MuleExpressionLanguage el = (MuleExpressionLanguage)Mockito.mock(MuleExpressionLanguage.class);
        OAuthAuthorizationCodeDancerBuilder builder = this.service.authorizationCodeGrantTypeDancerBuilder(this.lockFactory, tokensStore, el);
        builder.clientCredentials("clientId", "clientSecret");
        this.minimalAuthCodeConfig(builder);
        AuthorizationCodeOAuthDancer dancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        DefaultResourceOwnerOAuthContext contextOwner = new DefaultResourceOwnerOAuthContext((Lock)new ReentrantLock(), "owner");
        tokensStore.put("owner", contextOwner);
        int removerThreadsCount = 150;
        int getterThreadsCount = 170;
        CountDownLatch threadsStartedLatch = new CountDownLatch(removerThreadsCount + getterThreadsCount);
        Semaphore startProcessingSemaphore = new Semaphore(0);
        ArrayList<Thread> runningThreads = new ArrayList<Thread>();
        AtomicInteger numberOfNulls = new AtomicInteger(0);
        for (i = 0; i < removerThreadsCount; ++i) {
            Thread removerThread = new Thread(() -> {
                try {
                    threadsStartedLatch.countDown();
                    startProcessingSemaphore.acquire();
                    dancer.invalidateContext("owner");
                }
                catch (InterruptedException e) {
                    Assert.fail((String)"Remover thread was interrupted");
                }
                catch (NullPointerException npe) {
                    numberOfNulls.incrementAndGet();
                }
            });
            removerThread.start();
            runningThreads.add(removerThread);
        }
        for (i = 0; i < getterThreadsCount; ++i) {
            Thread getterThread = new Thread(() -> {
                try {
                    threadsStartedLatch.countDown();
                    startProcessingSemaphore.acquire();
                    ResourceOwnerOAuthContext context = dancer.getContextForResourceOwner("owner");
                    if (context == null) {
                        numberOfNulls.incrementAndGet();
                    }
                }
                catch (InterruptedException e) {
                    Assert.fail((String)"Getter thread was interrupted");
                }
                catch (NullPointerException npe) {
                    numberOfNulls.incrementAndGet();
                }
            });
            getterThread.start();
            runningThreads.add(getterThread);
        }
        threadsStartedLatch.await();
        startProcessingSemaphore.release(removerThreadsCount + getterThreadsCount);
        for (Thread thread : runningThreads) {
            thread.join();
        }
        Assert.assertThat((Object)numberOfNulls.get(), (Matcher)Matchers.is((Object)0));
    }

    private void configureRequestHandler(String resourceOwner, String state) {
        HttpRequest authorizationRequest = (HttpRequest)Mockito.mock(HttpRequest.class);
        MultiMap authReqQueryParams = new MultiMap();
        authReqQueryParams.put((Object)"state", (Object)(state + ":resourceOwnerId=" + resourceOwner));
        authReqQueryParams.put((Object)"code", (Object)"");
        Mockito.when((Object)authorizationRequest.getQueryParams()).thenReturn((Object)authReqQueryParams);
        HttpRequestContext authorizationRequestContext = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        Mockito.when((Object)authorizationRequestContext.getRequest()).thenReturn((Object)authorizationRequest);
        ((RequestHandler)this.requestHandlerCaptor.getAllValues().get(0)).handleRequest(authorizationRequestContext, (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class));
    }
}

