/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.oauth2.internal.authorizationcode;

import io.qameta.allure.Feature;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.service.oauth.internal.state.StateDecoder;
import org.mule.service.oauth.internal.state.StateEncoder;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="OAuth Service")
public class StateEncoderTestCase
extends AbstractMuleTestCase {
    public static final String ORIGINAL_STATE_VALUE = "original-state-value";
    public static final String TEST_RESOURCE_OWNER_ID = "test-oauth-id";
    public static final String TEST_ON_COMPLETE_URL = "http://host:12/path";

    @Test(expected=IllegalArgumentException.class)
    public void encodeNullOAuthStateId() {
        new StateEncoder(ORIGINAL_STATE_VALUE).encodeResourceOwnerIdInState(null);
    }

    @Test
    public void encodeAndDecodeWithState() {
        StateEncoder stateEncoder = new StateEncoder(ORIGINAL_STATE_VALUE);
        stateEncoder.encodeResourceOwnerIdInState(TEST_RESOURCE_OWNER_ID);
        String encodedState = stateEncoder.getEncodedState();
        StateDecoder stateDecoder = new StateDecoder(encodedState);
        Assert.assertThat((Object)stateDecoder.decodeResourceOwnerId(), (Matcher)Is.is((Object)TEST_RESOURCE_OWNER_ID));
        Assert.assertThat((Object)stateDecoder.decodeOriginalState(), (Matcher)Is.is((Object)ORIGINAL_STATE_VALUE));
    }

    @Test
    public void encodeAndDecodeWithNullState() {
        StateEncoder stateEncoder = new StateEncoder(null);
        stateEncoder.encodeResourceOwnerIdInState(TEST_RESOURCE_OWNER_ID);
        String encodedState = stateEncoder.getEncodedState();
        StateDecoder stateDecoder = new StateDecoder(encodedState);
        Assert.assertThat((Object)stateDecoder.decodeResourceOwnerId(), (Matcher)Is.is((Object)TEST_RESOURCE_OWNER_ID));
        Assert.assertThat((Object)stateDecoder.decodeOriginalState(), (Matcher)IsNull.nullValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void doNotAllowNewParameterAfterOnCompleteRedirectTo() {
        StateEncoder stateEncoder = new StateEncoder(null);
        stateEncoder.encodeOnCompleteRedirectToInState(TEST_ON_COMPLETE_URL);
        stateEncoder.encodeResourceOwnerIdInState(TEST_RESOURCE_OWNER_ID);
    }

    @Test
    public void encodeAndDecodeOnCompleteRedirectToParameter() {
        StateEncoder stateEncoder = new StateEncoder(null);
        stateEncoder.encodeOnCompleteRedirectToInState(TEST_ON_COMPLETE_URL);
        String encodedState = stateEncoder.getEncodedState();
        StateDecoder stateDecoder = new StateDecoder(encodedState);
        Assert.assertThat((Object)stateDecoder.decodeOnCompleteRedirectTo(), (Matcher)Is.is((Object)TEST_ON_COMPLETE_URL));
        Assert.assertThat((Object)stateDecoder.decodeOriginalState(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void encodeAndDecodeResourceOwnerAndOnCompleteRedirectToParameter() {
        StateEncoder stateEncoder = new StateEncoder(ORIGINAL_STATE_VALUE);
        stateEncoder.encodeResourceOwnerIdInState(TEST_RESOURCE_OWNER_ID);
        stateEncoder.encodeOnCompleteRedirectToInState(TEST_ON_COMPLETE_URL);
        String encodedState = stateEncoder.getEncodedState();
        StateDecoder stateDecoder = new StateDecoder(encodedState);
        Assert.assertThat((Object)stateDecoder.decodeOnCompleteRedirectTo(), (Matcher)Is.is((Object)TEST_ON_COMPLETE_URL));
        Assert.assertThat((Object)stateDecoder.decodeResourceOwnerId(), (Matcher)Is.is((Object)TEST_RESOURCE_OWNER_ID));
        Assert.assertThat((Object)stateDecoder.decodeOriginalState(), (Matcher)Is.is((Object)ORIGINAL_STATE_VALUE));
    }
}

