/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.oauth.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;
import org.mule.runtime.oauth.api.AuthorizationCodeOAuthDancer;
import org.mule.runtime.oauth.api.AuthorizationCodeRequest;
import org.mule.runtime.oauth.api.builder.AuthorizationCodeDanceCallbackContext;
import org.mule.runtime.oauth.api.builder.ClientCredentialsLocation;
import org.mule.runtime.oauth.api.exception.RequestAuthenticationException;
import org.mule.runtime.oauth.api.exception.TokenNotFoundException;
import org.mule.runtime.oauth.api.exception.TokenUrlResponseException;
import org.mule.runtime.oauth.api.listener.AuthorizationCodeListener;
import org.mule.runtime.oauth.api.listener.OAuthStateListener;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContextWithRefreshState;
import org.mule.service.oauth.internal.AbstractOAuthDancer;
import org.mule.service.oauth.internal.authorizationcode.AuthorizationRequestUrlBuilder;
import org.mule.service.oauth.internal.authorizationcode.DefaultAuthorizationCodeRequest;
import org.mule.service.oauth.internal.state.StateDecoder;
import org.mule.service.oauth.internal.state.StateEncoder;
import org.mule.service.oauth.internal.state.TokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizationCodeOAuthDancer
extends AbstractOAuthDancer
implements AuthorizationCodeOAuthDancer,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthorizationCodeOAuthDancer.class);
    private final Optional<HttpServer> httpServer;
    private final String localCallbackUrlPath;
    private final String localAuthorizationUrlPath;
    private final String localAuthorizationUrlResourceOwnerId;
    private final String externalCallbackUrl;
    private final String state;
    private final String authorizationUrl;
    private final Supplier<Map<String, String>> customParameters;
    private final Supplier<Map<String, String>> customHeaders;
    private final Function<AuthorizationCodeRequest, AuthorizationCodeDanceCallbackContext> beforeDanceCallback;
    private final BiConsumer<AuthorizationCodeDanceCallbackContext, ResourceOwnerOAuthContext> afterDanceCallback;
    private RequestHandlerManager redirectUrlHandlerManager;
    private RequestHandlerManager localAuthorizationUrlHandlerManager;

    public DefaultAuthorizationCodeOAuthDancer(Optional<HttpServer> httpServer, String name, String clientId, String clientSecret, String tokenUrl, String scopes, ClientCredentialsLocation clientCredentialsLocation, String externalCallbackUrl, Charset encoding, String localCallbackUrlPath, String localAuthorizationUrlPath, String localAuthorizationUrlResourceOwnerId, String state, String authorizationUrl, String responseAccessTokenExpr, String responseRefreshTokenExpr, String responseExpiresInExpr, Supplier<Map<String, String>> customParameters, Supplier<Map<String, String>> customHeaders, Map<String, String> customParametersExtractorsExprs, Function<String, String> resourceOwnerIdTransformer, SchedulerService schedulerService, LockFactory lockProvider, Map<String, ResourceOwnerOAuthContext> tokensStore, HttpClient httpClient, MuleExpressionLanguage expressionEvaluator, Function<AuthorizationCodeRequest, AuthorizationCodeDanceCallbackContext> beforeDanceCallback, BiConsumer<AuthorizationCodeDanceCallbackContext, ResourceOwnerOAuthContext> afterDanceCallback, List<AuthorizationCodeListener> listeners) {
        super(name, clientId, clientSecret, tokenUrl, encoding, scopes, clientCredentialsLocation, responseAccessTokenExpr, responseRefreshTokenExpr, responseExpiresInExpr, customParametersExtractorsExprs, resourceOwnerIdTransformer, schedulerService, lockProvider, tokensStore, httpClient, expressionEvaluator, listeners);
        this.httpServer = httpServer;
        this.localCallbackUrlPath = localCallbackUrlPath;
        this.localAuthorizationUrlPath = localAuthorizationUrlPath;
        this.localAuthorizationUrlResourceOwnerId = localAuthorizationUrlResourceOwnerId;
        this.externalCallbackUrl = externalCallbackUrl;
        this.state = state;
        this.authorizationUrl = authorizationUrl;
        this.customParameters = customParameters;
        this.customHeaders = customHeaders;
        this.beforeDanceCallback = beforeDanceCallback;
        this.afterDanceCallback = afterDanceCallback;
    }

    public void initialise() throws InitialisationException {
        this.httpServer.ifPresent(s -> {
            this.redirectUrlHandlerManager = DefaultAuthorizationCodeOAuthDancer.addRequestHandler(s, HttpConstants.Method.GET, this.localCallbackUrlPath, this.createRedirectUrlListener());
            this.localAuthorizationUrlHandlerManager = DefaultAuthorizationCodeOAuthDancer.addRequestHandler(s, HttpConstants.Method.GET, this.localAuthorizationUrlPath, this.createLocalAuthorizationUrlListener());
        });
    }

    public void addListener(AuthorizationCodeListener listener) {
        this.doAddListener((OAuthStateListener)listener);
    }

    public void removeListener(AuthorizationCodeListener listener) {
        this.doRemoveListener((OAuthStateListener)listener);
    }

    private static RequestHandlerManager addRequestHandler(HttpServer server, HttpConstants.Method method, String path, final RequestHandler callbackHandler) {
        final ClassLoader appRegionClassLoader = Thread.currentThread().getContextClassLoader();
        RequestHandler requestHandler = new RequestHandler(){

            public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
                ClassUtils.withContextClassLoader((ClassLoader)DefaultAuthorizationCodeOAuthDancer.class.getClassLoader(), () -> {
                    try {
                        callbackHandler.handleRequest(requestContext, responseCallback);
                    }
                    catch (Exception e) {
                        LOGGER.error("Uncaught Exception on OAuth listener", (Throwable)e);
                        DefaultAuthorizationCodeOAuthDancer.sendErrorResponse(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), responseCallback);
                    }
                });
            }

            public ClassLoader getContextClassLoader() {
                return appRegionClassLoader;
            }
        };
        return server.addRequestHandler(Collections.singleton(method.name()), path, requestHandler);
    }

    private static void sendErrorResponse(final HttpConstants.HttpStatus status, String message, HttpResponseReadyCallback responseCallback) {
        responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(status.getStatusCode())).reasonPhrase(status.getReasonPhrase()).entity((HttpEntity)(message != null ? new ByteArrayHttpEntity(message.getBytes()) : new EmptyHttpEntity()))).addHeader("Content-Length", message != null ? String.valueOf(message.length()) : "0")).build(), new ResponseStatusCallback(){

            public void responseSendFailure(Throwable exception) {
                LOGGER.warn("Error while sending {} response {}", (Object)status.getStatusCode(), (Object)exception.getMessage());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Exception thrown", exception);
                }
            }

            public void responseSendSuccessfully() {
            }
        });
    }

    private RequestHandler createRedirectUrlListener() {
        final ClassLoader appRegionClassLoader = Thread.currentThread().getContextClassLoader();
        return new RequestHandler(){

            public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
                HttpRequest request = requestContext.getRequest();
                MultiMap queryParams = request.getQueryParams();
                String state = (String)queryParams.get((Object)"state");
                StateDecoder stateDecoder = new StateDecoder(state);
                String authorizationCode = (String)queryParams.get((Object)"code");
                String resourceOwnerId = stateDecoder.decodeResourceOwnerId();
                if (authorizationCode == null) {
                    LOGGER.info("HTTP Request to redirect URL done by the OAuth provider does not contains a code query parameter. Code query parameter is required to get the access token.");
                    LOGGER.error("Could not extract authorization code from OAuth provider HTTP request done to the redirect URL");
                    DefaultAuthorizationCodeOAuthDancer.this.sendResponse(stateDecoder, responseCallback, HttpConstants.HttpStatus.BAD_REQUEST, "Failure retrieving access token.\n OAuth Server uri from callback: " + request.getUri(), 100);
                    return;
                }
                AuthorizationCodeDanceCallbackContext beforeCallbackContext = (AuthorizationCodeDanceCallbackContext)DefaultAuthorizationCodeOAuthDancer.this.beforeDanceCallback.apply(new DefaultAuthorizationCodeRequest(resourceOwnerId, DefaultAuthorizationCodeOAuthDancer.this.authorizationUrl, DefaultAuthorizationCodeOAuthDancer.this.tokenUrl, DefaultAuthorizationCodeOAuthDancer.this.clientId, DefaultAuthorizationCodeOAuthDancer.this.clientSecret, DefaultAuthorizationCodeOAuthDancer.this.scopes, stateDecoder.decodeOriginalState()));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Redirect url request state: " + state);
                    LOGGER.debug("Redirect url request code: " + authorizationCode);
                }
                HashMap<String, String> formData = new HashMap<String, String>();
                formData.put("code", authorizationCode);
                String authorization = DefaultAuthorizationCodeOAuthDancer.this.handleClientCredentials(formData);
                formData.put("grant_type", "authorization_code");
                formData.put("redirect_uri", DefaultAuthorizationCodeOAuthDancer.this.externalCallbackUrl);
                ((CompletableFuture)DefaultAuthorizationCodeOAuthDancer.this.invokeTokenUrl(DefaultAuthorizationCodeOAuthDancer.this.tokenUrl, formData, (MultiMap<String, String>)MultiMap.emptyMultiMap(), (MultiMap<String, String>)MultiMap.emptyMultiMap(), authorization, true, DefaultAuthorizationCodeOAuthDancer.this.encoding).exceptionally(e -> {
                    ClassUtils.withContextClassLoader((ClassLoader)DefaultAuthorizationCodeOAuthDancer.class.getClassLoader(), () -> {
                        if (e.getCause() instanceof TokenUrlResponseException) {
                            LOGGER.error(e.getMessage());
                            DefaultAuthorizationCodeOAuthDancer.this.sendResponse(stateDecoder, responseCallback, HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR, String.format("Failure calling token url %s. Exception message is %s", DefaultAuthorizationCodeOAuthDancer.this.tokenUrl, e.getMessage()), 200);
                        } else if (e.getCause() instanceof TokenNotFoundException) {
                            LOGGER.error(e.getMessage());
                            DefaultAuthorizationCodeOAuthDancer.this.sendResponse(stateDecoder, responseCallback, HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR, "Failed getting access token or refresh token from token URL response. See logs for details.", 201);
                        } else {
                            LOGGER.error("Uncaught Exception on OAuth listener", e);
                            DefaultAuthorizationCodeOAuthDancer.sendErrorResponse(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), responseCallback);
                        }
                    });
                    return null;
                })).thenAccept(tokenResponse -> ClassUtils.withContextClassLoader((ClassLoader)DefaultAuthorizationCodeOAuthDancer.class.getClassLoader(), () -> {
                    if (tokenResponse == null) {
                        return;
                    }
                    ResourceOwnerOAuthContextWithRefreshState resourceOwnerOAuthContext = (ResourceOwnerOAuthContextWithRefreshState)DefaultAuthorizationCodeOAuthDancer.this.getContextForResourceOwner(resourceOwnerId == null ? "default" : resourceOwnerId);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Update OAuth Context for resourceOwnerId %s", (Object)resourceOwnerOAuthContext.getResourceOwnerId());
                        LOGGER.debug("Retrieved access token, refresh token and expires from token url are: %s, %s, %s", new Object[]{tokenResponse.getAccessToken(), tokenResponse.getRefreshToken(), tokenResponse.getExpiresIn()});
                    }
                    DefaultAuthorizationCodeOAuthDancer.this.updateResourceOwnerState(resourceOwnerOAuthContext, stateDecoder.decodeOriginalState(), tokenResponse);
                    DefaultAuthorizationCodeOAuthDancer.this.updateResourceOwnerOAuthContext((ResourceOwnerOAuthContext)resourceOwnerOAuthContext);
                    DefaultAuthorizationCodeOAuthDancer.this.forEachListener(l -> l.onAuthorizationCompleted((ResourceOwnerOAuthContext)resourceOwnerOAuthContext));
                    DefaultAuthorizationCodeOAuthDancer.this.afterDanceCallback.accept(beforeCallbackContext, resourceOwnerOAuthContext);
                    DefaultAuthorizationCodeOAuthDancer.this.sendResponse(stateDecoder, responseCallback, HttpConstants.HttpStatus.OK, "Successfully retrieved access token", 0);
                }));
            }

            public ClassLoader getContextClassLoader() {
                return appRegionClassLoader;
            }
        };
    }

    private void sendResponse(StateDecoder stateDecoder, HttpResponseReadyCallback responseCallback, HttpConstants.HttpStatus statusEmptyState, String message, int authorizationStatus) {
        String onCompleteRedirectToValue = stateDecoder.decodeOnCompleteRedirectTo();
        if (!DefaultAuthorizationCodeOAuthDancer.isEmpty(onCompleteRedirectToValue)) {
            this.sendResponse(responseCallback, HttpConstants.HttpStatus.MOVED_TEMPORARILY, message, HttpEncoderDecoderUtils.appendQueryParam((String)onCompleteRedirectToValue, (String)"authorizationStatus", (String)String.valueOf(authorizationStatus)));
        } else {
            DefaultAuthorizationCodeOAuthDancer.sendResponse(responseCallback, statusEmptyState, message);
        }
    }

    private void sendResponse(HttpResponseReadyCallback responseCallback, final HttpConstants.HttpStatus status, String message, String locationHeader) {
        HttpResponseBuilder httpResponseBuilder = HttpResponse.builder();
        httpResponseBuilder.statusCode(Integer.valueOf(status.getStatusCode()));
        httpResponseBuilder.reasonPhrase(status.getReasonPhrase());
        httpResponseBuilder.entity((HttpEntity)new ByteArrayHttpEntity(message.getBytes()));
        httpResponseBuilder.addHeader("Content-Length", String.valueOf(message.length()));
        httpResponseBuilder.addHeader("Location", locationHeader);
        httpResponseBuilder.headers(new MultiMap(this.customHeaders.get()));
        responseCallback.responseReady(httpResponseBuilder.build(), new ResponseStatusCallback(){

            public void responseSendFailure(Throwable exception) {
                LOGGER.warn("Error while sending {} response {}", (Object)status.getStatusCode(), (Object)exception.getMessage());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Exception thrown", exception);
                }
            }

            public void responseSendSuccessfully() {
            }
        });
    }

    private static void sendResponse(HttpResponseReadyCallback responseCallback, final HttpConstants.HttpStatus status, String message) {
        HttpResponseBuilder httpResponseBuilder = HttpResponse.builder();
        httpResponseBuilder.statusCode(Integer.valueOf(status.getStatusCode()));
        httpResponseBuilder.reasonPhrase(status.getReasonPhrase());
        httpResponseBuilder.entity((HttpEntity)new ByteArrayHttpEntity(message.getBytes()));
        httpResponseBuilder.addHeader("Content-Length", String.valueOf(message.length()));
        responseCallback.responseReady(httpResponseBuilder.build(), new ResponseStatusCallback(){

            public void responseSendFailure(Throwable exception) {
                LOGGER.warn("Error while sending {} response {}", (Object)status.getStatusCode(), (Object)exception.getMessage());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Exception thrown", exception);
                }
            }

            public void responseSendSuccessfully() {
            }
        });
    }

    private static boolean isEmpty(String value) {
        return value == null || StringUtils.isEmpty((String)value) || "null".equals(value);
    }

    private RequestHandler createLocalAuthorizationUrlListener() {
        final ClassLoader appRegionClassLoader = Thread.currentThread().getContextClassLoader();
        return new RequestHandler(){

            public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
                DefaultAuthorizationCodeOAuthDancer.this.handleLocalAuthorizationRequest(requestContext.getRequest(), responseCallback);
            }

            public ClassLoader getContextClassLoader() {
                return appRegionClassLoader;
            }
        };
    }

    public void handleLocalAuthorizationRequest(HttpRequest request, HttpResponseReadyCallback responseCallback) {
        String onCompleteRedirectToValue;
        String body = this.readBody(request);
        MultiMap<String, String> headers = this.readHeaders(request);
        MediaType mediaType = this.getMediaType(request);
        MultiMap queryParams = request.getQueryParams();
        String originalState = (String)this.resolveExpression(this.state, body, headers, (MultiMap<String, String>)queryParams, mediaType);
        StateEncoder stateEncoder = new StateEncoder(originalState);
        String resourceOwnerId = (String)this.resolveExpression(this.localAuthorizationUrlResourceOwnerId, body, headers, (MultiMap<String, String>)queryParams, mediaType);
        if (resourceOwnerId != null) {
            stateEncoder.encodeResourceOwnerIdInState(resourceOwnerId);
        }
        if ((onCompleteRedirectToValue = (String)queryParams.get((Object)"onCompleteRedirectTo")) != null) {
            stateEncoder.encodeOnCompleteRedirectToInState(onCompleteRedirectToValue);
        }
        String authorizationUrlWithParams = new AuthorizationRequestUrlBuilder().setAuthorizationUrl(this.authorizationUrl).setClientId(this.clientId).setClientSecret(this.clientSecret).setCustomParameters(this.customParameters.get()).setRedirectUrl(this.externalCallbackUrl).setState(stateEncoder.getEncodedState()).setScope(this.scopes).setEncoding(this.encoding).buildUrl();
        this.sendResponse(responseCallback, HttpConstants.HttpStatus.MOVED_TEMPORARILY, body, authorizationUrlWithParams);
    }

    private String readBody(HttpRequest request) {
        return IOUtils.toString((InputStream)request.getEntity().getContent());
    }

    private MultiMap<String, String> readHeaders(HttpRequest request) {
        return request.getHeaders();
    }

    private MediaType getMediaType(HttpRequest request) {
        String contentType = request.getHeaderValue("Content-Type");
        return contentType != null ? MediaType.parse((String)contentType) : MediaType.ANY;
    }

    @Override
    public void start() throws MuleException {
        super.start();
        if (this.httpServer.isPresent()) {
            try {
                this.httpServer.get().start();
            }
            catch (IOException e) {
                throw new DefaultMuleException((Throwable)e);
            }
            this.redirectUrlHandlerManager.start();
            this.localAuthorizationUrlHandlerManager.start();
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.httpServer.isPresent()) {
            this.redirectUrlHandlerManager.stop();
            this.localAuthorizationUrlHandlerManager.stop();
            this.httpServer.get().stop();
        }
        super.stop();
    }

    public void dispose() {
        if (this.httpServer.isPresent()) {
            this.redirectUrlHandlerManager.dispose();
            this.localAuthorizationUrlHandlerManager.dispose();
            this.httpServer.get().dispose();
        }
    }

    public CompletableFuture<String> accessToken(String resourceOwner) throws RequestAuthenticationException {
        String accessToken = this.getContextForResourceOwner(resourceOwner).getAccessToken();
        if (accessToken == null) {
            throw new RequestAuthenticationException(I18nMessageFactory.createStaticMessage((String)String.format("No access token found. Verify that you have authenticated before trying to execute an operation to the API.", new Object[0])));
        }
        return CompletableFuture.completedFuture(accessToken);
    }

    public CompletableFuture<Void> refreshToken(String resourceOwner) {
        return this.refreshToken(resourceOwner, false);
    }

    public CompletableFuture<Void> refreshToken(String resourceOwner, boolean useQueryParameters) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing refresh token for user " + resourceOwner);
        }
        return this.doRefreshToken(() -> this.getContextForResourceOwner(resourceOwner), ctx -> this.doRefreshTokenRequest(useQueryParameters, (ResourceOwnerOAuthContextWithRefreshState)ctx));
    }

    protected CompletableFuture<Void> doRefreshTokenRequest(boolean useQueryParameters, ResourceOwnerOAuthContextWithRefreshState resourceOwnerOAuthContext) {
        MultiMap formData;
        MultiMap queryParams;
        String userRefreshToken = resourceOwnerOAuthContext.getRefreshToken();
        if (userRefreshToken == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The user with user id %s has no refresh token in his OAuth state so we can't execute the refresh token call", (Object[])new Object[]{resourceOwnerOAuthContext.getResourceOwnerId()}));
        }
        MultiMap requestParameters = new MultiMap();
        requestParameters.put((Object)"refresh_token", (Object)userRefreshToken);
        String authorization = this.handleClientCredentials((Map<String, String>)requestParameters);
        requestParameters.put((Object)"grant_type", (Object)"refresh_token");
        requestParameters.put((Object)"redirect_uri", (Object)this.externalCallbackUrl);
        if (useQueryParameters) {
            queryParams = requestParameters;
            formData = Collections.emptyMap();
        } else {
            queryParams = MultiMap.emptyMultiMap();
            formData = requestParameters;
        }
        return ((CompletableFuture)this.invokeTokenUrl(this.tokenUrl, (Map<String, String>)formData, (MultiMap<String, String>)queryParams, (MultiMap<String, String>)MultiMap.emptyMultiMap(), authorization, true, this.encoding).thenAccept(tokenResponse -> ClassUtils.withContextClassLoader((ClassLoader)DefaultAuthorizationCodeOAuthDancer.class.getClassLoader(), () -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Update OAuth Context for resourceOwnerId %s", (Object)resourceOwnerOAuthContext.getResourceOwnerId());
            }
            this.updateResourceOwnerState(resourceOwnerOAuthContext, null, (TokenResponse)tokenResponse);
            this.updateOAuthContextAfterTokenResponse((ResourceOwnerOAuthContext)resourceOwnerOAuthContext);
            this.forEachListener(l -> l.onTokenRefreshed((ResourceOwnerOAuthContext)resourceOwnerOAuthContext));
        }))).exceptionally(this.tokenUrlExceptionHandler((ResourceOwnerOAuthContext)resourceOwnerOAuthContext));
    }

    private void updateResourceOwnerState(ResourceOwnerOAuthContextWithRefreshState resourceOwnerOAuthContext, String newState, TokenResponse tokenResponse) {
        resourceOwnerOAuthContext.setAccessToken(tokenResponse.getAccessToken());
        if (tokenResponse.getRefreshToken() != null) {
            resourceOwnerOAuthContext.setRefreshToken(tokenResponse.getRefreshToken());
        }
        resourceOwnerOAuthContext.setExpiresIn(tokenResponse.getExpiresIn());
        if (newState != null) {
            resourceOwnerOAuthContext.setState(newState);
        }
        Map<String, Object> customResponseParameters = tokenResponse.getCustomResponseParameters();
        for (String paramName : customResponseParameters.keySet()) {
            Object paramValue = customResponseParameters.get(paramName);
            if (paramValue == null) continue;
            resourceOwnerOAuthContext.getTokenResponseParameters().put(paramName, paramValue);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("New OAuth State for resourceOwnerId %s is: accessToken(%s), refreshToken(%s), expiresIn(%s), state(%s)", new Object[]{resourceOwnerOAuthContext.getResourceOwnerId(), resourceOwnerOAuthContext.getAccessToken(), StringUtils.isBlank((String)resourceOwnerOAuthContext.getRefreshToken()) ? "Not issued" : resourceOwnerOAuthContext.getRefreshToken(), resourceOwnerOAuthContext.getExpiresIn(), resourceOwnerOAuthContext.getState()});
        }
    }

    private void forEachListener(Consumer<AuthorizationCodeListener> action) {
        this.onEachListener(l -> action.accept((AuthorizationCodeListener)l));
    }
}

