/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.oauth.internal;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.oauth.client.internal.builder.DefaultOAuthAuthorizationCodeDancerBuilder;
import org.mule.oauth.client.internal.builder.DefaultOAuthClientCredentialsDancerBuilder;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.builder.OAuthAuthorizationCodeDancerBuilder;
import org.mule.runtime.oauth.api.builder.OAuthClientCredentialsDancerBuilder;
import org.mule.service.oauth.internal.DefaultOAuthService;

@Feature(value="OAuth Service")
@Story(value="OAuth Client")
public class DefaultOAuthServiceTestCase {
    private OAuthService oAuthService;

    @Before
    public void setup() {
        this.oAuthService = new DefaultOAuthService((HttpService)Mockito.mock(HttpService.class), (SchedulerService)Mockito.mock(SchedulerService.class));
    }

    @Test
    public void authorizationCodeGrantTypeDancerBuilderShouldCreateADefaultOAuthAuthorizationCodeDancerBuilder() {
        OAuthAuthorizationCodeDancerBuilder dancerBuilder = this.oAuthService.authorizationCodeGrantTypeDancerBuilder((LockFactory)Mockito.mock(LockFactory.class), new HashMap(), (MuleExpressionLanguage)Mockito.mock(MuleExpressionLanguage.class));
        MatcherAssert.assertThat((Object)dancerBuilder, (Matcher)Matchers.instanceOf(DefaultOAuthAuthorizationCodeDancerBuilder.class));
    }

    @Test
    public void authorizationCodeGrantTypeDancerBuilderShouldCreateADefaultClientCredentialsOAuthDancer() {
        OAuthClientCredentialsDancerBuilder dancerBuilder = this.oAuthService.clientCredentialsGrantTypeDancerBuilder((LockFactory)Mockito.mock(LockFactory.class), new HashMap(), (MuleExpressionLanguage)Mockito.mock(MuleExpressionLanguage.class));
        MatcherAssert.assertThat((Object)dancerBuilder, (Matcher)Matchers.instanceOf(DefaultOAuthClientCredentialsDancerBuilder.class));
    }
}

