/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.oauth.internal;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.oauth.client.api.AuthorizationCodeOAuthDancer;
import org.mule.oauth.client.api.ClientCredentialsOAuthDancer;
import org.mule.oauth.client.api.builder.ClientCredentialsLocation;
import org.mule.oauth.client.api.builder.OAuthAuthorizationCodeDancerBuilder;
import org.mule.oauth.client.api.builder.OAuthClientCredentialsDancerBuilder;
import org.mule.oauth.client.api.builder.OAuthDancerBuilder;
import org.mule.oauth.client.api.listener.AuthorizationCodeListener;
import org.mule.oauth.client.api.listener.ClientCredentialsListener;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.test.oauth.internal.DancerConfigTestCase;
import org.mule.runtime.test.oauth.state.CustomResourceOwnerOAuthContext;
import org.mule.service.oauth.internal.builder.Compatibility1xOAuthAuthorizationCodeDancerBuilder;
import org.mule.service.oauth.internal.builder.Compatibility1xOAuthClientCredentialsDancerBuilder;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Feature(value="OAuth Service")
@Story(value="OAuth Client")
public class Compatibility1xDancerConfigTestCase
extends DancerConfigTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(Compatibility1xDancerConfigTestCase.class);

    @Test
    public void clientCredentialsDancerComplexBuilder() throws MuleException, ExecutionException, InterruptedException {
        ClientCredentialsListener listenerFromBuilder = (ClientCredentialsListener)Mockito.mock(ClientCredentialsListener.class);
        ClientCredentialsListener legacyListenerFromBuilder = (ClientCredentialsListener)Mockito.mock(org.mule.runtime.oauth.api.listener.ClientCredentialsListener.class);
        ClientCredentialsListener listenerFromDancer = (ClientCredentialsListener)Mockito.mock(ClientCredentialsListener.class);
        OAuthDancerBuilder builder = ((Compatibility1xOAuthClientCredentialsDancerBuilder)this.baseClientCredentialsDancerBuilder()).addListener((org.mule.runtime.oauth.api.listener.ClientCredentialsListener)legacyListenerFromBuilder).addListener(listenerFromBuilder).customParameters(Collections.singletonMap("paramName", "paramValue")).customHeaders(Collections.singletonMap("headerName", "headerValue")).customBodyParameters(Collections.singletonMap("bodyParamName", "bodyParamValue")).encodeClientCredentialsInBody(true).name("Dancer Name").withClientCredentialsIn(ClientCredentialsLocation.BODY).scopes("aScope").encoding(StandardCharsets.ISO_8859_1).responseAccessTokenExpr("someAccessToken").responseRefreshTokenExpr("someRefreshToken").responseExpiresInExpr("someExpiresIn").customParametersExtractorsExprs(Collections.singletonMap("someKey", "someValue")).resourceOwnerIdTransformer(roid -> "conn1-" + roid).tokenUrl("https://host/token");
        ClientCredentialsOAuthDancer dancer = (ClientCredentialsOAuthDancer)this.startDancer(builder);
        ((ClientCredentialsListener)Mockito.verify((Object)listenerFromBuilder)).onTokenRefreshed((ResourceOwnerOAuthContext)ArgumentMatchers.any());
        ((ClientCredentialsListener)Mockito.verify((Object)legacyListenerFromBuilder)).onTokenRefreshed((ResourceOwnerOAuthContext)ArgumentMatchers.any());
        dancer.addListener(listenerFromDancer);
        dancer.refreshToken().get();
        ((ClientCredentialsListener)Mockito.verify((Object)listenerFromBuilder, (VerificationMode)Mockito.times((int)2))).onTokenRefreshed((ResourceOwnerOAuthContext)ArgumentMatchers.any());
        ((ClientCredentialsListener)Mockito.verify((Object)legacyListenerFromBuilder, (VerificationMode)Mockito.times((int)2))).onTokenRefreshed((ResourceOwnerOAuthContext)ArgumentMatchers.any());
        ((ClientCredentialsListener)Mockito.verify((Object)listenerFromDancer, (VerificationMode)Mockito.times((int)1))).onTokenRefreshed((ResourceOwnerOAuthContext)ArgumentMatchers.any());
        dancer.removeListener(listenerFromDancer);
        LifecycleUtils.disposeIfNeeded((Object)dancer, (Logger)LOGGER);
    }

    @Test
    public void authCodeDancerComplexBuilder() throws MalformedURLException, MuleException, ExecutionException, InterruptedException {
        AuthorizationCodeListener listenerFromBuilder = (AuthorizationCodeListener)Mockito.mock(AuthorizationCodeListener.class);
        AuthorizationCodeListener legacyListenerFromBuilder = (AuthorizationCodeListener)Mockito.mock(org.mule.runtime.oauth.api.listener.AuthorizationCodeListener.class);
        AuthorizationCodeListener listenerFromDancer = (AuthorizationCodeListener)Mockito.mock(AuthorizationCodeListener.class);
        MultiMap additionalRefreshTokenParameters = new MultiMap();
        additionalRefreshTokenParameters.put((Object)"additional_parameter", (Object)"additionalParam");
        MultiMap additionalRefreshTokenHeaders = new MultiMap();
        HashMap<String, ResourceOwnerOAuthContext> tokensStore = new HashMap<String, ResourceOwnerOAuthContext>();
        MuleExpressionLanguage el = (MuleExpressionLanguage)Mockito.mock(MuleExpressionLanguage.class);
        additionalRefreshTokenHeaders.put((Object)"additional_header", (Object)"header");
        OAuthAuthorizationCodeDancerBuilder builder = this.authorizationCodeGrantTypeDancerBuilder(this.lockFactory, tokensStore, el);
        ((Compatibility1xOAuthAuthorizationCodeDancerBuilder)builder).addListener((org.mule.runtime.oauth.api.listener.AuthorizationCodeListener)legacyListenerFromBuilder).addListener(listenerFromBuilder).customParameters(Collections.singletonMap("paramName", "paramValue")).customHeaders(Collections.singletonMap("headerName", "headerValue")).customBodyParameters(Collections.singletonMap("bodyParamName", "bodyParamValue")).encodeClientCredentialsInBody(true).localCallback(new URL("https://some/callback")).localAuthorizationUrlPath("https://some/authorization/path").localAuthorizationUrlResourceOwnerId("someResourceOwnerId").state("stateExpr").authorizationUrl("https://some/authorization/url").externalCallbackUrl("https://some/externalCallbackUrl").beforeDanceCallback(r -> null).afterDanceCallback((cbCtx, ctx) -> {}).addAdditionalRefreshTokenRequestParameters(additionalRefreshTokenParameters).addAdditionalRefreshTokenRequestHeaders(additionalRefreshTokenHeaders).includeRedirectUriInRefreshTokenRequest(false).name("Dancer Name").clientCredentials("clientId", "clientSecret").withClientCredentialsIn(ClientCredentialsLocation.BODY).scopes("aScope").encoding(StandardCharsets.ISO_8859_1).responseAccessTokenExpr("someAccessToken").responseRefreshTokenExpr("someRefreshToken").responseExpiresInExpr("someExpiresIn").customParametersExtractorsExprs(Collections.singletonMap("someKey", "someValue")).resourceOwnerIdTransformer(roid -> "conn1-" + roid).tokenUrl("https://host/token");
        AuthorizationCodeOAuthDancer dancer = (AuthorizationCodeOAuthDancer)this.startDancer((OAuthDancerBuilder)builder);
        CustomResourceOwnerOAuthContext ownerOAuthContext = new CustomResourceOwnerOAuthContext((Lock)new ReentrantLock(), "someResourceOwnerId");
        ownerOAuthContext.setRefreshToken("refreshToken");
        ownerOAuthContext.setAccessToken("accessToken");
        tokensStore.put("conn1-someResourceOwnerId", (ResourceOwnerOAuthContext)ownerOAuthContext);
        dancer.addListener("someResourceOwnerId", listenerFromDancer);
        dancer.refreshToken("someResourceOwnerId").get();
        ((AuthorizationCodeListener)Mockito.verify((Object)listenerFromBuilder)).onTokenRefreshed((ResourceOwnerOAuthContext)ArgumentMatchers.any());
        ((AuthorizationCodeListener)Mockito.verify((Object)legacyListenerFromBuilder)).onTokenRefreshed((ResourceOwnerOAuthContext)ArgumentMatchers.any());
        ((AuthorizationCodeListener)Mockito.verify((Object)listenerFromDancer)).onTokenRefreshed((ResourceOwnerOAuthContext)ArgumentMatchers.any());
        dancer.removeListener("someResourceOwnerId", listenerFromDancer);
        dancer.accessToken("someResourceOwnerId").get();
        dancer.addListener(listenerFromDancer);
        dancer.refreshToken("someResourceOwnerId", true).get();
        ((AuthorizationCodeListener)Mockito.verify((Object)listenerFromBuilder, (VerificationMode)Mockito.times((int)2))).onTokenRefreshed((ResourceOwnerOAuthContext)ArgumentMatchers.any());
        ((AuthorizationCodeListener)Mockito.verify((Object)legacyListenerFromBuilder, (VerificationMode)Mockito.times((int)2))).onTokenRefreshed((ResourceOwnerOAuthContext)ArgumentMatchers.any());
        ((AuthorizationCodeListener)Mockito.verify((Object)listenerFromDancer, (VerificationMode)Mockito.times((int)2))).onTokenRefreshed((ResourceOwnerOAuthContext)ArgumentMatchers.any());
        dancer.removeListener(listenerFromDancer);
        MatcherAssert.assertThat((Object)dancer.getInvalidateFromTokensStore("someResourceOwnerId"), (Matcher)Is.is((Object)false));
        LifecycleUtils.disposeIfNeeded((Object)dancer, (Logger)LOGGER);
    }

    protected OAuthClientCredentialsDancerBuilder baseClientCredentialsDancerBuilder(Map<String, ?> tokensStore) {
        Compatibility1xOAuthClientCredentialsDancerBuilder builder = new Compatibility1xOAuthClientCredentialsDancerBuilder((SchedulerService)new SimpleUnitTestSupportSchedulerService(), this.lockFactory, tokensStore, this.oAuthHttpClientFactory, (MuleExpressionLanguage)Mockito.mock(MuleExpressionLanguage.class));
        builder.clientCredentials("clientId", "clientSecret");
        return builder;
    }

    protected OAuthAuthorizationCodeDancerBuilder baseAuthCodeDancerbuilder() {
        Compatibility1xOAuthAuthorizationCodeDancerBuilder builder = new Compatibility1xOAuthAuthorizationCodeDancerBuilder((SchedulerService)new SimpleUnitTestSupportSchedulerService(), this.lockFactory, new HashMap(), this.httpService, this.oAuthHttpClientFactory, (MuleExpressionLanguage)Mockito.mock(MuleExpressionLanguage.class));
        builder.clientCredentials("clientId", "clientSecret");
        return builder;
    }

    protected OAuthAuthorizationCodeDancerBuilder authorizationCodeGrantTypeDancerBuilder(LockFactory lockProvider, Map<String, ResourceOwnerOAuthContext> tokensStore, MuleExpressionLanguage expressionEvaluator) {
        return new Compatibility1xOAuthAuthorizationCodeDancerBuilder((SchedulerService)new SimpleUnitTestSupportSchedulerService(), lockProvider, tokensStore, this.httpService, this.oAuthHttpClientFactory, expressionEvaluator);
    }
}

