/*
 * Decompiled with CFR 0.152.
 */
package org.mule.services.oauth.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionEvaluator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.MapUtils;
import org.mule.runtime.oauth.api.exception.RequestAuthenticationException;
import org.mule.runtime.oauth.api.exception.TokenNotFoundException;
import org.mule.runtime.oauth.api.exception.TokenUrlResponseException;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.service.http.api.HttpConstants;
import org.mule.service.http.api.HttpHeaders;
import org.mule.service.http.api.client.HttpClient;
import org.mule.service.http.api.domain.ParameterMap;
import org.mule.service.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.service.http.api.domain.entity.HttpEntity;
import org.mule.service.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.service.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.service.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.api.utils.HttpEncoderDecoderUtils;
import org.mule.services.oauth.internal.state.TokenResponse;

public abstract class AbstractOAuthDancer
implements Startable,
Stoppable {
    private static final int TOKEN_REQUEST_TIMEOUT_MILLIS = 60000;
    protected final String clientId;
    protected final String clientSecret;
    protected final String tokenUrl;
    protected final Charset encoding;
    protected final String scopes;
    protected final String responseAccessTokenExpr;
    protected final String responseRefreshTokenExpr;
    protected final String responseExpiresInExpr;
    protected final Map<String, String> customParametersExtractorsExprs;
    private final LockFactory lockProvider;
    private final Map<String, ResourceOwnerOAuthContext> tokensStore;
    private final HttpClient httpClient;
    private final ExpressionEvaluator expressionEvaluator;

    protected AbstractOAuthDancer(String clientId, String clientSecret, String tokenUrl, Charset encoding, String scopes, String responseAccessTokenExpr, String responseRefreshTokenExpr, String responseExpiresInExpr, Map<String, String> customParametersExtractorsExprs, LockFactory lockProvider, Map<String, ResourceOwnerOAuthContext> tokensStore, HttpClient httpClient, ExpressionEvaluator expressionEvaluator) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenUrl = tokenUrl;
        this.encoding = encoding;
        this.scopes = scopes;
        this.responseAccessTokenExpr = responseAccessTokenExpr;
        this.responseRefreshTokenExpr = responseRefreshTokenExpr;
        this.responseExpiresInExpr = responseExpiresInExpr;
        this.customParametersExtractorsExprs = customParametersExtractorsExprs;
        this.lockProvider = lockProvider;
        this.tokensStore = tokensStore;
        this.httpClient = httpClient;
        this.expressionEvaluator = expressionEvaluator;
    }

    public void start() throws MuleException {
        this.httpClient.start();
    }

    public void stop() throws MuleException {
        this.httpClient.stop();
    }

    public CompletableFuture<String> accessToken(String resourceOwner) throws RequestAuthenticationException {
        String accessToken = this.getContextForResourceOwner(resourceOwner).getAccessToken();
        if (accessToken == null) {
            throw new RequestAuthenticationException(I18nMessageFactory.createStaticMessage((String)String.format("No access token found. Verify that you have authenticated before trying to execute an operation to the API.", new Object[0])));
        }
        return CompletableFuture.completedFuture(accessToken);
    }

    protected TokenResponse invokeTokenUrl(String tokenUrl, Map<String, String> tokenRequestFormToSend, String authorization, boolean retrieveRefreshToken, Charset encoding) throws TokenUrlResponseException, TokenNotFoundException {
        try {
            String readBody;
            HttpResponse response;
            HttpRequestBuilder requestBuilder = (HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().setUri(tokenUrl).setMethod(HttpConstants.Method.POST.name()).setEntity((HttpEntity)new ByteArrayHttpEntity(HttpEncoderDecoderUtils.encodeString(tokenRequestFormToSend, (Charset)encoding).getBytes()))).addHeader("Content-Type", HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString());
            if (authorization != null) {
                requestBuilder.addHeader("Authorization", authorization);
            }
            MediaType responseContentType = (response = this.httpClient.send(requestBuilder.build(), 60000, true, null)).getHeaderValueIgnoreCase("Content-Type") != null ? MediaType.parse((String)response.getHeaderValueIgnoreCase("Content-Type")) : MediaType.ANY;
            ParameterMap headers = new ParameterMap();
            for (String headerName : response.getHeaderNames()) {
                headers.put(headerName, response.getHeaderValues(headerName));
            }
            String body = readBody = IOUtils.toString((InputStream)((InputStreamHttpEntity)response.getEntity()).getInputStream());
            if (responseContentType.withoutParameters().matches(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED)) {
                body = HttpEncoderDecoderUtils.decodeUrlEncodedBody((String)readBody, (Charset)responseContentType.getCharset().orElse(encoding));
            }
            if (response.getStatusCode() >= HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()) {
                throw new TokenUrlResponseException(tokenUrl);
            }
            TokenResponse tokenResponse = new TokenResponse();
            tokenResponse.setAccessToken((String)this.resolveExpression(this.responseAccessTokenExpr, body, headers, responseContentType));
            if (tokenResponse.getAccessToken() == null) {
                throw new TokenNotFoundException((Object)body);
            }
            if (retrieveRefreshToken) {
                tokenResponse.setRefreshToken((String)this.resolveExpression(this.responseRefreshTokenExpr, body, headers, responseContentType));
            }
            tokenResponse.setExpiresIn((String)this.resolveExpression(this.responseExpiresInExpr, body, headers, responseContentType));
            if (!MapUtils.isEmpty(this.customParametersExtractorsExprs)) {
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                for (Map.Entry<String, String> customParamExpr : this.customParametersExtractorsExprs.entrySet()) {
                    customParams.put(customParamExpr.getKey(), this.resolveExpression(customParamExpr.getValue(), body, headers, responseContentType));
                }
                tokenResponse.setCustomResponseParameters(customParams);
            }
            return tokenResponse;
        }
        catch (IOException e) {
            throw new TokenUrlResponseException(tokenUrl, (Exception)e);
        }
        catch (TimeoutException e) {
            throw new TokenUrlResponseException(tokenUrl, (Exception)e);
        }
    }

    protected <T> T resolveExpression(String expr, Object body, ParameterMap headers, MediaType responseContentType) {
        if (expr == null) {
            return null;
        }
        if (!this.expressionEvaluator.isExpression(expr)) {
            return (T)expr;
        }
        BindingContext resultContext = BindingContext.builder().addBinding("payload", new TypedValue(body, DataType.builder().fromObject(body).mediaType(responseContentType).build())).addBinding("attributes", new TypedValue(Collections.singletonMap("headers", headers.toImmutableParameterMap()), DataType.fromType(Map.class))).addBinding("dataType", new TypedValue((Object)DataType.builder().fromObject(body).mediaType(responseContentType).build(), DataType.fromType(DataType.class))).build();
        return (T)this.expressionEvaluator.evaluate(expr, resultContext).getValue();
    }

    protected <T> T resolveExpression(String expr, Object body, ParameterMap headers, ParameterMap queryParams, MediaType responseContentType) {
        if (expr == null) {
            return null;
        }
        if (!this.expressionEvaluator.isExpression(expr)) {
            return (T)expr;
        }
        HashMap<String, ParameterMap> attributes = new HashMap<String, ParameterMap>(2);
        attributes.put("headers", headers.toImmutableParameterMap());
        attributes.put("queryParams", queryParams.toImmutableParameterMap());
        BindingContext resultContext = BindingContext.builder().addBinding("payload", new TypedValue(body, DataType.builder().fromObject(body).mediaType(responseContentType).build())).addBinding("attributes", new TypedValue(attributes, DataType.fromType(Map.class))).addBinding("dataType", new TypedValue((Object)DataType.builder().fromObject(body).mediaType(responseContentType).build(), DataType.fromType(DataType.class))).build();
        return (T)this.expressionEvaluator.evaluate(expr, resultContext).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceOwnerOAuthContext getContextForResourceOwner(String resourceOwnerId) {
        ResourceOwnerOAuthContext resourceOwnerOAuthContext = null;
        if (!this.tokensStore.containsKey(resourceOwnerId)) {
            Lock lock = this.lockProvider.createLock(this.toString() + "-config-oauth-context");
            lock.lock();
            try {
                if (!this.tokensStore.containsKey(resourceOwnerId)) {
                    resourceOwnerOAuthContext = new ResourceOwnerOAuthContext(this.createLockForResourceOwner(resourceOwnerId), resourceOwnerId);
                    this.tokensStore.put(resourceOwnerId, resourceOwnerOAuthContext);
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (resourceOwnerOAuthContext == null) {
            resourceOwnerOAuthContext = this.tokensStore.get(resourceOwnerId);
            resourceOwnerOAuthContext.setRefreshUserOAuthContextLock(this.createLockForResourceOwner(resourceOwnerId));
        }
        return resourceOwnerOAuthContext;
    }

    private Lock createLockForResourceOwner(String resourceOwnerId) {
        return this.lockProvider.createLock(this.toString() + "-" + resourceOwnerId);
    }

    protected void updateResourceOwnerOAuthContext(ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        Lock resourceOwnerContextLock = resourceOwnerOAuthContext.getRefreshUserOAuthContextLock();
        resourceOwnerContextLock.lock();
        try {
            this.tokensStore.put(resourceOwnerOAuthContext.getResourceOwnerId(), resourceOwnerOAuthContext);
        }
        finally {
            resourceOwnerContextLock.unlock();
        }
    }
}

