/*
 * Decompiled with CFR 0.152.
 */
package org.mule.services.oauth.internal;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.codec.binary.Base64;
import org.mule.runtime.api.el.ExpressionEvaluator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.oauth.api.OAuthDancer;
import org.mule.runtime.oauth.api.exception.TokenNotFoundException;
import org.mule.runtime.oauth.api.exception.TokenUrlResponseException;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.service.http.api.client.HttpClient;
import org.mule.services.oauth.internal.AbstractOAuthDancer;
import org.mule.services.oauth.internal.state.TokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCredentialsOAuthDancer
extends AbstractOAuthDancer
implements OAuthDancer,
Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientCredentialsOAuthDancer.class);
    private final boolean encodeClientCredentialsInBody;

    public ClientCredentialsOAuthDancer(String clientId, String clientSecret, String tokenUrl, String scopes, boolean encodeClientCredentialsInBody, Charset encoding, String responseAccessTokenExpr, String responseRefreshTokenExpr, String responseExpiresInExpr, Map<String, String> customParametersExprs, LockFactory lockProvider, Map<String, ResourceOwnerOAuthContext> tokensStore, HttpClient httpClient, ExpressionEvaluator expressionEvaluator) {
        super(clientId, clientSecret, tokenUrl, encoding, scopes, responseAccessTokenExpr, responseRefreshTokenExpr, responseExpiresInExpr, customParametersExprs, lockProvider, tokensStore, httpClient, expressionEvaluator);
        this.encodeClientCredentialsInBody = encodeClientCredentialsInBody;
    }

    @Override
    public void start() throws MuleException {
        super.start();
        try {
            this.refreshToken(null).get();
        }
        catch (ExecutionException e) {
            super.stop();
            throw new LifecycleException(e.getCause(), (Object)this);
        }
        catch (InterruptedException e) {
            super.stop();
            Thread.currentThread().interrupt();
            throw new LifecycleException((Throwable)e, (Object)this);
        }
    }

    public CompletableFuture<Void> refreshToken(String resourceOwner) {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("grant_type", "client_credentials");
        if (this.scopes != null) {
            formData.put("scope", this.scopes);
        }
        String authorization = null;
        if (this.encodeClientCredentialsInBody) {
            formData.put("client_id", this.clientId);
            formData.put("client_secret", this.clientSecret);
        } else {
            authorization = "Basic " + Base64.encodeBase64String((byte[])String.format("%s:%s", this.clientId, this.clientSecret).getBytes());
        }
        try {
            TokenResponse tokenResponse = this.invokeTokenUrl(this.tokenUrl, formData, authorization, false, this.encoding);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Retrieved access token, refresh token and expires from token url are: %s, %s, %s", new Object[]{tokenResponse.getAccessToken(), tokenResponse.getRefreshToken(), tokenResponse.getExpiresIn()});
            }
            ResourceOwnerOAuthContext defaultUserState = this.getContextForResourceOwner("default");
            defaultUserState.setAccessToken(tokenResponse.getAccessToken());
            defaultUserState.setExpiresIn(tokenResponse.getExpiresIn());
            for (Map.Entry<String, Object> customResponseParameterEntry : tokenResponse.getCustomResponseParameters().entrySet()) {
                defaultUserState.getTokenResponseParameters().put(customResponseParameterEntry.getKey(), customResponseParameterEntry.getValue());
            }
            this.updateResourceOwnerOAuthContext(defaultUserState);
            return CompletableFuture.completedFuture(null);
        }
        catch (TokenNotFoundException | TokenUrlResponseException e) {
            CompletableFuture<Void> exceptionFuture = new CompletableFuture<Void>();
            exceptionFuture.completeExceptionally(e);
            return exceptionFuture;
        }
    }
}

