/*
 * Decompiled with CFR 0.152.
 */
package org.mule.services.oauth.internal;

import java.util.Map;
import org.mule.runtime.api.el.ExpressionEvaluator;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.builder.OAuthAuthorizationCodeDancerBuilder;
import org.mule.runtime.oauth.api.builder.OAuthClientCredentialsDancerBuilder;
import org.mule.service.http.api.HttpService;
import org.mule.services.oauth.internal.OAuthCallbackServersManager;
import org.mule.services.oauth.internal.builder.DefaultOAuthAuthorizationCodeDancerBuilder;
import org.mule.services.oauth.internal.builder.DefaultOAuthClientCredentialsDancerBuilder;

public final class DefaultOAuthService
implements OAuthService {
    private final HttpService httpService;
    private final OAuthCallbackServersManager httpServersManager;
    private final SchedulerService schedulerService;

    public DefaultOAuthService(HttpService httpService, SchedulerService schedulerService) {
        this.httpService = httpService;
        this.httpServersManager = new OAuthCallbackServersManager(httpService);
        this.schedulerService = schedulerService;
    }

    public String getName() {
        return "OAuthService";
    }

    public <T> OAuthClientCredentialsDancerBuilder clientCredentialsGrantTypeDancerBuilder(LockFactory lockProvider, Map<String, T> tokensStore, ExpressionEvaluator expressionEvaluator) {
        return new DefaultOAuthClientCredentialsDancerBuilder(lockProvider, tokensStore, this.httpService, expressionEvaluator);
    }

    public <T> OAuthAuthorizationCodeDancerBuilder authorizationCodeGrantTypeDancerBuilder(LockFactory lockProvider, Map<String, T> tokensStore, ExpressionEvaluator expressionEvaluator) {
        return new DefaultOAuthAuthorizationCodeDancerBuilder(this.httpServersManager, this.schedulerService, lockProvider, tokensStore, this.httpService, expressionEvaluator);
    }
}

