/*
 * Decompiled with CFR 0.152.
 */
package org.mule.services.oauth.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.service.http.api.HttpService;
import org.mule.service.http.api.server.HttpServer;
import org.mule.service.http.api.server.HttpServerConfiguration;
import org.mule.service.http.api.server.RequestHandler;
import org.mule.service.http.api.server.RequestHandlerManager;
import org.mule.service.http.api.server.ServerAddress;

public class OAuthCallbackServersManager {
    private HttpService httpService;
    private Map<Integer, CountedHttpServer> serversByPort = new HashMap<Integer, CountedHttpServer>();

    public OAuthCallbackServersManager(HttpService httpService) {
        this.httpService = httpService;
    }

    public synchronized HttpServer getServer(HttpServerConfiguration serverConfiguration) throws ConnectionException {
        if (!this.serversByPort.containsKey(serverConfiguration.getPort())) {
            this.serversByPort.put(serverConfiguration.getPort(), new CountedHttpServer(this.httpService.getServerFactory().create(serverConfiguration)));
        }
        return this.serversByPort.get(serverConfiguration.getPort());
    }

    private class CountedHttpServer
    implements HttpServer {
        private AtomicInteger count = new AtomicInteger(0);
        private final HttpServer server;
        private ConcurrentMap<String, RequestHandlerManager> registeredHandlerMatchers = new ConcurrentHashMap<String, RequestHandlerManager>();

        CountedHttpServer(HttpServer server) {
            this.server = server;
        }

        public void start() throws IOException {
            if (this.count.getAndIncrement() == 0) {
                this.server.start();
            }
        }

        public void stop() {
            if (this.count.decrementAndGet() == 0) {
                this.server.stop();
            }
        }

        public void dispose() {
            if (this.count.get() == 0) {
                this.server.dispose();
                OAuthCallbackServersManager.this.serversByPort.remove(this.getServerAddress().getPort());
            }
        }

        public ServerAddress getServerAddress() {
            return this.server.getServerAddress();
        }

        public boolean isStopping() {
            return this.server.isStopping();
        }

        public boolean isStopped() {
            return this.server.isStopped();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RequestHandlerManager addRequestHandler(Collection<String> methods, String path, RequestHandler requestHandler) {
            String handlerKey = this.buildCompositeHandlerKey(methods, path);
            ConcurrentMap<String, RequestHandlerManager> concurrentMap = this.registeredHandlerMatchers;
            synchronized (concurrentMap) {
                if (!this.registeredHandlerMatchers.containsKey(handlerKey)) {
                    this.registeredHandlerMatchers.put(handlerKey, new CountedRequestHandlerManager(methods, path, this.server.addRequestHandler(methods, path, requestHandler)));
                }
                return (RequestHandlerManager)this.registeredHandlerMatchers.get(handlerKey);
            }
        }

        private String buildCompositeHandlerKey(Collection<String> methods, String path) {
            String handlerKey = String.format("%s-%s", methods.toString(), path);
            return handlerKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RequestHandlerManager addRequestHandler(String path, RequestHandler requestHandler) {
            String handlerKey = path;
            ConcurrentMap<String, RequestHandlerManager> concurrentMap = this.registeredHandlerMatchers;
            synchronized (concurrentMap) {
                if (!this.registeredHandlerMatchers.containsKey(handlerKey)) {
                    this.registeredHandlerMatchers.put(handlerKey, new CountedRequestHandlerManager(path, this.server.addRequestHandler(path, requestHandler)));
                }
                return (RequestHandlerManager)this.registeredHandlerMatchers.get(handlerKey);
            }
        }

        private class CountedRequestHandlerManager
        implements RequestHandlerManager {
            private AtomicInteger count = new AtomicInteger(0);
            private Collection<String> methods;
            private String path;
            private RequestHandlerManager requestHandler;

            public CountedRequestHandlerManager(Collection<String> methods, String path, RequestHandlerManager requestHandler) {
                this.methods = methods;
                this.path = path;
                this.requestHandler = requestHandler;
            }

            public CountedRequestHandlerManager(String path, RequestHandlerManager requestHandler) {
                this.methods = null;
                this.path = path;
                this.requestHandler = requestHandler;
            }

            public void start() {
                if (this.count.getAndIncrement() == 0) {
                    this.requestHandler.start();
                }
            }

            public void stop() {
                if (this.count.decrementAndGet() == 0) {
                    this.requestHandler.stop();
                }
            }

            public void dispose() {
                if (this.count.get() == 0) {
                    this.requestHandler.dispose();
                    String handlerKey = this.methods != null ? CountedHttpServer.this.buildCompositeHandlerKey(this.methods, this.path) : this.path;
                    CountedHttpServer.this.registeredHandlerMatchers.remove(handlerKey);
                }
            }
        }
    }
}

