/*
 * Decompiled with CFR 0.152.
 */
package org.mule.services.oauth.internal.builder;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.mule.runtime.api.el.ExpressionEvaluator;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.oauth.api.OAuthDancer;
import org.mule.runtime.oauth.api.builder.OAuthDancerBuilder;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.service.http.api.HttpService;
import org.mule.service.http.api.client.HttpClient;
import org.mule.service.http.api.client.HttpClientConfiguration;
import org.mule.service.http.api.client.HttpRequestAuthentication;
import org.mule.service.http.api.client.async.ResponseHandler;
import org.mule.service.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.api.domain.message.response.HttpResponse;

public abstract class AbstractOAuthDancerBuilder<D extends OAuthDancer>
implements OAuthDancerBuilder<D> {
    protected final LockFactory lockProvider;
    protected final Map<String, ResourceOwnerOAuthContext> tokensStore;
    protected final HttpService httpService;
    protected final ExpressionEvaluator expressionEvaluator;
    protected String clientId;
    protected String clientSecret;
    protected String tokenUrl;
    protected Supplier<HttpClient> httpClientFactory;
    protected Charset encoding = StandardCharsets.UTF_8;
    protected String responseAccessTokenExpr = "#[(payload match /.*\"access_token\"[ ]*:[ ]*\"([^\\\"]*)\".*/)[1]]";
    protected String responseRefreshTokenExpr = "#[(payload match /.*\"refresh_token\"[ ]*:[ ]*\"([^\\\"]*)\".*/)[1]]";
    protected String responseExpiresInExpr = "#[(payload match /.*\"expires_in\"[ ]*:[ ]*\"([^\\\"]*)\".*/)[1]]";
    protected String scopes = null;
    protected Map<String, String> customParametersExtractorsExprs;

    public AbstractOAuthDancerBuilder(LockFactory lockProvider, Map<String, ResourceOwnerOAuthContext> tokensStore, HttpService httpService, ExpressionEvaluator expressionEvaluator) {
        this.lockProvider = lockProvider;
        this.tokensStore = tokensStore;
        this.httpService = httpService;
        this.expressionEvaluator = expressionEvaluator;
    }

    public OAuthDancerBuilder clientCredentials(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        return this;
    }

    public OAuthDancerBuilder tokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
        this.httpClientFactory = () -> {
            HttpClientConfiguration.Builder clientConfigBuilder = new HttpClientConfiguration.Builder().setThreadNamePrefix(String.format("oauthToken.requester[%s]", tokenUrl));
            return this.httpService.getClientFactory().create(clientConfigBuilder.build());
        };
        return this;
    }

    public OAuthDancerBuilder tokenUrl(final HttpClient httpClient, String tokenUrl) {
        this.httpClientFactory = () -> new HttpClient(){

            public void stop() {
            }

            public void start() {
            }

            public void send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpRequestAuthentication authentication, ResponseHandler handler) {
                httpClient.send(request, responseTimeout, followRedirects, authentication, handler);
            }

            public HttpResponse send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpRequestAuthentication authentication) throws IOException, TimeoutException {
                return httpClient.send(request, responseTimeout, followRedirects, authentication);
            }
        };
        this.tokenUrl = tokenUrl;
        return this;
    }

    public OAuthDancerBuilder tokenUrl(String tokenUrl, TlsContextFactory tlsContextFactory) {
        this.tokenUrl = tokenUrl;
        this.httpClientFactory = () -> {
            HttpClientConfiguration.Builder clientConfigBuilder = new HttpClientConfiguration.Builder().setThreadNamePrefix(String.format("oauthToken.requester[%s]", tokenUrl));
            clientConfigBuilder.setTlsContextFactory(tlsContextFactory);
            return this.httpService.getClientFactory().create(clientConfigBuilder.build());
        };
        return this;
    }

    public OAuthDancerBuilder scopes(String scopes) {
        this.scopes = scopes;
        return this;
    }

    public OAuthDancerBuilder encoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    public OAuthDancerBuilder responseAccessTokenExpr(String responseAccessTokenExpr) {
        this.responseAccessTokenExpr = responseAccessTokenExpr;
        return this;
    }

    public OAuthDancerBuilder responseRefreshTokenExpr(String responseRefreshTokenExpr) {
        this.responseRefreshTokenExpr = responseRefreshTokenExpr;
        return this;
    }

    public OAuthDancerBuilder responseExpiresInExpr(String responseExpiresInExpr) {
        this.responseExpiresInExpr = responseExpiresInExpr;
        return this;
    }

    public OAuthDancerBuilder customParametersExtractorsExprs(Map<String, String> customParamsExtractorsExprs) {
        this.customParametersExtractorsExprs = customParamsExtractorsExprs;
        return this;
    }
}

