/*
 * Decompiled with CFR 0.152.
 */
package org.mule.services.oauth.internal.builder;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.el.ExpressionEvaluator;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.oauth.api.AuthorizationCodeOAuthDancer;
import org.mule.runtime.oauth.api.builder.OAuthAuthorizationCodeDancerBuilder;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.service.http.api.HttpService;
import org.mule.service.http.api.client.HttpClient;
import org.mule.service.http.api.server.HttpServer;
import org.mule.service.http.api.server.HttpServerConfiguration;
import org.mule.service.http.api.server.RequestHandler;
import org.mule.service.http.api.server.RequestHandlerManager;
import org.mule.service.http.api.server.ServerAddress;
import org.mule.services.oauth.internal.DefaultAuthorizationCodeOAuthDancer;
import org.mule.services.oauth.internal.OAuthCallbackServersManager;
import org.mule.services.oauth.internal.builder.AbstractOAuthDancerBuilder;

public class DefaultOAuthAuthorizationCodeDancerBuilder
extends AbstractOAuthDancerBuilder<AuthorizationCodeOAuthDancer>
implements OAuthAuthorizationCodeDancerBuilder {
    private OAuthCallbackServersManager httpServersManager;
    private Function<OAuthCallbackServersManager, HttpServer> localCallbackServerFactory;
    private String localCallbackUrlPath;
    private String localAuthorizationUrlPath;
    private String localAuthorizationUrlResourceOwnerId;
    private String externalCallbackUrl;
    private String state;
    private String authorizationUrl;
    private Map<String, String> customParameters = Collections.emptyMap();

    public DefaultOAuthAuthorizationCodeDancerBuilder(OAuthCallbackServersManager httpServersManager, SchedulerService schedulerService, LockFactory lockProvider, Map<String, ResourceOwnerOAuthContext> tokensStore, HttpService httpService, ExpressionEvaluator expressionEvaluator) {
        super(lockProvider, tokensStore, httpService, expressionEvaluator);
        this.httpServersManager = httpServersManager;
    }

    public OAuthAuthorizationCodeDancerBuilder localCallback(URL localCallbackUrl) {
        this.localCallbackServerFactory = serversManager -> {
            HttpServerConfiguration.Builder serverConfigBuilder = new HttpServerConfiguration.Builder();
            serverConfigBuilder.setHost(localCallbackUrl.getHost()).setPort(localCallbackUrl.getPort());
            try {
                return serversManager.getServer(serverConfigBuilder.build());
            }
            catch (ConnectionException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        };
        this.localCallbackUrlPath = localCallbackUrl.getPath();
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder localCallback(URL localCallbackUrl, TlsContextFactory tlsContextFactory) {
        this.localCallbackServerFactory = serversManager -> {
            HttpServerConfiguration.Builder serverConfigBuilder = new HttpServerConfiguration.Builder();
            serverConfigBuilder.setHost(localCallbackUrl.getHost()).setPort(localCallbackUrl.getPort());
            serverConfigBuilder.setTlsContextFactory(tlsContextFactory);
            try {
                return serversManager.getServer(serverConfigBuilder.build());
            }
            catch (ConnectionException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        };
        this.localCallbackUrlPath = localCallbackUrl.getPath();
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder localCallback(final HttpServer server, final String localCallbackConfigPath) {
        this.localCallbackServerFactory = serversManager -> new HttpServer(){

            public void stop() {
            }

            public void start() throws IOException {
            }

            public boolean isStopping() {
                return server.isStopping();
            }

            public boolean isStopped() {
                return server.isStopped();
            }

            public ServerAddress getServerAddress() {
                return server.getServerAddress();
            }

            public void dispose() {
            }

            public RequestHandlerManager addRequestHandler(String path, RequestHandler requestHandler) {
                return server.addRequestHandler(localCallbackConfigPath, requestHandler);
            }

            public RequestHandlerManager addRequestHandler(Collection<String> methods, String path, RequestHandler requestHandler) {
                return server.addRequestHandler(methods, localCallbackConfigPath, requestHandler);
            }
        };
        this.localCallbackUrlPath = localCallbackConfigPath;
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder localAuthorizationUrlPath(String path) {
        this.localAuthorizationUrlPath = path;
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder localAuthorizationUrlResourceOwnerId(String localAuthorizationUrlResourceOwnerIdExpr) {
        this.localAuthorizationUrlResourceOwnerId = localAuthorizationUrlResourceOwnerIdExpr;
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder customParameters(Map<String, String> customParameters) {
        Objects.requireNonNull(customParameters, "customParameters cannot be null");
        this.customParameters = customParameters;
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder state(String stateExpr) {
        this.state = stateExpr;
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder authorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
        return this;
    }

    public OAuthAuthorizationCodeDancerBuilder externalCallbackUrl(String externalCallbackUrl) {
        this.externalCallbackUrl = externalCallbackUrl;
        return this;
    }

    public AuthorizationCodeOAuthDancer build() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientId), (String)"clientId cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientSecret), (String)"clientSecret cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.tokenUrl), (String)"tokenUrl cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.authorizationUrl), (String)"authorizationUrl cannot be blank");
        Objects.requireNonNull(this.localCallbackServerFactory, "localCallback must be configured");
        return new DefaultAuthorizationCodeOAuthDancer(this.localCallbackServerFactory.apply(this.httpServersManager), this.clientId, this.clientSecret, this.tokenUrl, this.scopes, this.externalCallbackUrl, this.encoding, this.localCallbackUrlPath, this.localAuthorizationUrlPath, this.localAuthorizationUrlResourceOwnerId, this.state, this.authorizationUrl, this.responseAccessTokenExpr, this.responseRefreshTokenExpr, this.responseExpiresInExpr, this.customParameters, this.customParametersExtractorsExprs, this.lockProvider, this.tokensStore, (HttpClient)this.httpClientFactory.get(), this.expressionEvaluator);
    }
}

