/*
 * Decompiled with CFR 0.152.
 */
package org.mule.services.oauth.internal.builder;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.ExpressionEvaluator;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.oauth.api.OAuthDancer;
import org.mule.runtime.oauth.api.builder.OAuthClientCredentialsDancerBuilder;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.service.http.api.HttpService;
import org.mule.service.http.api.client.HttpClient;
import org.mule.services.oauth.internal.ClientCredentialsOAuthDancer;
import org.mule.services.oauth.internal.builder.AbstractOAuthDancerBuilder;

public class DefaultOAuthClientCredentialsDancerBuilder
extends AbstractOAuthDancerBuilder
implements OAuthClientCredentialsDancerBuilder {
    private boolean encodeClientCredentialsInBody = false;

    public DefaultOAuthClientCredentialsDancerBuilder(LockFactory lockProvider, Map<String, ResourceOwnerOAuthContext> tokensStore, HttpService httpService, ExpressionEvaluator expressionEvaluator) {
        super(lockProvider, tokensStore, httpService, expressionEvaluator);
    }

    public OAuthClientCredentialsDancerBuilder encodeClientCredentialsInBody(boolean encodeClientCredentialsInBody) {
        this.encodeClientCredentialsInBody = encodeClientCredentialsInBody;
        return this;
    }

    public OAuthDancer build() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientId), (String)"clientId cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientSecret), (String)"clientSecret cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.tokenUrl), (String)"tokenUrl cannot be blank");
        return new ClientCredentialsOAuthDancer(this.clientId, this.clientSecret, this.tokenUrl, this.scopes, this.encodeClientCredentialsInBody, this.encoding, this.responseAccessTokenExpr, this.responseRefreshTokenExpr, this.responseExpiresInExpr, this.customParametersExtractorsExprs, this.lockProvider, this.tokensStore, (HttpClient)this.httpClientFactory.get(), this.expressionEvaluator);
    }
}

