/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.scheduler.SchedulerConfig;
import org.mule.runtime.core.api.scheduler.SchedulerContainerPoolsConfig;
import org.mule.runtime.core.api.scheduler.SchedulerPoolsConfigFactory;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.service.scheduler.internal.config.ContainerThreadPoolsConfig;
import org.mule.service.scheduler.internal.threads.SchedulerThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchedulerService
implements SchedulerService,
Startable,
Stoppable {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSchedulerService.class);
    private static final long DEFAULT_SHUTDOWN_TIMEOUT_MILLIS = 5000L;
    private static final int CORES = Runtime.getRuntime().availableProcessors();
    private ReadWriteLock pollsLock = new ReentrantReadWriteLock();
    private Lock pollsReadLock = this.pollsLock.readLock();
    private Lock pollsWriteLock = this.pollsLock.writeLock();
    private LoadingCache<SchedulerPoolsConfigFactory, SchedulerThreadPools> poolsByConfig;
    private Scheduler poolsMaintenanceScheduler;
    private ScheduledFuture<?> poolsMaintenanceTask;
    private volatile boolean started = false;

    public String getName() {
        return SchedulerService.class.getSimpleName();
    }

    public Scheduler cpuLightScheduler() {
        this.checkStarted();
        SchedulerConfig config = SchedulerConfig.config();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCpuLightScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    public Scheduler ioScheduler() {
        this.checkStarted();
        SchedulerConfig config = SchedulerConfig.config();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createIoScheduler(config, this.ioBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    public Scheduler cpuIntensiveScheduler() {
        this.checkStarted();
        SchedulerConfig config = SchedulerConfig.config();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCpuIntensiveScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    public Scheduler cpuLightScheduler(SchedulerConfig config) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCpuLightScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    public Scheduler ioScheduler(SchedulerConfig config) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createIoScheduler(config, this.ioBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    public Scheduler cpuIntensiveScheduler(SchedulerConfig config) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCpuIntensiveScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Inject
    public Scheduler cpuLightScheduler(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig config, SchedulerPoolsConfigFactory poolsConfigFactory) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)poolsConfigFactory)).createCpuLightScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Inject
    public Scheduler ioScheduler(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig config, SchedulerPoolsConfigFactory poolsConfigFactory) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)poolsConfigFactory)).createIoScheduler(config, this.ioBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Inject
    public Scheduler cpuIntensiveScheduler(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig config, SchedulerPoolsConfigFactory poolsConfigFactory) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)poolsConfigFactory)).createCpuIntensiveScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    private int cpuBoundWorkers() {
        return 4 * CORES;
    }

    private int ioBoundWorkers() {
        return CORES * CORES;
    }

    @Inject
    public Scheduler customScheduler(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig config) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCustomScheduler(config, CORES, this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Inject
    public Scheduler customScheduler(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig config, int queueSize) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCustomScheduler(config, CORES, this.resolveStopTimeout(config), queueSize);
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    private Supplier<Long> resolveStopTimeout(SchedulerConfig config) {
        return () -> config.getShutdownTimeoutMillis().get() != null ? (Long)config.getShutdownTimeoutMillis().get() : Long.valueOf(5000L);
    }

    private void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("Service " + this.getName() + " is not started.");
        }
    }

    public void start() throws MuleException {
        logger.info("Starting " + this.toString() + "...");
        this.pollsWriteLock.lock();
        try {
            this.poolsByConfig = CacheBuilder.newBuilder().weakKeys().removalListener((RemovalListener)new RemovalListener<SchedulerPoolsConfigFactory, SchedulerThreadPools>(){

                public void onRemoval(RemovalNotification<SchedulerPoolsConfigFactory, SchedulerThreadPools> notification) {
                    try {
                        ((SchedulerThreadPools)notification.getValue()).stop();
                        logger.info("Stopped " + this.toString());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        logger.warn("Stop of " + this.toString() + " interrupted", (Throwable)e);
                    }
                    catch (MuleException e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                }
            }).build((CacheLoader)new CacheLoader<SchedulerPoolsConfigFactory, SchedulerThreadPools>(){

                public SchedulerThreadPools load(SchedulerPoolsConfigFactory key) throws Exception {
                    SchedulerThreadPools containerThreadPools = new SchedulerThreadPools(DefaultSchedulerService.this.getName(), key.getConfig().orElse(ContainerThreadPoolsConfig.loadThreadPoolsConfig()));
                    containerThreadPools.start();
                    return containerThreadPools;
                }
            });
            logger.info("Started " + this.toString());
            this.started = true;
            this.poolsMaintenanceScheduler = this.ioScheduler();
            this.poolsMaintenanceTask = this.poolsMaintenanceScheduler.scheduleAtFixedRate(() -> this.poolsByConfig.cleanUp(), 1L, 1L, TimeUnit.MINUTES);
        }
        finally {
            this.pollsWriteLock.unlock();
        }
    }

    public void stop() throws MuleException {
        logger.info("Stopping " + this.toString() + "...");
        this.pollsWriteLock.lock();
        try {
            this.started = false;
            this.poolsMaintenanceTask.cancel(true);
            this.poolsMaintenanceScheduler.stop();
            this.poolsByConfig.invalidateAll();
            this.poolsByConfig = null;
        }
        finally {
            this.pollsWriteLock.unlock();
        }
    }

    public List<Scheduler> getSchedulers() {
        ArrayList<Scheduler> schedulers = new ArrayList<Scheduler>();
        for (SchedulerThreadPools schedulerThreadPools : this.getPools()) {
            schedulers.addAll(schedulerThreadPools.getSchedulers());
        }
        return Collections.unmodifiableList(schedulers);
    }

    public Collection<SchedulerThreadPools> getPools() {
        this.pollsReadLock.lock();
        try {
            this.poolsByConfig.cleanUp();
            Collection<SchedulerThreadPools> collection = this.poolsByConfig.asMap().values();
            return collection;
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }
}

